Attribute VB_Name = "Module1"
Option Explicit
 
Rem VpeOpenDoc() Flag Parameters:
Rem =============================
Rem Grid in Background
Global Const VPE_GRID_INBACKGROUND = 1

Rem Grid in Foreground
Global Const VPE_GRID_INFOREGROUND = 2

Rem Grid Toolbar-Button visible
Global Const VPE_GRID_TOOLBARBUTTON = 4

Rem Actually Grid visible
Global Const VPE_GRID_VISIBLE = 8

Rem Ruler NOT visible
Global Const VPE_NO_RULER = 16

Rem Toolbar NOT visible
Global Const VPE_NO_TOOLBAR = 32

Rem User can't close VPE - Stop-Button INVISIBLE and Sys-Menu disabled(if not embedded)
Rem VpeCloseDoc() works!
Global Const VPE_NO_USER_CLOSE = 64

Rem User can't leaf through the document
Global Const VPE_NO_USER_MOVE = 128

Rem User can't scale with the MOUSE (VpeSetScale() works!)
Global Const VPE_NO_MOUSE_SCALE = 256

Rem User can't scale (VpeSetScale() works!)
Global Const VPE_NO_USER_SCALE = 768

Rem Statusbar invisible
Global Const VPE_NO_STATBAR = 1024

Rem Print-Button invisible, VpePrintDoc() works
Global Const VPE_NO_PRINTBUTTON = 2048

Rem Document Window is embedded within a window of the calling application
Global Const VPE_EMBEDDED = 4096

Rem Document will be printed in Landscape-Format
Global Const VPE_LANDSCAPE = 8192

Rem Help-Button invisible
Global Const VPE_NO_HELPBTN = 32768

Rem if Help-Button visible, pressing this or pushing the F1-key
Rem will cause the message VPE_HELP to be send to the owner-window,
Rem no matter if the VPE-window is embedded or not
Global Const VPE_ROUTE_HELP = 65536

Rem Info-Button invisible
Global Const VPE_NO_INFOBTN = 131072


Global Const VPE_GRID_POSSIBLE = (VPE_GRID_INFOREGROUND + VPE_GRID_TOOLBARBUTTON)
Global Const VPE_GRID_ON = (VPE_GRID_INFOREGROUND + VPE_GRID_TOOLBARBUTTON + VPE_GRID_VISIBLE)
Global Const VPE_GRID_BKGON = (VPE_GRID_INBACKGROUND + VPE_GRID_TOOLBARBUTTON + VPE_GRID_VISIBLE)
Global Const VPE_GRID_OFF = 0





Rem VpePreviewDoc() Flag Parameters:
Rem ===============================
Global Const VPE_SHOW_NORMAL = 1
Global Const VPE_SHOW_MAXIMIZED = 2
Global Const VPE_SHOW_HIDE = 3


Rem Hatch Styles:
Rem =============
Global Const HS_NONE = -1
Rem All other HS_xxx styles are defined in windows.h
Global Const HS_HORIZONTAL = 0
Global Const HS_VERTICAL = 1
Global Const HS_FDIAGONAL = 2
Global Const HS_BDIAGONAL = 3
Global Const HS_CROSS = 4
Global Const HS_DIAGCROSS = 4



Rem Text-Formatting Attributes:
Rem ===========================
Global Const ALIGN_LEFT = 0
Global Const ALIGN_RIGHT = 1
Global Const ALIGN_CENTER = 2
Global Const ALIGN_JUSTIFIED = 3



Rem Auto-Break Options:
Rem ===================
Global Const AUTO_BREAK_ON = 0
Global Const AUTO_BREAK_OFF = 1
Global Const AUTO_BREAK_NO_LIMITS = 2



Rem Picture Attributes:
Rem ===================
Rem Merge background with bitmap (SRCAND instead of SRCCOPY)
Global Const PIC_MERGE = 1

Rem Always hold the image-data in memory
Global Const PIC_KEEPIMAGE = 2

Rem Always discard the DIB from memory (immediately after drawing)
Global Const VPE_PIC_DISCARD_DIB_DRAW = 4

Rem Always hold the DIB in memory
Global Const VPE_PIC_KEEP_DIB_PAGE = 8

Rem Scale best fitting into given rectangle
Global Const PIC_BESTFIT = 16

Rem Store image directly in file (not the pathname-link)
Global Const PIC_IN_FILE = 32




Rem ========================================================================
Rem                        Notification Messages:
Rem ========================================================================
Rem VPE was destroyed
Global Const VPE_DESTROYWINDOW = 2048 + 2306
   
Rem printing: wParam = 1: started
Rem                  = 0: ended
Rem lParam = Doc-Handle
Global Const VPE_PRINT = 2048 + 2307
                             
Rem printing: Setup-Dialog aborted
Rem lParam = Doc-Handle
Global Const VPE_PRINTCANCEL = 2048 + 2308
                             
Rem User requests help
Global Const VPE_HELP = 2048 + 2309


Rem Printer- / Setup-Flags:
Rem =======================
Rem Never show setup-dialog (if file_name is NULL, last setting
Rem or the setting of the default-printer will be taken)
Global Const PRINTDLG_NEVER = 0
                                
Rem Show setup-dialog only, if file-read fails
Global Const PRINTDLG_ONFAIL = 1

Rem show setup-dialog always
Global Const PRINTDLG_ALWAYS = 2

Rem print all pages
Global Const PRINT_ALL = 0

Rem print only even pages
Global Const PRINT_EVEN = 1

Rem print only odd pages
Global Const PRINT_ODD = 2



Rem ========================================================================
Rem                          Barcode Types:
Rem ========================================================================
Global Const BCT_EAN13 = 1
Global Const BCT_EAN8 = 2
Global Const BCT_UPCA = 3
Global Const BCT_CODABAR = 5
Global Const BCT_CODE39 = 6
Global Const BCT_2OF5 = 7
Global Const BCT_INTERLEAVED2OF5 = 8
Global Const BCT_UPCE = 9
Global Const BCT_EAN13_2 = 10
Global Const BCT_EAN13_5 = 11
Global Const BCT_EAN8_2 = 12
Global Const BCT_EAN8_5 = 13
Global Const BCT_UPCA_2 = 14
Global Const BCT_UPCA_5 = 15
Global Const BCT_UPCE_2 = 16
Global Const BCT_UPCE_5 = 17
Global Const BCT_EAN128A = 18
Global Const BCT_EAN128B = 19
Global Const BCT_EAN128C = 20
Global Const BCT_CODE93 = 21
Global Const BCT_POSTNET = 22



Rem ========================================================================
Rem                          Positioning Codes:
Rem ========================================================================
Global Const VFREE = -1
Global Const VLEFT = -2
Global Const VRIGHT = -3
Global Const VLEFTMARGIN = -4
Global Const VRIGHTMARGIN = -5
Global Const VTOP = -6
Global Const VBOTTOM = -7
Global Const VTOPMARGIN = -8
Global Const VBOTTOMMARGIN = -9



Rem ========================================================================
Rem                           Pen Styles
Rem ========================================================================
Global Const PS_SOLID = 0
Global Const PS_DASH = 1
Global Const PS_DOT = 2
Global Const PS_DASHDOT = 3
Global Const PS_DASHDOTDOT = 4



Rem ========================================================================
Rem                           Some Colors
Rem ========================================================================
Public COLOR_BLACK As Long
Public COLOR_DKGRAY As Long
Public COLOR_GRAY As Long
Public COLOR_LTGRAY As Long
Public COLOR_WHITE As Long
Public COLOR_DKRED As Long
Public COLOR_RED As Long
Public COLOR_LTRED As Long
Public COLOR_DKGREEN As Long
Public COLOR_GREEN As Long
Public COLOR_LTGREEN As Long
Public COLOR_BLUEGREEN As Long
Public COLOR_OLIVE As Long
Public COLOR_DKBLUE As Long
Public COLOR_BLUE As Long
Public COLOR_CYAN As Long
Public COLOR_DKPURPLE As Long
Public COLOR_PURPLE As Long
Public COLOR_MAGENTA As Long
Public COLOR_LTYELLOW As Long




'begin conditional compile
#If Win32 Then              '32-bit Declares

Type Rect
    Left As Long
    Top As Long
    Right As Long
    Bottom As Long
End Type


Declare Function VpeGetVersion Lib "Vpe32" () As Long
Declare Function VpeOpenDoc Lib "Vpe32" (ByVal hWndParent As Long, ByVal title As String, ByVal page_width As Long, ByVal page_height As Long, ByVal flags As Long) As Long
Declare Function VpeOpenDocFile Lib "Vpe32" (ByVal hWndParent As Long, ByVal file_name As String, ByVal title As String, ByVal page_width As Long, ByVal page_height As Long, ByVal flags As Long) As Long
Declare Function VpeCloseDoc Lib "Vpe32" (ByVal hDoc As Long) As Long
Declare Function VpeWindowHandle Lib "Vpe32" (ByVal hDoc As Long) As Long
Declare Sub VpeSetDefOutRect Lib "Vpe32" (ByVal hDoc As Long, r As Rect)
Declare Sub VpeSetDefOutRectSP Lib "Vpe32" (ByVal hDoc As Long, ByVal x As Long, ByVal y As Long, ByVal x2 As Long, ByVal y2 As Long)
Declare Sub VpeSetOutRect Lib "Vpe32" (ByVal hDoc As Long, r As Rect)
Declare Sub VpeGetOutRect Lib "Vpe32" (ByVal hDoc As Long, r As Rect)
Declare Sub VpeSetPosRect Lib "Vpe32" (ByVal hDoc As Long, r As Rect)
Declare Sub VpeGetPosRect Lib "Vpe32" (ByVal hDoc As Long, r As Rect)
Declare Sub VpeSet Lib "Vpe32" (ByVal hDoc As Long, ByVal what As Long, ByVal value As Long)
Declare Function VpeGet Lib "Vpe32" (ByVal hDoc As Long, ByVal what As Long) As Long
Declare Sub VpeStorePos Lib "Vpe32" (ByVal hDoc As Long)
Declare Sub VpeRestorePos Lib "Vpe32" (ByVal hDoc As Long)
Declare Sub VpeSetScale Lib "Vpe32" (ByVal hDoc As Long, ByVal scal As Double)
Declare Sub VpeSetRulersMeasure Lib "Vpe32" (ByVal hDoc As Long, ByVal rulers_measure As Long)
Declare Function VpeSetupPrinter Lib "Vpe32" (ByVal hDoc As Long, ByVal file_name As String, ByVal dialog_control As Long) As Long
Declare Sub VpeSetPrintOptions Lib "Vpe32" (ByVal hDoc As Long, ByVal flags As Long)
Declare Sub VpePrintDoc Lib "Vpe32" (ByVal hDoc As Long, ByVal with_setup As Long)
Declare Function VpeIsPrinting Lib "Vpe32" (ByVal hDoc As Long) As Long
Declare Sub VpePreviewDoc Lib "Vpe32" (ByVal hDoc As Long, rc As Rect, ByVal show_hide As Long)
Declare Sub VpePreviewDocSP Lib "Vpe32" (ByVal hDoc As Long, ByVal x As Long, ByVal y As Long, ByVal x2 As Long, ByVal y2 As Long, ByVal show_hide As Long)
Declare Sub VpeCenterPreview Lib "Vpe32" (ByVal hDoc As Long, ByVal width As Long, ByVal height As Long)
Declare Sub VpeSetUpdate Lib "Vpe32" (ByVal hDoc As Long, ByVal yes_no As Long)
Declare Sub VpeRefreshDoc Lib "Vpe32" (ByVal hDoc As Long)
Declare Sub VpeSetPen Lib "Vpe32" (ByVal hDoc As Long, ByVal pen_size As Long, ByVal pen_style As Long, ByVal color As Long)
Declare Sub VpeNoPen Lib "Vpe32" (ByVal hDoc As Long)
Declare Sub VpeLine Lib "Vpe32" (ByVal hDoc As Long, ByVal x As Long, ByVal y As Long, ByVal x2 As Long, ByVal y2 As Long)
Declare Function VpePolyLine Lib "Vpe32" (ByVal hDoc As Long, ByVal dummy As Long, ByVal size As Long) As Long
Declare Sub VpeAddPolyPoint Lib "Vpe32" (ByVal hDoc As Long, ByVal p As Long, ByVal x As Long, ByVal y As Long)
Declare Function VpePolygon Lib "Vpe32" (ByVal hDoc As Long, ByVal dummy As Long, ByVal size As Long) As Long
Declare Sub VpeAddPolygonPoint Lib "Vpe32" (ByVal hDoc As Long, ByVal p As Long, ByVal x As Long, ByVal y As Long)
Declare Sub VpeSetBkgColor Lib "Vpe32" (ByVal hDoc As Long, ByVal color As Long)
Declare Sub VpeSetTransparentMode Lib "Vpe32" (ByVal hDoc As Long, ByVal on_off As Long)
Declare Sub VpeSetHatchStyle Lib "Vpe32" (ByVal hDoc As Long, ByVal style As Long)
Declare Sub VpeSetHatchColor Lib "Vpe32" (ByVal hDoc As Long, ByVal color As Long)
Declare Sub VpeBox Lib "Vpe32" (ByVal hDoc As Long, ByVal x As Long, ByVal y As Long, ByVal x2 As Long, ByVal y2 As Long)
Declare Sub VpeEllipse Lib "Vpe32" (ByVal hDoc As Long, ByVal x As Long, ByVal y As Long, ByVal x2 As Long, ByVal y2 As Long)
Declare Sub VpePie Lib "Vpe32" (ByVal hDoc As Long, ByVal x As Long, ByVal y As Long, ByVal x2 As Long, ByVal y2 As Long, ByVal begin_angle As Long, ByVal end_angle As Long)
Declare Sub VpeSetBarcodeParms Lib "Vpe32" (ByVal hDoc As Long, ByVal top_bottom As Long, ByVal add_top_bottom As Long)
Declare Sub VpeBarcode Lib "Vpe32" (ByVal hDoc As Long, ByVal x As Long, ByVal y As Long, ByVal x2 As Long, ByVal y2 As Long, ByVal code_type As Long, ByVal code As String, ByVal add_code As String)
Declare Sub VpeKeepBitmapAspect Lib "Vpe32" (ByVal hDoc As Long, ByVal on_off As Long)
Declare Sub VpeDefaultBitmapDPI Lib "Vpe32" (ByVal hDoc As Long, ByVal dpix As Long, ByVal dpiy As Long)
Declare Sub VpeGetPictureTypes Lib "Vpe32" (ByVal with_filters As Long, s As String, ByVal size As Long)
Declare Sub VpePicture Lib "Vpe32" (ByVal hDoc As Long, ByVal x As Long, ByVal y As Long, ByVal x2 As Long, ByVal y2 As Long, ByVal file_name As String, ByVal flags As Long)
Declare Sub VpePictureDIB Lib "Vpe32" (ByVal hDoc As Long, ByVal x As Long, ByVal y As Long, ByVal x2 As Long, ByVal y2 As Long, ByVal hDIB As Long, ByVal flags As Long)
Declare Sub VpePictureResID Lib "Vpe32" (ByVal hDoc As Long, ByVal x As Long, ByVal y As Long, ByVal x2 As Long, ByVal y2 As Long, ByVal hInstance As Long, ByVal res_id As Long, ByVal flags As Long)
Declare Sub VpePictureResName Lib "Vpe32" (ByVal hDoc As Long, ByVal x As Long, ByVal y As Long, ByVal x2 As Long, ByVal y2 As Long, ByVal hInstance As Long, ByVal res_name As String, ByVal flags As Long)
Declare Sub VpeSelectFont Lib "Vpe32" (ByVal hDoc As Long, ByVal name As String, ByVal size As Long)
Declare Sub VpeSetFontAttr Lib "Vpe32" (ByVal hDoc As Long, ByVal alignment As Long, ByVal bold As Long, ByVal underlined As Long, ByVal italic As Long)
Declare Sub VpeSetAlign Lib "Vpe32" (ByVal hDoc As Long, ByVal alignment As Long)
Declare Sub VpeSetBold Lib "Vpe32" (ByVal hDoc As Long, ByVal bold As Long)
Declare Sub VpeSetUnderlined Lib "Vpe32" (ByVal hDoc As Long, ByVal underlined As Long)
Declare Sub VpeSetItalic Lib "Vpe32" (ByVal hDoc As Long, ByVal italic As Long)
Declare Sub VpeSetTextColor Lib "Vpe32" (ByVal hDoc As Long, ByVal color As Long)
Declare Function VpePrint Lib "Vpe32" (ByVal hDoc As Long, ByVal x As Long, ByVal y As Long, ByVal s As String) As Long
Declare Function VpePrintBox Lib "Vpe32" (ByVal hDoc As Long, ByVal x As Long, ByVal y As Long, ByVal s As String) As Long
Declare Function VpeWrite Lib "Vpe32" (ByVal hDoc As Long, ByVal x As Long, ByVal y As Long, ByVal x2 As Long, ByVal y2 As Long, ByVal s As String) As Long
Declare Function VpeWriteBox Lib "Vpe32" (ByVal hDoc As Long, ByVal x As Long, ByVal y As Long, ByVal x2 As Long, ByVal y2 As Long, ByVal s As String) As Long
Declare Sub VpeDefineHeader Lib "Vpe32" (ByVal hDoc As Long, ByVal x As Long, ByVal y As Long, ByVal x2 As Long, ByVal y2 As Long, ByVal s As String)
Declare Sub VpeDefineFooter Lib "Vpe32" (ByVal hDoc As Long, ByVal x As Long, ByVal y As Long, ByVal x2 As Long, ByVal y2 As Long, ByVal s As String)
Declare Sub VpePageBreak Lib "Vpe32" (ByVal hDoc As Long)
Declare Function VpeGetPageCount Lib "Vpe32" (ByVal hDoc As Long) As Long
Declare Function VpeGetCurrentPage Lib "Vpe32" (ByVal hDoc As Long) As Long
Declare Sub VpeGotoPage Lib "Vpe32" (ByVal hDoc As Long, ByVal page As Long)
Declare Sub VpeStoreSet Lib "Vpe32" (ByVal hDoc As Long, ByVal id As Long)
Declare Sub VpeUseSet Lib "Vpe32" (ByVal hDoc As Long, ByVal id As Long)
Declare Sub VpeRemoveSet Lib "Vpe32" (ByVal hDoc As Long, ByVal id As Long)
Declare Sub VpeSetAutoBreak Lib "Vpe32" (ByVal hDoc As Long, ByVal mode As Long)
Declare Sub VpeWriteDoc Lib "Vpe32" (ByVal hDoc As Long, ByVal file_name As String)
Declare Sub VpeReadDoc Lib "Vpe32" (ByVal hDoc As Long, ByVal file_name As String)
Declare Sub VpeSetRotation Lib "Vpe32" (ByVal hDoc As Long, ByVal angle As Long)

#Else

Type Rect
    Left As Integer
    Top As Integer
    Right As Integer
    Bottom As Integer
End Type


Declare Function VpeGetVersion Lib "VPEngine" () As Integer
Declare Function VpeOpenDoc Lib "VPEngine" (ByVal hWndParent As Integer, ByVal title As String, ByVal page_width As Integer, ByVal page_height As Integer, ByVal flags As Long) As Long
Declare Function VpeOpenDocFile Lib "VPEngine" (ByVal hWndParent As Integer, ByVal file_name As String, ByVal title As String, ByVal page_width As Integer, ByVal page_height As Integer, ByVal flags As Long) As Long
Declare Function VpeCloseDoc Lib "VPEngine" (ByVal hDoc As Long) As Integer
Declare Function VpeWindowHandle Lib "VPEngine" (ByVal hDoc As Long) As Integer
Declare Sub VpeSetDefOutRect Lib "VPEngine" (ByVal hDoc As Long, r As Rect)
Declare Sub VpeSetDefOutRectSP Lib "VPEngine" (ByVal hDoc As Long, ByVal x As Integer, ByVal y As Integer, ByVal x2 As Integer, ByVal y2 As Integer)
Declare Sub VpeSetOutRect Lib "VPEngine" (ByVal hDoc As Long, r As Rect)
Declare Sub VpeGetOutRect Lib "VPEngine" (ByVal hDoc As Long, r As Rect)
Declare Sub VpeSetPosRect Lib "VPEngine" (ByVal hDoc As Long, r As Rect)
Declare Sub VpeGetPosRect Lib "VPEngine" (ByVal hDoc As Long, r As Rect)
Declare Sub VpeSet Lib "VPEngine" (ByVal hDoc As Long, ByVal what As Integer, ByVal value As Integer)
Declare Function VpeGet Lib "VPEngine" (ByVal hDoc As Long, ByVal what As Integer) As Integer
Declare Sub VpeStorePos Lib "VPEngine" (ByVal hDoc As Long)
Declare Sub VpeRestorePos Lib "VPEngine" (ByVal hDoc As Long)
Declare Sub VpeSetScale Lib "VPEngine" (ByVal hDoc As Long, ByVal scal As Double)
Declare Sub VpeSetRulersMeasure Lib "VPEngine" (ByVal hDoc As Long, ByVal rulers_measure As Integer)
Declare Function VpeSetupPrinter Lib "VPEngine" (ByVal hDoc As Long, ByVal file_name As String, ByVal dialog_control As Integer) As Integer
Declare Sub VpeSetPrintOptions Lib "VPEngine" (ByVal hDoc As Long, ByVal flags As Integer)
Declare Sub VpePrintDoc Lib "VPEngine" (ByVal hDoc As Long, ByVal with_setup As Integer)
Declare Function VpeIsPrinting Lib "VPEngine" (ByVal hDoc As Long) As Integer
Declare Sub VpePreviewDoc Lib "VPEngine" (ByVal hDoc As Long, rc As Rect, ByVal show_hide As Integer)
Declare Sub VpePreviewDocSP Lib "VPEngine" (ByVal hDoc As Long, ByVal x As Integer, ByVal y As Integer, ByVal x2 As Integer, ByVal y2 As Integer, ByVal show_hide As Integer)
Declare Sub VpeCenterPreview Lib "VPEngine" (ByVal hDoc As Long, ByVal width As Integer, ByVal height As Integer)
Declare Sub VpeSetUpdate Lib "VPEngine" (ByVal hDoc As Long, ByVal yes_no As Integer)
Declare Sub VpeRefreshDoc Lib "VPEngine" (ByVal hDoc As Long)
Declare Sub VpeSetPen Lib "VPEngine" (ByVal hDoc As Long, ByVal pen_size As Integer, ByVal pen_style As Integer, ByVal color As Long)
Declare Sub VpeNoPen Lib "VPEngine" (ByVal hDoc As Long)
Declare Sub VpeLine Lib "VPEngine" (ByVal hDoc As Long, ByVal x As Integer, ByVal y As Integer, ByVal x2 As Integer, ByVal y2 As Integer)
Declare Function VpePolyLine Lib "VPEngine" (ByVal hDoc As Long, ByVal dummy As Long, ByVal size As Integer) As Long
Declare Sub VpeAddPolyPoint Lib "VPEngine" (ByVal hDoc As Long, ByVal p As Long, ByVal x As Integer, ByVal y As Integer)
Declare Function VpePolygon Lib "VPEngine" (ByVal hDoc As Long, ByVal dummy As Long, ByVal size As Integer) As Long
Declare Sub VpeAddPolygonPoint Lib "VPEngine" (ByVal hDoc As Long, ByVal p As Long, ByVal x As Integer, ByVal y As Integer)
Declare Sub VpeSetBkgColor Lib "VPEngine" (ByVal hDoc As Long, ByVal color As Long)
Declare Sub VpeSetTransparentMode Lib "VPEngine" (ByVal hDoc As Long, ByVal on_off As Integer)
Declare Sub VpeSetHatchStyle Lib "VPEngine" (ByVal hDoc As Long, ByVal style As Integer)
Declare Sub VpeSetHatchColor Lib "VPEngine" (ByVal hDoc As Long, ByVal color As Long)
Declare Sub VpeBox Lib "VPEngine" (ByVal hDoc As Long, ByVal x As Integer, ByVal y As Integer, ByVal x2 As Integer, ByVal y2 As Integer)
Declare Sub VpeEllipse Lib "VPEngine" (ByVal hDoc As Long, ByVal x As Integer, ByVal y As Integer, ByVal x2 As Integer, ByVal y2 As Integer)
Declare Sub VpePie Lib "VPEngine" (ByVal hDoc As Long, ByVal x As Integer, ByVal y As Integer, ByVal x2 As Integer, ByVal y2 As Integer, ByVal begin_angle As Integer, ByVal end_angle As Integer)
Declare Sub VpeSetBarcodeParms Lib "VPEngine" (ByVal hDoc As Long, ByVal top_bottom As Integer, ByVal add_top_bottom As Integer)
Declare Sub VpeBarcode Lib "VPEngine" (ByVal hDoc As Long, ByVal x As Integer, ByVal y As Integer, ByVal x2 As Integer, ByVal y2 As Integer, ByVal code_type As Integer, ByVal code As String, ByVal add_code As String)
Declare Sub VpeKeepBitmapAspect Lib "VPEngine" (ByVal hDoc As Long, ByVal on_off As Integer)
Declare Sub VpeDefaultBitmapDPI Lib "VPEngine" (ByVal hDoc As Long, ByVal dpix As Integer, ByVal dpiy As Integer)
Declare Sub VpeGetPictureTypes Lib "VPEngine" (ByVal with_filters As Integer, s As String, ByVal size As Integer)
Declare Sub VpePicture Lib "VPEngine" (ByVal hDoc As Long, ByVal x As Integer, ByVal y As Integer, ByVal x2 As Integer, ByVal y2 As Integer, ByVal file_name As String, ByVal flags As Integer)
Declare Sub VpePictureDIB Lib "VPEngine" (ByVal hDoc As Long, ByVal x As Integer, ByVal y As Integer, ByVal x2 As Integer, ByVal y2 As Integer, ByVal hDIB As Integer, ByVal flags As Integer)
Declare Sub VpePictureResID Lib "VPEngine" (ByVal hDoc As Long, ByVal x As Integer, ByVal y As Integer, ByVal x2 As Integer, ByVal y2 As Integer, ByVal hInstance As Integer, ByVal res_id As Integer, ByVal flags As Integer)
Declare Sub VpePictureResName Lib "VPEngine" (ByVal hDoc As Long, ByVal x As Integer, ByVal y As Integer, ByVal x2 As Integer, ByVal y2 As Integer, ByVal hInstance As Integer, ByVal res_name As String, ByVal flags As Integer)
Declare Sub VpeSelectFont Lib "VPEngine" (ByVal hDoc As Long, ByVal name As String, ByVal size As Integer)
Declare Sub VpeSetFontAttr Lib "VPEngine" (ByVal hDoc As Long, ByVal alignment As Integer, ByVal bold As Integer, ByVal underlined As Integer, ByVal italic As Integer)
Declare Sub VpeSetAlign Lib "VPEngine" (ByVal hDoc As Long, ByVal alignment As Integer)
Declare Sub VpeSetBold Lib "VPEngine" (ByVal hDoc As Long, ByVal bold As Integer)
Declare Sub VpeSetUnderlined Lib "VPEngine" (ByVal hDoc As Long, ByVal underlined As Integer)
Declare Sub VpeSetItalic Lib "VPEngine" (ByVal hDoc As Long, ByVal italic As Integer)
Declare Sub VpeSetTextColor Lib "VPEngine" (ByVal hDoc As Long, ByVal color As Long)
Declare Function VpePrint Lib "VPEngine" (ByVal hDoc As Long, ByVal x As Integer, ByVal y As Integer, ByVal s As String) As Integer
Declare Function VpePrintBox Lib "VPEngine" (ByVal hDoc As Long, ByVal x As Integer, ByVal y As Integer, ByVal s As String) As Integer
Declare Function VpeWrite Lib "VPEngine" (ByVal hDoc As Long, ByVal x As Integer, ByVal y As Integer, ByVal x2 As Integer, ByVal y2 As Integer, ByVal s As String) As Integer
Declare Function VpeWriteBox Lib "VPEngine" (ByVal hDoc As Long, ByVal x As Integer, ByVal y As Integer, ByVal x2 As Integer, ByVal y2 As Integer, ByVal s As String) As Integer
Declare Sub VpeDefineHeader Lib "VPEngine" (ByVal hDoc As Long, ByVal x As Integer, ByVal y As Integer, ByVal x2 As Integer, ByVal y2 As Integer, ByVal s As String)
Declare Sub VpeDefineFooter Lib "VPEngine" (ByVal hDoc As Long, ByVal x As Integer, ByVal y As Integer, ByVal x2 As Integer, ByVal y2 As Integer, ByVal s As String)
Declare Sub VpePageBreak Lib "VPEngine" (ByVal hDoc As Long)
Declare Function VpeGetPageCount Lib "VPEngine" (ByVal hDoc As Long) As Integer
Declare Function VpeGetCurrentPage Lib "VPEngine" (ByVal hDoc As Long) As Integer
Declare Sub VpeGotoPage Lib "VPEngine" (ByVal hDoc As Long, ByVal page As Integer)
Declare Sub VpeStoreSet Lib "VPEngine" (ByVal hDoc As Long, ByVal id As Integer)
Declare Sub VpeUseSet Lib "VPEngine" (ByVal hDoc As Long, ByVal id As Integer)
Declare Sub VpeRemoveSet Lib "VPEngine" (ByVal hDoc As Long, ByVal id As Integer)
Declare Sub VpeSetAutoBreak Lib "VPEngine" (ByVal hDoc As Long, ByVal mode As Integer)
Declare Sub VpeWriteDoc Lib "VPEngine" (ByVal hDoc As Long, ByVal file_name As String)
Declare Sub VpeReadDoc Lib "VPEngine" (ByVal hDoc As Long, ByVal file_name As String)
Declare Sub VpeSetRotation Lib "VPEngine" (ByVal hDoc As Long, ByVal angle As Integer)

#End If



Public Sub InitVPE()

 COLOR_BLACK = RGB(0, 0, 0)
 COLOR_DKGRAY = RGB(128, 128, 128)
 COLOR_GRAY = RGB(192, 192, 192)
 COLOR_LTGRAY = RGB(230, 230, 230)
 COLOR_WHITE = RGB(255, 255, 255)
 COLOR_DKRED = RGB(128, 0, 0)
 COLOR_RED = RGB(192, 0, 0)
 COLOR_LTRED = RGB(255, 0, 0)
 COLOR_DKGREEN = RGB(0, 128, 0)
 COLOR_GREEN = RGB(0, 192, 0)
 COLOR_LTGREEN = RGB(0, 255, 0)
 COLOR_BLUEGREEN = RGB(0, 128, 128)
 COLOR_OLIVE = RGB(128, 128, 0)
 COLOR_DKBLUE = RGB(0, 0, 128)
 COLOR_BLUE = RGB(0, 0, 255)
 COLOR_CYAN = RGB(0, 255, 255)
 COLOR_DKPURPLE = RGB(128, 0, 128)
 COLOR_PURPLE = RGB(192, 0, 192)
 COLOR_MAGENTA = RGB(255, 0, 255)
 COLOR_LTYELLOW = RGB(255, 255, 0)

End Sub
