{$A+,B-,D-,F-,G+,I-,K+,L-,N-,P-,Q-,R-,S-,T-,V-,W-,X+,Y-}
{$M 8192,8192}
program MiniDemo;

uses WinTypes,WinProcs,
      {$IFDEF VER80} {Units for Delphi}
       SysUtils,
       Messages,
      {$ELSE}
       Strings,      {Units for BP7}
      {$ENDIF}
      VPEngine;

var DemoText : array [0..1024] of char;

procedure SetDemoText;
begin
StrCat(StrCat(StrCat(StrCat(StrCat(StrCat(StrCat(StrCat(StrCat(StrCat(StrCat(StrCat(StrCat(StrCat(StrCopy(
DemoText,'[PS 3 S 12 C Black J BO]The moment of impact bursts through the silence and in a roar of sound, the '),
'final second is prolonged in a world of echoes as if concrete and clay of '),
'Broadway itself was reliving its memories.'+#13+#10),
'The last great march past. Newsman stands limp as a whimper as audience and '),
'eventare locked as one. Bing Crosby coos''You don''t have to feel pain '),
'to sing the blues, you don''t have to holla - you don''t feel a thing in your '),
'dollar collar.'' Martin Luther cries ''Everybody Sing!'' and rings the grand old '),
'liberty bell. Leary, weary of his prison cell, walks on heaven, talks on hell.'+#13+#10),
'Who needs Medicare and the 35c flat rate fare, when Fred Astaire and '),
'Ginger Rogers are dancing through the air? From Broadway Melody stereotypes '),
'the band returns to ''Stars and Stripes'' bringing a tear to the moonshiner, '),
'who''s been pouring out his spirit from the illegal still. The pawn broker '),
'clears the noisy till and clutches his lucky dollar bill.'+#13+#10),
'Then the blackout.'+#13+#10+#13+#10),
'(Genesis, ''The Lamb lies down on Broadway'')');

end;
{// ========================================================================
//                              MiniDemo
// ========================================================================}
procedure MiniDemoProc(Window : HWnd);
var hdoc : LongInt;
begin

   hdoc := VpeOpenDoc(Window, 'Mini Demo',-1, -1, 0);
   VpeWriteBox(hdoc, 100, 100, 500, 200, '[PS 0 B C LtRed]Hello');
   VpePrint(hdoc, 100, 250, '[''Times New Roman'' S 30 C Blue]World!');
   VpeWriteBox(hdoc, 100, 450, 1900, -1, DemoText);

   VpePreviewDoc(hdoc, nil, VPE_SHOW_NORMAL);

end;




{// ========================================================================
//                              WndProc
// ========================================================================}
function WndProc(Window : HWnd;message : Word;wParam : Word;lParam : LongInt) : LongInt;export;
begin
   WndProc := 0;
   case message of
	  WM_CREATE : MiniDemoProc(Window);
     VPE_DESTROYWINDOW,
     WM_DESTROY: PostQuitMessage(0);
   else WndProc := DefWindowProc (Window, message, wParam, lParam) ;
  end; {case }
end;


{// ========================================================================
//                              WinMain
//
// Create a hidden Main Window
// ========================================================================}
const szAppName  = 'Mini Demo';

procedure WinMain;
var Msg :TMsg ;
var Window : HWnd;
var wndclass  : TWndClass;

begin
   if hPrevInst =0 then
   begin
      wndclass.style         := CS_HREDRAW or CS_VREDRAW ;
      wndclass.lpfnWndProc   := @WndProc ;
      wndclass.cbClsExtra    := 0 ;
      wndclass.cbWndExtra    := 0 ;
      wndclass.hInstance     := hInstance ;
      wndclass.hIcon         := LoadIcon (hInstance, 'APP_ICON');
      wndclass.hCursor       := LoadCursor (0, IDC_ARROW) ;
      wndclass.hbrBackground := GetStockObject (WHITE_BRUSH) ;
      wndclass.lpszMenuName  := szAppName ;
      wndclass.lpszClassName := szAppName ;
      RegisterClass (wndclass) ;
   end;

   Window := CreateWindow (szAppName, szAppName,
			WS_OVERLAPPEDWINDOW,
			CW_USEDEFAULT, CW_USEDEFAULT,
			CW_USEDEFAULT, CW_USEDEFAULT,
			0, 0, hInstance, nil) ;

   while GetMessage (msg, 0, 0, 0) do
   begin
      TranslateMessage (msg) ;
      DispatchMessage (msg) ;
   end;

   Halt(msg.wParam);
end;

begin
  SetDemoText;
  WinMain;
end.
