unit VPEngine;

{
  VPENGINE.PAS
  ============

  Common definitions for the "Virtual Print Engine"
  Copyright (c) 1993-1996 by IDEAL Software, T. Radde
}


interface

{$IFDEF VER80}
  uses
    WinProcs, WinTypes, Messages;

  const
    VPEDLL='VPENGINE';

  type HGLOBAL = integer;

{$ELSE}

{$IFDEF VER90}
  uses
    Windows, Messages;

  const
    VPEDLL='VPE32.DLL';
{$ELSE}

  uses
    Winprocs, Wintypes;

  const
    VPEDLL='VPENGINE';

  type HGLOBAL = integer;

{$ENDIF}
{$ENDIF}


Const

  { VpeOpenDoc() Flag Parameters: }
  VPE_GRID_INBACKGROUND  = 1;      {Grid in Background}
  VPE_GRID_INFOREGROUND  = 2;      {Grid in Foreground}
  VPE_GRID_TOOLBARBUTTON = 4;      {Grid Toolbar-Button visible}
  VPE_GRID_VISIBLE       = 8;      {Actually Grid visible}

  VPE_NO_RULER           = 16;     {Ruler NOT visible}
  VPE_NO_TOOLBAR         = 32;     {Toolbar NOT visible}
  VPE_NO_USER_CLOSE      = 64;     {User can't close VPE -}
                                   {Stop-Button INVISIBLE and Sys-Menu }
                                   {disabled (if not embedded) }
                                   {VpeCloseDoc() works! }
  VPE_NO_USER_MOVE       = 128;    {User can't leaf through the document}
                                   {in future: then no Page-Seg in Statusbar }
  VPE_NO_MOUSE_SCALE     = 256;    {User can't scale with the MOUSE (VpeSetScale() works!)}
  VPE_NO_USER_SCALE      = (512 or VPE_NO_MOUSE_SCALE);
                                   {User can't scale (VpeSetScale() works!)}
                                   {in future: then no Scale-Seg in Statusbar }

  VPE_NO_STATBAR         = 1024;   {Statusbar invisible}

  VPE_NO_PRINTBUTTON     = 2048;   {Print-Button invisible}
                                   {VpePrintDoc() works}

  VPE_EMBEDDED           = 4096;   {Document Window is embedded within}
                                   {a window of the calling application }
  VPE_LANDSCAPE          = 8192;   {Document will be printed in Landscape-Format}
  VPE_NO_HELPBTN         = 32768;  {Help-Button invisible}
  VPE_ROUTE_HELP         = 65536;  {if Help-Button visible, pressing this or pushing the F1-key}
                                   {will cause the message VPE_HELP to be send to the owner-window, }
                                   {no matter if the VPE-window is embedded or not }
  VPE_NO_INFOBTN         = 131072; {Info-Button invisible}

  VPE_GRID_POSSIBLE      = (VPE_GRID_INFOREGROUND or VPE_GRID_TOOLBARBUTTON);
  VPE_GRID_ON            = (VPE_GRID_INFOREGROUND or VPE_GRID_TOOLBARBUTTON or VPE_GRID_VISIBLE);
  VPE_GRID_BKGON         = (VPE_GRID_INBACKGROUND or VPE_GRID_TOOLBARBUTTON or VPE_GRID_VISIBLE);
  VPE_GRID_OFF           = 0;

  { VpePreviewDoc() Flag Parameters: }
  VPE_SHOW_NORMAL        = 1;
  VPE_SHOW_MAXIMIZED     = 2;
  VPE_SHOW_HIDE          = 3;

  { Hatch Styles: }
  HS_NONE                = -1;
{ All other HS_xxx styles are defined in windows.h:
  HS_HORIZONTAL        0
  HS_VERTICAL          1
  HS_FDIAGONAL         2
  HS_BDIAGONAL         3
  HS_CROSS             4
  HS_DIAGCROSS         5 }

  { Text-Formatting Attributes: }
  ALIGN_LEFT             = 0;
  ALIGN_RIGHT            = 1;
  ALIGN_CENTER           = 2;
  ALIGN_JUSTIFIED        = 3;

  { Auto-Break Options: }
  AUTO_BREAK_ON          = 0;
  AUTO_BREAK_OFF         = 1;
  AUTO_BREAK_NO_LIMITS   = 2;


  { Picture Attributes: }
  PIC_MERGE            = 1;     {merge background with bitmap (SRCAND instead of SRCCOPY)}
  PIC_KEEPIMAGE        = 2;     {always hold the image data in memory}
  PIC_DISCARD_DIB_DRAW = 4;     {always discard the DIB from memory (immediately after drawing)}
  PIC_KEEP_DIB_PAGE    = 8;     {always hold the DIB in memory}
  PIC_BESTFIT          = 16;    {scale best fitting into given rectangle}
  PIC_IN_FILE          = 32;    {store image directly in file (not the pathname-link)}


{ ========================================================================
                          Printer- / Setup-Flags:
  ========================================================================}
  PRINTDLG_NEVER  = 0;       {never show setup-dialog (if file_name is NULL, last setting
                              or the setting of the default-printer will be taken)}
  PRINTDLG_ONFAIL = 1;       {show setup-dialog only, if file-read fails}
  PRINTDLG_ALWAYS = 2;       {show setup-dialog always}

  PRINT_ALL       = 0;       {print all pages}
  PRINT_EVEN      = 1;       {print only even pages}
  PRINT_ODD       = 2;       {print only odd pages}


  { ======================================================================== }
  { Notification Messages:                                                   }
  { ======================================================================== }
  VPE_DESTROYWINDOW      = WM_USER + 2306;
  VPE_PRINT              = WM_USER + 2307;
  VPE_PRINTCANCEL        = WM_USER + 2308;
  VPE_HELP               = WM_USER + 2309;


  { ======================================================================== }
  { Barcode Types:                                                           }
  { ======================================================================== }
  BCT_EAN13              = 1;
  BCT_EAN8               = 2;
  BCT_UPCA               = 3;
  BCT_CODABAR            = 5;
  BCT_CODE39             = 6;
  BCT_2OF5               = 7;
  BCT_INTERLEAVED2OF5    = 8;
  BCT_UPCE               = 9;
  BCT_EAN13_2            = 10;
  BCT_EAN13_5            = 11;
  BCT_EAN8_2             = 12;
  BCT_EAN8_5             = 13;
  BCT_UPCA_2             = 14;
  BCT_UPCA_5             = 15;
  BCT_UPCE_2             = 16;
  BCT_UPCE_5             = 17;
  BCT_EAN128A            = 18;
  BCT_EAN128B            = 19;
  BCT_EAN128C            = 20;
  BCT_CODE93             = 21;
  BCT_POSTNET            = 22;

  { ======================================================================== }
  { Positioning Codes:                                                       }
  { ======================================================================== }
  VFREE                  = -1;
  VLEFT                  = -2;
  VRIGHT                 = -3;
  VLEFTMARGIN            = -4;
  VRIGHTMARGIN           = -5;
  VTOP                   = -6;
  VBOTTOM                = -7;
  VTOPMARGIN             = -8;
  VBOTTOMMARGIN          = -9;

{$IFDEF VER90}
{ =================================================================
                            32 Bit
  =================================================================}

  function VpeGetVersion: Integer; stdcall;

  function VpeOpenDoc(hWndParent: HWND;
                      title: PChar;
                      page_width: Integer;
                      page_height: Integer;
                      flags: LongInt): LongInt; stdcall;

  function VpeOpenDocFile(hWndParent: HWND;
                          file_name: PChar;
                          title: PChar;
                          page_width: Integer;
                          page_height: Integer;
                          flags: LongInt): LongInt; stdcall;

  function VpeCloseDoc(hDoc: LongInt): LongInt; stdcall;

  function VpeWindowHandle(hDoc: LongInt): HWND; stdcall;

  procedure VpeSetDefOutRect(hDoc: LongInt;
                             r: PRECT); stdcall;

  procedure VpeSetDefOutRectSP(hDoc: LongInt;
                               x,y,x2,y2: Integer); stdcall;


  procedure VpeSetOutRect(hDoc: LongInt;
                             r: PRECT); stdcall;

  procedure VpeGetOutRect(hDoc: LongInt;
                             r: PRECT); stdcall;

  procedure VpeSetPosRect(hDoc: LongInt;
                          r: PRECT); stdcall;

  procedure VpeGetPosRect(hDoc: LongInt;
                          r: PRECT); stdcall;

  procedure VpeSet(hDoc: LongInt;
                   what: Integer;
                   value: Integer); stdcall;

  function VpeGet(hDoc: LongInt;
                  what: Integer): Integer; stdcall;

  procedure VpeStorePos(hDoc: LongInt); stdcall;

  procedure VpeRestorePos(hDoc: LongInt); stdcall;

  procedure VpeSetScale(hDoc: LongInt;
                        scale: Double); stdcall;

  procedure VpeSetRulersMeasure(hDoc: LongInt;
                               rulers_measure: Integer); stdcall;

  function VpeSetupPrinter(hDoc: LongInt;
                           file_name: PChar;
                           dialog_control: Integer): Integer; stdcall;

  procedure VpeSetPrintOptions(hDoc: LongInt;
                              flags: LongInt); stdcall;

  procedure VpePrintDoc(hDoc: LongInt;
                        with_setup: integer);  stdcall;

  function VpeIsPrinting(hDoc: LongInt): Integer; stdcall;

  procedure VpePreviewDoc(hDoc: LongInt;
                          rc: PRECT;
                          show_hide: Integer); stdcall;

  procedure VpePreviewDocSP(hDoc: LongInt;
                            x,y,x2,y2:Integer;
                            show_hide: Integer); stdcall;

  procedure VpeCenterPreview(hDoc: LongInt;
                             width,height: Integer;
                             parent_window: HWND); stdcall;

  procedure VpeSetUpdate(hDoc: LongInt;
                         yes_no: Integer); stdcall;

  procedure VpeRefreshDoc(hDoc: LongInt); stdcall;

  procedure VpeSetPen(hDoc: LongInt;
                      pen_size: Integer;
                      pen_style: Integer;
                      color: TColorRef); stdcall;

  procedure VpeNoPen(hDoc: LongInt); stdcall;

  procedure VpeLine(hDoc: Longint;
                    x: Integer;
                    y: Integer;
                    x2: Integer;
                    y2: Integer); StdCall;

  function VpePolyLine(hDoc: LongInt;
                       p: LongInt;
                       size: integer): LongInt; stdcall;

  procedure VpeAddPolyPoint(hDoc: LongInt;
                            p: LongInt;
                            x: Integer;
                            y: Integer); stdcall;

  function VpePolygon(hDoc: LongInt;
                       pt: LongInt;
                       size: Integer): LongInt; stdcall;

  procedure VpeAddPolygonPoint(hDoc: LongInt;
                               p: Longint;
                               x,y: Integer); stdcall;

  procedure VpeSetBkgColor(hDoc: LongInt;
                           color: TColorRef); stdcall;

  procedure VpeSetTransparentMode(hDoc: LongInt;
                                  on_off: Integer); stdcall;

  procedure VpeSetHatchStyle(hDoc: LongInt;
                             style: Integer); stdcall;

  procedure VpeSetHatchColor(hDoc: LongInt;
                             color: TCOLORREF); stdcall;

  procedure VpeBox(hDoc: LongInt;
                   x: Integer;
                   y: Integer;
                   x2: Integer;
                   y2: Integer); stdcall;

  procedure VpeEllipse(hDoc: LongInt;
                       x,y,x2,y2: Integer); stdcall;

  procedure VpePie(hDoc: LongInt;
                   x,y,x2,y2: Integer;
                   begin_angle, end_angle: Integer); stdcall;


  procedure VpeSetBarcodeParms(hDoc: LongInt;
                               top_bottom: integer;
                               add_top_bottom: integer); stdcall;

  procedure VpeBarcode(hDoc: LongInt;
                       x: Integer;
                       y: Integer;
                       x2: Integer;
                       y2: Integer;
                       code_type: Integer;
                       code: PChar;
                       add_code: PChar); stdcall;

  procedure VpeKeepBitmapAspect(hdoc: LongInt;
                                on_off: Integer); stdcall;

  procedure VpeDefaultBitmapDPI(hdoc: LongInt;
                                dpix: Integer;
                                dpiy: Integer); stdcall;

  procedure VpeGetPictureTypes(with_filters: integer;
                               s: PChar;
                               size: integer); stdcall;

  procedure VpePicture(hDoc: LongInt;
                       x: Integer;
                       y: Integer;
                       x2: Integer;
                       y2: Integer;
                       file_name: PChar;
                       flags: Integer); stdcall;

  procedure VpePictureDIB(hDoc: LongInt;
                          x,y,x2,y2: Integer;
                          hDIB: HGLOBAL;
                          flags: Integer); stdcall;

  procedure VpePictureResID(hDoc: LongInt;
                            x,y,x2,y2: Integer;
                            hInstance: LongInt;
                            res_id: Integer;
                            flags: Integer); stdcall;

  procedure VpePictureResName(hDoc: LongInt;
                              x,y,x2,y2:Integer;
                              hInstance:LongInt;
                              res_name: PChar;
                              flags: Integer); stdcall;

  procedure VpeSelectFont(hDoc: LongInt;
                          name: PChar;
                          size: Integer); stdcall;

  procedure VpeSetFontAttr(hDoc: LongInt;
                           alignment: Integer;
                           bold: Integer;
                           underlined: Integer;
                           italic: Integer); stdcall;

  procedure VpeSetAlign(hDoc: LongInt;
                        alignment: Integer); stdcall;

  procedure VpeSetBold(hDoc: LongInt;
                       bold: Integer); stdcall;

  procedure VpeSetUnderlined(hDoc: LongInt;
                             underlined: Integer); stdcall;

  procedure VpeSetItalic(hDoc: LongInt;
                         italic: Integer); stdcall;

  procedure VpeSetTextColor(hdoc: LongInt;
                            color: TColorRef); stdcall;

  function VpePrint(h: LongInt;
                    x: Integer;
                    y: Integer;
                    s: PChar): Integer; Stdcall;

  function VpePrintBox(h: LongInt;
                       x: Integer;
                       y: Integer;
                       s: PChar): Integer; stdcall;

  function VpeWrite(h: LongInt;
                    x: Integer;
                    y: Integer;
                    x2: Integer;
                    y2: Integer;
                    s: PChar): Integer; stdcall;

  function VpeWriteBox(hDoc: LongInt;
                       x: Integer;
                       y: Integer;
                       x2: Integer;
                       y2: Integer;
                       s: PChar): Integer; stdcall;

  procedure VpeDefineHeader(hDoc: LongInt;
                            x: Integer;
                            y: Integer;
                            x2: Integer;
                            y2: Integer;
                            s: PChar); stdcall;

  procedure VpeDefineFooter(hDoc: LongInt;
                            x: Integer;
                            y: Integer;
                            x2: Integer;
                            y2: Integer;
                            s: PChar); stdcall;

  procedure VpePageBreak(hDoc: LongInt); stdcall;

  function VpeGetPageCount(hdoc: LongInt): Integer; stdcall;

  function VpeGetCurrentPage(hDoc: LongInt): Integer; stdcall;

  procedure VpeGotoPage(hDoc: LongInt;
                        page: Integer); stdcall;

  procedure VpeStoreSet(hDoc: LongInt;
                        id: Integer); stdcall;

  procedure VpeUseSet(hDoc: LongInt;
                      id: Integer); stdcall;

  procedure VpeRemoveSet(hDoc: LongInt;
                         id: Integer); stdcall;

  procedure VpeSetAutoBreak(hDoc: LongInt;
                            on_off: Integer); stdcall;

  procedure VpeWriteDoc(hDoc: LongInt;
                        file_name: PChar); stdcall;

  procedure VpeReadDoc(hDoc: LongInt;
                        file_name: PChar); stdcall;

  procedure VpeSetRotation(hDoc: LongInt;
                           angle: Integer); stdcall;

{$ELSE}
{ =================================================================
                            16 Bit
  =================================================================}

  function VpeGetVersion: Integer;

  function VpeOpenDoc(hWndParent: HWND;
                      title: PChar;
                      page_width: Integer;
                      page_height: Integer;
                      flags: LongInt): LongInt;

  function VpeOpenDocFile(hWndParent: HWND;
                          file_name: PChar;
                          title: PChar;
                          page_width: Integer;
                          page_height: Integer;
                          flags: LongInt): LongInt;

  function VpeCloseDoc(hDoc: LongInt): LongInt;

  function VpeWindowHandle(hDoc: LongInt): HWND;

  procedure VpeSetDefOutRect(hDoc: LongInt;
                             r: PRECT);

  procedure VpeSetDefOutRectSP(hDoc: LongInt;
                               x,y,x2,y2: Integer);


  procedure VpeSetOutRect(hDoc: LongInt;
                             r: PRECT);

  procedure VpeGetOutRect(hDoc: LongInt;
                             r: PRECT);

  procedure VpeSetPosRect(hDoc: LongInt;
                          r: PRECT);

  procedure VpeGetPosRect(hDoc: LongInt;
                          r: PRECT);

  procedure VpeSet(hDoc: LongInt;
                   what: Integer;
                   value: Integer);

  function VpeGet(hDoc: LongInt;
                  what: Integer): Integer;

  procedure VpeStorePos(hDoc: LongInt);

  procedure VpeRestorePos(hDoc: LongInt);

  procedure VpeSetScale(hDoc: LongInt;
                        scale: Double);

  procedure VpeSetRulersMeasure(hDoc: LongInt;
                               rulers_measure: Integer);

  function VpeSetupPrinter(hDoc: LongInt;
                           file_name: PChar;
                           dialog_control: Integer): Integer;

  procedure VpeSetPrintOptions(hDoc: LongInt;
                              flags: LongInt);

  procedure VpePrintDoc(hDoc: LongInt;
                        with_setup: integer);

  function VpeIsPrinting(hDoc: LongInt): Integer;

  procedure VpePreviewDoc(hDoc: LongInt;
                          rc: PRECT;
                          show_hide: Integer);

  procedure VpePreviewDocSP(hDoc: LongInt;
                            x,y,x2,y2:Integer;
                            show_hide: Integer);

  procedure VpeCenterPreview(hDoc: LongInt;
                             width,height: Integer;
                             parent_window: HWND);

  procedure VpeSetUpdate(hDoc: LongInt;
                         yes_no: Integer);

  procedure VpeRefreshDoc(h: LongInt);

  procedure VpeSetPen(hDoc: LongInt;
                      pen_size: Integer;
                      pen_style: Integer;
                      color: TColorRef);

  procedure VpeNoPen(hDoc: LongInt);

  procedure VpeLine(hDoc: Longint;
                    x: Integer;
                    y: Integer;
                    x2: Integer;
                    y2: Integer);

  function VpePolyLine(hDoc: LongInt;
                       p: LongInt;
                       size: Word): LongInt;

  procedure VpeAddPolyPoint(hDoc: LongInt;
                            p: LongInt;
                            x: Integer;
                            y: Integer);

  function VpePolygon(hDoc: LongInt;
                       p: LongInt;
                       size: Integer): LongInt;

  procedure VpeAddPolygonPoint(hDoc: LongInt;
                               p: Longint;
                               x,y: Integer);

  procedure VpeSetBkgColor(hDoc: LongInt;
                           color: TColorRef);

  procedure VpeSetTransparentMode(hDoc: LongInt;
                                  on_off: Integer);

  procedure VpeSetHatchStyle(hDoc: LongInt;
                             style: Integer);

  procedure VpeSetHatchColor(hDoc: LongInt;
                             color: TCOLORREF);

  procedure VpeBox(hDoc: LongInt;
                   x: Integer;
                   y: Integer;
                   x2: Integer;
                   y2: Integer);

  procedure VpeEllipse(hDoc: LongInt;
                       x,y,x2,y2: Integer);

  procedure VpePie(hDoc: LongInt;
                   x,y,x2,y2: Integer;
                   begin_angle, end_angle: Integer);


  procedure VpeSetBarcodeParms(hdoc: LongInt;
                               top_bottom: integer;
                               add_top_bottom: integer);

  procedure VpeBarcode(h: LongInt;
                       x: Integer;
                       y: Integer;
                       x2: Integer;
                       y2: Integer;
                       code_type: Integer;
                       code: PChar;
                       add_code: PChar);

  procedure VpeKeepBitmapAspect(hdoc: LongInt;
                                on_off: Integer);

  procedure VpeDefaultBitmapDPI(hdoc: LongInt;
                                dpix: Integer;
                                dpiy: Integer);

  procedure VpeGetPictureTypes(with_filters: integer;
                               s: PChar;
                               size: integer);

  procedure VpePicture(hDoc: LongInt;
                       x: Integer;
                       y: Integer;
                       x2: Integer;
                       y2: Integer;
                       file_name: PChar;
                       flags: Integer);

  procedure VpePictureDIB(hDoc: LongInt;
                          x,y,x2,y2: Integer;
                          hDIB: HGLOBAL;
                          flags: Integer);

  procedure VpePictureResID(hDoc: LongInt;
                            x,y,x2,y2: Integer;
                            hInstance: Integer;
                            res_id: Integer;
                            flags: Integer);

  procedure VpePictureResName(hDoc: LongInt;
                              x,y,x2,y2:Integer;
                              hInstance:Integer;
                              res_name: PChar;
                              flags: Integer);

  procedure VpeSelectFont(hDoc: LongInt;
                          name: PChar;
                          size: Integer);

  procedure VpeSetFontAttr(hDoc: LongInt;
                           alignment: Integer;
                           bold: Integer;
                           underlined: Integer;
                           italic: Integer);

  procedure VpeSetAlign(hDoc: LongInt;
                        alignment: Integer);

  procedure VpeSetBold(hDoc: LongInt;
                       bold: Integer);

  procedure VpeSetUnderlined(hDoc: LongInt;
                             underlined: Integer);

  procedure VpeSetItalic(hDoc: LongInt;
                         italic: Integer);

  procedure VpeSetTextColor(hdoc: LongInt;
                            color: TColorRef);

  function VpePrint(h: LongInt;
                    x: Integer;
                    y: Integer;
                    s: PChar): Integer;

  function VpePrintBox(h: LongInt;
                       x: Integer;
                       y: Integer;
                       s: PChar): Integer;

  function VpeWrite(h: LongInt;
                    x: Integer;
                    y: Integer;
                    x2: Integer;
                    y2: Integer;
                    s: PChar): Integer;

  function VpeWriteBox(hDoc: LongInt;
                       x: Integer;
                       y: Integer;
                       x2: Integer;
                       y2: Integer;
                       s: PChar): Integer;

  procedure VpeDefineHeader(hDoc: LongInt;
                            x: Integer;
                            y: Integer;
                            x2: Integer;
                            y2: Integer;
                            s: PChar);

  procedure VpeDefineFooter(hDoc: LongInt;
                            x: Integer;
                            y: Integer;
                            x2: Integer;
                            y2: Integer;
                            s: PChar);

  procedure VpePageBreak(hDoc: LongInt);

  function VpeGetPageCount(hdoc: LongInt): Integer;

  function VpeGetCurrentPage(hDoc: LongInt): Integer;

  procedure VpeGotoPage(hDoc: LongInt;
                        page: Integer);

  procedure VpeStoreSet(hDoc: LongInt;
                        id: Integer);

  procedure VpeUseSet(hDoc: LongInt;
                      id: Integer);

  procedure VpeRemoveSet(hDoc: LongInt;
                         id: Integer);

  procedure VpeSetAutoBreak(hDoc: LongInt;
                            on_off: Integer);

  procedure VpeWriteDoc(hDoc: LongInt;
                        file_name: PChar);

  procedure VpeReadDoc(hDoc: LongInt;
                        file_name: PChar);

  procedure VpeSetRotation(hDoc: LongInt;
                           angle: Integer);

{$ENDIF}


var
   COLOR_BLACK : longint;
   COLOR_DKGRAY : longint;
   COLOR_GRAY : longint;
   COLOR_LTGRAY : longint;
   COLOR_WHITE : longint;
   COLOR_DKRED : longint;
   COLOR_RED : longint;
   COLOR_LTRED : longint;
   COLOR_DKGREEN : longint;
   COLOR_GREEN : longint;
   COLOR_LTGREEN : longint;
   COLOR_BLUEGREEN : longint;
   COLOR_OLIVE : longint;
   COLOR_DKBLUE : longint;
   COLOR_BLUE : longint;
   COLOR_CYAN : longint;
   COLOR_DKPURPLE : longint;
   COLOR_PURPLE : longint;
   COLOR_MAGENTA : longint;
   COLOR_LTYELLOW : longint;

implementation

function VpeGetVersion; external VPEDLL;
function VpeOpenDoc; external VPEDLL;
function VpeOpenDocFile; external VPEDLL;
function VpeCloseDoc; external VPEDLL;
function VpeWindowHandle; external VPEDLL;
procedure VpeSetDefOutRect; external VPEDLL;
procedure VpeSetDefOutRectSP; external VPEDLL;
procedure VpeSetOutRect; external VPEDLL;
procedure VpeGetOutRect; external VPEDLL;
procedure VpeSetPosRect; external VPEDLL;
procedure VpeGetPosRect; external VPEDLL;
procedure VpeSet; external VPEDLL;
function VpeGet; external VPEDLL;
procedure VpeStorePos; external VPEDLL;
procedure VpeRestorePos; external VPEDLL;
procedure VpeSetScale; external VPEDLL;
function VpeSetupPrinter; external VPEDLL;
procedure VpeSetPrintOptions; external VPEDLL;
procedure VpePrintDoc; external VPEDLL;
function VpeIsPrinting; external VPEDLL;
procedure VpePreviewDoc; external VPEDLL;
procedure VpePreviewDocSP; external VPEDLL;
procedure VpeCenterPreview; external VPEDLL;
procedure VpeSetUpdate; external VPEDLL;
procedure VpeRefreshDoc; external VPEDLL;
procedure VpeSetPen; external VPEDLL;
procedure VpeNoPen; external VPEDLL;
procedure VpeLine; external VPEDLL;
function VpePolyLine; external VPEDLL;
procedure VpeAddPolyPoint; external VPEDLL;
function VpePolygon; external VPEDLL;
procedure VpeAddPolygonPoint; external VPEDLL;
procedure VpeSetBkgColor; external VPEDLL;
procedure VpeSetTransparentMode; external VPEDLL;
procedure VpeBox; external VPEDLL;
procedure VpeSetBarcodeParms; external VPEDLL;
procedure VpeBarcode; external VPEDLL;
procedure VpeKeepBitmapAspect; external VPEDLL;
procedure VpeDefaultBitmapDPI; external VPEDLL;
procedure VpeGetPictureTypes; external VPEDLL;
procedure VpePicture; external VPEDLL;
procedure VpeSelectFont; external VPEDLL;
procedure VpeSetFontAttr; external VPEDLL;
procedure VpeSetAlign; external VPEDLL;
procedure VpeSetBold; external VPEDLL;
procedure VpeSetUnderlined; external VPEDLL;
procedure VpeSetItalic; external VPEDLL;
procedure VpeSetTextColor; external VPEDLL;
function VpePrint; external VPEDLL;
function VpePrintBox; external VPEDLL;
function VpeWrite; external VPEDLL;
function VpeWriteBox; external VPEDLL;
procedure VpeDefineHeader; external VPEDLL;
procedure VpeDefineFooter; external VPEDLL;
procedure VpePageBreak; external VPEDLL;
function VpeGetPageCount; external VPEDLL;
function VpeGetCurrentPage; external VPEDLL;
procedure VpeGotoPage; external VPEDLL;
procedure VpeStoreSet; external VPEDLL;
procedure VpeUseSet; external VPEDLL;
procedure VpeRemoveSet; external VPEDLL;
procedure VpeSetRulersMeasure; external VPEDLL;
procedure VpeSetAutoBreak; external VPEDLL;
procedure VpeSetRotation; external VPEDLL;
procedure VpeReadDoc; external VPEDLL;
procedure VpeWriteDoc; external VPEDLL;
procedure VpePictureResName; external VPEDLL;
procedure VpePictureResID; external VPEDLL;
procedure VpePictureDIB; external VPEDLL;
procedure VpeSetHatchColor; external VPEDLL;
procedure VpeSetHatchStyle; external VPEDLL;
procedure VpePie; external VPEDLL;
procedure VpeEllipse; external VPEDLL;

{$IFDEF VER80}
initialization
{$ELSE}
begin
{$ENDIF}

  { ========================================================================= }
  { Color-Definitions                                                         }
  { ========================================================================= }
  COLOR_BLACK     := RGB(0, 0, 0);
  COLOR_DKGRAY    := RGB(128, 128, 128);
  COLOR_GRAY      := RGB(192, 192, 192);
  COLOR_LTGRAY    := RGB(230, 230, 230);
  COLOR_WHITE     := RGB(255, 255, 255);
  COLOR_DKRED     := RGB(128, 0, 0);
  COLOR_RED       := RGB(192, 0, 0);
  COLOR_LTRED     := RGB(255, 0, 0);
  COLOR_DKGREEN   := RGB(0, 128, 0);
  COLOR_GREEN     := RGB(0, 192, 0);
  COLOR_LTGREEN   := RGB(0, 255, 0);
  COLOR_BLUEGREEN := RGB(0, 128, 128);
  COLOR_OLIVE     := RGB(128, 128, 0);
  COLOR_DKBLUE    := RGB(0, 0, 128);
  COLOR_BLUE      := RGB(0, 0, 255);
  COLOR_CYAN      := RGB(0, 255, 255);
  COLOR_DKPURPLE  := RGB(128, 0, 128);
  COLOR_PURPLE    := RGB(192, 0, 192);
  COLOR_MAGENTA   := RGB(255, 0, 255);
  COLOR_LTYELLOW  := RGB(255, 255, 0);
end.
