unit Unit1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, VPENGINE, StdCtrls, Menus, ExtCtrls;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    GenerateData1: TMenuItem;
    DeleteReport1: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    Demos1: TMenuItem;
    CapabilitiesPrecision1: TMenuItem;
    SpeedTables1: TMenuItem;
    Colors1: TMenuItem;
    Report1: TMenuItem;
    PrintinBackground1: TMenuItem;
    CloseColors1: TMenuItem;
    Label1: TLabel;
    AutoRender1: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure CapabilitiesPrecision1Click(Sender: TObject);
    procedure GenerateData1Click(Sender: TObject);
    procedure DeleteReport1Click(Sender: TObject);
    procedure SpeedTables1Click(Sender: TObject);
    procedure Colors1Click(Sender: TObject);
    procedure Report1Click(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure PrintinBackground1Click(Sender: TObject);
    procedure CloseColors1Click(Sender: TObject);
    procedure AutoRender1Click(Sender: TObject);
  private
    { Private declarations }
    procedure AppOnMessage(var Msg: TMsg; var Handled: boolean);
    procedure VPEHelp(var Msg: TMsg); message VPE_HELP;  {VPE sends this message to the form, not the application}
    procedure WMKeyDown(var Msg: TWMKeyDown); message WM_KEYDOWN;
  public
    { Public declarations }
    CanClose : byte;
    DemoText : PChar;
    PrecisionHDoc : longint;
    PBackGndHDoc : longint;
    ReportHDoc : longint;
    ColorsHDoc : longint;
    SpeedHDoc : longint;
    AutoRenderHDoc : longint;
    procedure Precision(const Mode : integer);
    procedure ReportTest;
    procedure ColorTest;
  end;

var
  Form1: TForm1;

implementation

uses Unit2;

{$R *.DFM}
function pow(x:double; n:byte):double;
var
  m : byte;
  f : double;
begin
  try
    m := n;
    case m of
      0 : f := 1.0;
      1 : f := x;
      else f := x * pow(x, m - 1);
    end; { case }
    if (n < 0) then
      Result := 1.0 / f
    else
      Result := f;
  except
      on EZeroDivide do
        Result := 0;
  end;
end;

procedure MakeDemoText(ZString : PChar);
begin
  StrCopy(ZString, 'The moment of impact bursts through the silence and in a roar of sound, the');
  StrCat(ZString, 'final second is prolonged in a world of echoes as if concrete and clay of');
  StrCat(ZString, 'Broadway itself was reliving its memories.' + #10);
  StrCat(ZString, 'The last great march past. Newsman stands limp as a whimper as audience and');
  StrCat(ZString, 'eventare locked as one. Bing Crosby coos''You don''t have to feel pain');
  StrCat(ZString, 'to sing the blues, you don''t have to holla - you don''t feel a thing in your');
  StrCat(ZString, 'dollar collar.'' Martin Luther cries ''Everybody Sing!'' and rings the grand old');
  StrCat(ZString, 'liberty bell. Leary, weary of his prison cell, walks on heaven, talks on hell.' + #10);
  StrCat(ZString, 'Who needs Medicare and the 35c flat rate fare, when Fred Astaire and');
  StrCat(ZString, 'Ginger Rogers are dancing through the air? From Broadway Melody stereotypes');
  StrCat(ZString, 'the band returns to ''Stars and Stripes'' bringing a tear to the moonshiner,');
  StrCat(ZString, 'who''s been pouring out his spirit from the illegal still. The pawn broker');
  StrCat(ZString, 'clears the noisy till and clutches his lucky dollar bill.' + #10);
  StrCat(ZString, 'Then the blackout.' + #10 + #10);
  StrCat(ZString, '(Genesis, ''The Lamb lies down on Broadway'')');
end;

{===Precision===}
const
  HEADLINE = 1;

{Page 1 of Precision demo}
procedure page1(hdoc: longint);
var
  Page1Text : PChar;
  y : integer;
begin
  Page1Text := StrAlloc(2048);
  try
    StrCopy(Page1Text, '[Center PenSize 3]This demo shows the capabilities and precision of VPE.'+#10);
    StrCat(Page1Text, 'Print this page and compare not only the ');
    StrCat(Page1Text, 'positions of the frames,'+#10+'but the positions of each letter that can be seen.'+#10);
    StrCat(Page1Text, '(Switch the grid on.)'+#10);
    StrCat(Page1Text, 'This is true WYSIWYG !!!'+#10+'(''What you see is what you get'')'+#10);
    StrCat(Page1Text, 'Note, that the nearest result can be seen at a scaling of 1:1.'+#10);
    StrCat(Page1Text, 'With every other scaling you get ''best results'' in comparison to execution speed.');
    y := VpeWriteBox(hdoc, 575, 200, 1625, -1, Page1Text);

    StrCopy(Page1Text, '[''Arial'' FontSize 14 Left Bold Italic Underline PenSize 0]');
    StrCat(Page1Text, 'RIGHT ALIGNED, 0.25 cm blue frame, light-blue backgr., red bold text, Arial 9pt');
    y := VpeWriteBox(hdoc, 100, y + 75, 2000, -1, Page1Text);

    VpeStoreSet(hdoc, HEADLINE);

    VpeSelectFont(hdoc, 'Arial', 9);
    VpeSetPen(hdoc, 25, PS_SOLID, COLOR_BLUE);
    VpeSetTextColor(hdoc, COLOR_LTRED);
    VpeSetFontAttr(hdoc, ALIGN_RIGHT, 1, 0, 0);
    VpeSetTransparentMode(hdoc, 0);
    VpeSetBkgColor(hdoc, COLOR_CYAN);
    {// y+30 because frame = 0.25cm --> frame drawn around center of coordinates}
    {// we also want a little gap between the headline and the frame}
    y := VpeWriteBox(hdoc, 150, y + 30, 1850, -1, Form1.DemoText);
    VpeSetTransparentMode(hdoc, 1);

    VpeUseSet(hdoc, HEADLINE);
    y := VpeWrite(hdoc, 250, y + 75, 2000, -1, 'JUSTIFIED, no frame, Times New Roman 11pt');

    VpeSelectFont(hdoc, 'Times New Roman', 11);
    VpeSetFontAttr(hdoc, ALIGN_JUSTIFIED, 0, 0, 0);
    y := VpeWriteBox(hdoc, 250, y + 20, 1550, -1, Form1.DemoText);

    VpeUseSet(hdoc, HEADLINE);
    y := VpeWriteBox(hdoc, 250, y + 75, 2000, -1, 'CENTERED, thin yellow frame, Times New Roman 11pt');

    VpeSelectFont(hdoc, 'Times New Roman', 11);
    VpeSetFontAttr(hdoc, ALIGN_CENTER, 0, 0, 0);
    VpeSetPen(hdoc, 5, PS_SOLID, COLOR_LTYELLOW);
    y := VpeWriteBox(hdoc, 150, y + 20, 1850, -1, Form1.DemoText);
  finally
    StrDispose(Page1Text);
  end;
end;

{Page 2 of Precision demo}
procedure Page2(hdoc : longint);
const
  xr : double = 6;
  yr : double = 18;
  index : integer = 0;
  skip : integer = 0;
  first : integer = 0;
  oldy : integer = 0;
  segments : integer = 0;
type
  TPointArray = array[0..0] of TPoint;
  TPointPtr = ^TPointArray;
var
  y : integer;
  x : double;
  xx: integer;
  xstep : double;
  s : array[0..159] of char;
  s2: array[0..10] of char;
  p : longint;
  points : TPointPtr;
begin
  VpePageBreak(hdoc);
  VpeUseSet(hdoc, HEADLINE);
  y := VpeWriteBox(hdoc, 200, 200, 2000, -1, 'An example of drawing (better to turn the grid off here):');
  VpeSetPen(hdoc, 8, PS_SOLID, COLOR_BLACK);
  VpeBox(hdoc, 200, 300, 1700, 1800);
  VpeSetPen(hdoc, 3, PS_SOLID, COLOR_BLACK);

  xstep := xr / 750;

  {   // The following graph is created with VpeAddPolyPoint() }
  x := -xr;
  skip := 0;
  VpeSetPen(hdoc, 2, PS_SOLID, COLOR_BLUE);
  p := VpePolyLine(hdoc, 0, 1500);

  for xx := 200 to 1699 do
  begin
    y := trunc(1050 - (pow(x, 3) - 2*pow(x, 2) - 8*x) / ( yr / 750));
    x := x+xstep;

    if (y < 300) then
    begin
       y := 300;
       skip := 1;
       continue;
    end
    else if (y > 1800) then
    begin
       y := 1800;
       skip := 1;
       continue;
    end;

    if (skip = 1) then
    begin
       VpeAddPolyPoint(hdoc, p, -1, -1);
       oldy := y;
       skip := 2;
    end
    else
    begin
       if (skip = 2) then
       begin
          VpeAddPolyPoint(hdoc, p, xx-1, oldy);
          skip := 0;
       end;
       VpeAddPolyPoint(hdoc, p, xx, y);
       inc(segments);
    end;
  end;

  {   // The following graph is created directly with VpePolyLine() }

  {$R-} {Range checking off for dynamic array}
  GetMem(points, 3 * 1500 * sizeof(TPoint));
  try
    x := -xr;
    first := 1;
    VpeSetPen(hdoc, 2, PS_SOLID, COLOR_LTRED);
    index := 0;
    for xx := 200 to 1699 do
    begin
      y := trunc(1050 - (3*pow(x, 2) - 4*x - 8) / ( yr / 750));
      x := x + xstep;

      if (y < 300) then
      begin
         y := 300;
         skip := 1;
         continue;
      end
      else if (y > 1800) then
      begin
         y := 1800;
         skip := 1;
         continue;
      end;

      if (skip = 1) then
      begin
         if (index > 0) then  { // Array must not begin with -1,-1 pair! }
         begin
            points^[index].x := -1;
            points^[index].y := -1;
         end;
        { // don't increment index here, so we don't have multiple }
        { // (redundant AND FORBIDDEN) -1, -1 pairs in the array }
         oldy := y;
         skip := 2;
      end
      else
      begin
         if (skip = 2) then
         begin
            if (index > 0) then
               inc(index);
            points^[index].x := xx - 1;
            points^[index].y := oldy;
            inc(index);
            skip := 0;
         end;
         points^[index].x := xx;
         points^[index].y := y;
         inc(index);
         inc(segments);
      end;
    end;

    VpePolyLine(hdoc, longint(points), index);
  finally
    FreeMem(points, 3 * 1500 * sizeof(TPoint));
  end;
  {$R+}
  {Range checking back on}

  { // The following graph is created "manually" VpeLine() }
  { // Never use it for such tasks, it's slow and memory exhausting }
  { // in comparision to VpePolyLine() }
  x := -xr;
  first := 1;
  VpeSetPen(hdoc, 2, PS_SOLID, COLOR_GREEN);
  for xx := 200 to 1699 do
  begin
    y := trunc(1050 - (3*x - 4) / ( yr / 750));
    x := x + xstep;

    if (y < 300) then
    begin
       y := 300;
       first := 1;
       continue;
    end
    else if (y > 1800) then
    begin
       y := 1800;
       first := 1;
       continue;
    end;

    if (first = 1) then
       oldy := y
    else
    begin
       VpeLine(hdoc, xx-1, oldy, xx, y);
       inc(segments);
       oldy := y;
    end;
    first := 0;
  end;

  VpeSetPen(hdoc, 3, PS_SOLID, COLOR_BLACK);
  VpeLine(hdoc, 200, 1050, 1700, 1050);
  VpeLine(hdoc, 950, 300, 950, 1800);

  VpeSelectFont(hdoc, 'Arial', 10);
  VpeSetFontAttr(hdoc, ALIGN_LEFT, 0, 0, 0);
  VpeSetPen(hdoc, 1, PS_DOT, COLOR_BLACK);
  for xx := 1 to trunc(xr) - 1 do
  begin
    VpeLine(hdoc, 950 + xx * 750 div 6, 300, 950 + xx * 750 div 6, 1800);
    Str(xx, s);
    VpePrint(hdoc, 960 + xx * 750 div 6, 1050, s);
    VpeLine(hdoc, 950 - xx * 750 div 6, 300, 950 - xx * 750 div 6, 1800);
    Str(-xx, s);
    VpePrint(hdoc, 960 - xx * 750 div 6, 1050, s);
  end;

  y := 2;
  while y < yr - 1 do
  begin
    VpeLine(hdoc, 200, trunc(1050 + y * 750 / yr), 1700, trunc(1050 + y * 750 / yr));
    Str(y, s);
    VpePrint(hdoc, 960, trunc(1050 - y * 750 / yr), s);
    VpeLine(hdoc, 200, trunc(1050 - y * 750 / yr), 1700, trunc(1050 - y * 750 / yr));
    Str(-y, s);
    VpePrint(hdoc, 960, trunc(1050 + y * 750 / yr), s);
    inc(y, 2);
  end;

  y := 1850;
  Str(segments, s2);
  StrCat(s, '[S 14]The three graphs together consist of ');
  StrCat(s, s2);
  StrCat(s, ' (number determined during runtime) single lines!'+#10+#10+'VPE manages this data bulk for you FAST!');
  VpeWrite(hdoc, 200, y, 2000, -1, s);
end;

{Page 3 and 4 of Precision demo}
procedure Page3_4(hdoc : longint);
var y: integer;
begin
  VpePageBreak(hdoc);

  VpeNoPen(hdoc);
  VpeSetFontAttr(hdoc, ALIGN_CENTER, 0, 1, 0);
  VpeSelectFont(hdoc, 'Arial', 18);
  VpeWrite(hdoc, 0, 150, 2100, 300, 'The supported barcode-types:');
  VpeSelectFont(hdoc, 'Arial', 10);
  VpeSetBold(hdoc, 1);

  VpeWrite(hdoc, 200, 300, 550, 400, '2 of 5:');
  VpeBarcode(hdoc, 200, 360, 550, 560, BCT_2OF5, '123789', nil);

  VpeWrite(hdoc, 700, 300, 1200, 400, 'Interleaved 2 of 5:');
  VpeBarcode(hdoc, 700, 360, 1200, 560, BCT_INTERLEAVED2OF5, '123895783482', nil);

  VpeWrite(hdoc, 1350, 300, 1750, 400, 'Code 39 (text on top):');
  VpeSetBarcodeParms(hdoc, 1, 0);
  VpeBarcode(hdoc, 1350, 360, 1750, 560, BCT_CODE39, 'ABC123', nil);

  VpeWrite(hdoc, 200, 700, 550, 800, 'Code 93 (rotated):');
  VpeSetBarcodeParms(hdoc, 0, 0);
  VpeSetRotation(hdoc, 900);
  VpeBarcode(hdoc, 275, 760, -300, -200, BCT_CODE93, 'DEF987', nil);

  VpeWrite(hdoc, 700, 700, 1200, 800, '[Rot 0]Codabar (rotated):');
  VpeSetRotation(hdoc, 1800);
  VpeBarcode(hdoc, 700, 760, -500, -200, BCT_CODABAR, '123456', nil);

  VpeWrite(hdoc, 1400, 700, 1700, 800, '[Rot 0]EAN-8 (rotated):');
  VpeSetRotation(hdoc, 2700);
  VpeBarcode(hdoc, 1450, 760, -300, -200, BCT_EAN8, '40167794', nil);

  VpeWrite(hdoc, 200, 1200, 500, 1400, '[Rot 0]EAN-8 + 2:');
  VpeSetBarcodeParms(hdoc, 0, 1);
  VpeBarcode(hdoc, 200, 1260, 500, 1460, BCT_EAN8_2, '12345670', '12');

  VpeWrite(hdoc, 700, 1200, 1200, 1400, 'EAN-8 + 5:');
  VpeSetBarcodeParms(hdoc, 0, 0);
  VpeBarcode(hdoc, 700, 1260, 1200, 1460, BCT_EAN8_5, '98765430', '12345');

  VpeWrite(hdoc, 1350, 1200, 1750, 1400, 'EAN-13:');
  VpeBarcode(hdoc, 1350, 1260, 1750, 1460, BCT_EAN13, '9781556153952', nil);

  VpeWrite(hdoc, 200, 1600, 600, 1800, 'EAN-13 + 2:');
  VpeBarcode(hdoc, 200, 1660, 600, 1860, BCT_EAN13_2, '4501645096787', '12');

  VpeWrite(hdoc, 700, 1600, 1200, 1800, 'EAN-13 + 5:');
  VpeSetBarcodeParms(hdoc, 0, 1);
  VpeBarcode(hdoc, 700, 1660, 1200, 1860, BCT_EAN13_5, '9781556153952', '12345');

  VpeWrite(hdoc, 1350, 1600, 1750, 1800, 'EAN-128 A:');
  VpeSetBarcodeParms(hdoc, 0, 0);
  VpeBarcode(hdoc, 1350, 1660, 1750, 1860, BCT_EAN128A, 'EAN-128 A', nil);

  VpeWrite(hdoc, 200, 2000, 600, 2200, 'EAN-128 B:');
  VpeBarcode(hdoc, 200, 2060, 600, 2260, BCT_EAN128B, 'ean-128 b', nil);

  VpeWrite(hdoc, 700, 2000, 1200, 2200, 'EAN-128 C:');
  VpeBarcode(hdoc, 700, 2060, 1200, 2260, BCT_EAN128C, '128902', nil);

  VpeWrite(hdoc, 1350, 2000, 1850, 2200, 'POSTNET (1.20) 5 or 9 digits:');
  VpeBarcode(hdoc, 1350, 2060, 1628, 2120, BCT_POSTNET, '12345', nil);
  VpeBarcode(hdoc, 1350, 2150, 1850, 2210, BCT_POSTNET, '414649623', nil);

  VpePageBreak(hdoc);

  VpeSetFontAttr(hdoc, ALIGN_CENTER, 0, 1, 0);
  VpeSelectFont(hdoc, 'Arial', 18);
  VpeWrite(hdoc, 0, 150, 2100, 300, 'The supported barcode-types (continued):');
  VpeSelectFont(hdoc, 'Arial', 10);
  VpeSetBold(hdoc, 1);

  VpeWrite(hdoc, 200, 300, 550, 400, 'UPC-A:');
  VpeBarcode(hdoc, 200, 360, 550, 560, BCT_UPCA, '07447079382', nil);

  VpeWrite(hdoc, 700, 300, 1100, 400, 'UPC-A + 2:');
  VpeBarcode(hdoc, 700, 360, 1100, 560, BCT_UPCA_2, '07447079382', '01');

  VpeWrite(hdoc, 1350, 300, 1800, 400, 'UPC-A + 5:');
  VpeBarcode(hdoc, 1350, 360, 1800, 560, BCT_UPCA_5, '03126764825', '94687');

  VpeWrite(hdoc, 200, 700, 550, 900, 'UPC-E:');
  VpeBarcode(hdoc, 200, 760, 550, 960, BCT_UPCE, '0378492', nil);

  VpeWrite(hdoc, 700, 700, 1100, 900, 'UPC-E + 2:');
  VpeBarcode(hdoc, 700, 760, 1100, 960, BCT_UPCE_2, '0378492', '14');

  VpeWrite(hdoc, 1350, 700, 1800, 900, 'UPC-E + 5:');
  VpeBarcode(hdoc, 1350, 760, 1800, 960, BCT_UPCE_5, '0364825', '79462');

  VpeSetFontAttr(hdoc, ALIGN_LEFT, 0, 0, 0);
  y:= VpeWrite(hdoc, 200, 1100, 1800, VFREE,
          'VPE supports 21 barcode types. Barcodes can be rotated in 90 degree steps, the '+
          'text can be drawn on bottom or top of the barcode, and also independently '+
          'the add-on text. Any of these features can be combined.');

  y := VpePrint(hdoc, 500, y+100, '[S 24 U C LtYellow]Text and images');
  VpePrint(hdoc, VRIGHT, VBOTTOM, '[Rot 900 C Blue] can be freely ');
  VpeWriteBox(hdoc, 500, VBOTTOM, VLEFT, VFREE, '[Rot 1800 C Red CE]rotated in 90');

  { The WIDTH (after rotation it's the height) is the top of the last inserted text
    minus the bottom of the first inserted object.}
  VpeWriteBox(hdoc, 400, y, -(VpeGet(hdoc, VTOP) - y), VFREE, '[Rot 2700 C Green]degree steps');
end;

{Page 5 of Precision demo}
procedure Page5(hdoc : longint);
var
  y, y2, x : integer;
  Page5Text : PChar;
  p : LongInt;
begin
  VpePageBreak(hdoc);
  VpeUseSet(hdoc, HEADLINE);
  y := VpeWriteBox(hdoc, 100, 200, 2000, -1,
                 'VPE is also able to manage bitmaps for you!'+#10+
                 'Place your logo wherever you want.');
  y := VpeWriteBox(hdoc, 100, y, 1400, -1,
     '[S 10 L BO IO UO](Note: These are 256-color bitmaps, in 16-color mode it doesn''t look very good)');

  y := VpeWriteBox(hdoc, 100, y + 50, 1400, -1, '[N B U]VPE supports the following graphics file formats:');
  Page5Text := StrAlloc(1024);
  try
     StrCopy(Page5Text, '-Windows and OS/2 Bitmaps (2 / 16 / 256 / True Color)'+#10);
     StrCat(Page5Text,  '-Windows WMF (Metafile)'+#10);
     StrCat(Page5Text,  '-AutoCAD DXF'+#10);
     StrCat(Page5Text,  '-GIF (2 / 16 / 256 Colors)'+#10);
     StrCat(Page5Text,  '-PCX (2 / 16 / 256 Colors)'+#10);
     StrCat(Page5Text,  '-JPG (256 / True Color)'+#10);
     StrCat(Page5Text,  '-TIFF 5.0 (2 / 16 / 256 / True Color, LZW / PackBits / Fax G3 & G4 / Tiled Images)'+#10);
     StrCat(Page5Text,  '-Microsoft filters (feature, some restrictions and only 16-bit version)');
     VpeWriteBox(hdoc, 100, y, 1400, -1, Page5Text);
  finally
   StrDispose(Page5Text);
  end;
  VpeSetPen(hdoc, 5, PS_SOLID, COLOR_BLACK);
  VpePicture(hdoc, 1400, 150, -1, -1, 'logo.bmp', PIC_KEEPIMAGE or PIC_KEEP_DIB_PAGE);
  y := VpeGet(hdoc, VBOTTOM);
  x := VpeGet(hdoc, VRIGHT);
  VpeWriteBox(hdoc, 1400, y, x, -1, '[N S 14 CE C White BC Red TO Italic Bold]IDEAL Software');
  VpeDefaultBitmapDPI(hdoc, 96, 96);
  VpePicture(hdoc, 1400, VpeGet(hdoc, VBOTTOM) + 100, -1, -1, 'fruits.bmp', PIC_KEEPIMAGE or PIC_KEEP_DIB_PAGE);

  y := VpeWriteBox(hdoc, 150, y + 400, 1500, -1,
             '[S 14 CE PS 0]Scale your bitmaps as you like:');
  y := y + 20;
  VpeSetPen(hdoc, 3, PS_SOLID, COLOR_BLACK);
  VpePicture(hdoc, 150, y, 200, -1, 'logo.bmp', PIC_KEEPIMAGE or PIC_KEEP_DIB_PAGE);
  VpePicture(hdoc, VpeGet(hdoc, VRIGHT) + 100, y, VpeGet(hdoc, VRIGHT) + 250, -1,
            'logo.bmp', PIC_KEEPIMAGE or PIC_KEEP_DIB_PAGE);
  VpePicture(hdoc, VpeGet(hdoc, VRIGHT) + 100, y, VpeGet(hdoc, VRIGHT) + 750, -1,
            'logo.bmp', PIC_KEEPIMAGE or PIC_KEEP_DIB_PAGE);

   y := VpeGet(hdoc, VBOTTOM) + 300;
   y := VpePrint(hdoc, 150, y, '[N U]Draw! Set the Pen, Background Color and Hatch Style:');
   y := y+50;
   VpeSetTransparentMode(hdoc, 0);
   VpeSetBkgColor(hdoc, COLOR_BLUE);
   VpeBox(hdoc, 150, y, -300, -300);

   VpeSetHatchStyle(hdoc, HS_BDIAGONAL);
   VpeSetHatchColor(hdoc, COLOR_BLUE);
   VpeSetBkgColor(hdoc, COLOR_LTYELLOW);
   VpeNoPen(hdoc);
   p := VpePolygon(hdoc, 0, 4);
   VpeAddPolygonPoint(hdoc, p, 250, y+400);
   VpeAddPolygonPoint(hdoc, p, 500, y+600);
   VpeAddPolygonPoint(hdoc, p, 300, y+700);
   VpeAddPolygonPoint(hdoc, p, 150, y+1000);

   VpeSetPen(hdoc, 6, PS_SOLID, COLOR_BLACK);
   p := VpePolygon(hdoc, 0, 4);
   VpeAddPolygonPoint(hdoc, p, 650, y);
   VpeAddPolygonPoint(hdoc, p, 1000, y+200);
   VpeAddPolygonPoint(hdoc, p, 700, y+300);
   VpeAddPolygonPoint(hdoc, p, 550, y+600);

   VpeNoPen(hdoc);
   VpeSetHatchStyle(hdoc, HS_DIAGCROSS);
   VpeSetHatchColor(hdoc, COLOR_RED);
   VpeSetBkgColor(hdoc, COLOR_CYAN);
   VpeEllipse(hdoc, 750, 2150, -500, -300);

   VpeSetHatchStyle(hdoc, HS_FDIAGONAL);
   VpeSetPen(hdoc, 10, PS_SOLID, COLOR_GREEN);
   VpeSetTransparentMode(hdoc, 1);
   y2 := VpeWrite(hdoc, 1200, y + 200, -500, -1, '[S 12 B CE]Write text beyond,');
   VpeEllipse(hdoc, 1200, y, -500, -500);
   VpeWrite(hdoc, 1200, y2, -500, -1, 'or above the hatching.');

   VpeSetTransparentMode(hdoc, 0);
   VpeWriteBox(hdoc, 770, 2280, -460, -1, '[PS 3 PC Black HSN BC Cyan S 10 NB]Or blank the hatching out.');

   VpeSetTransparentMode(hdoc, 1);
end;

{Page 6 of Precision demo}
procedure Page6(hdoc : longint);
var
  Page6Text : PChar;
begin
   VpePageBreak(hdoc);

  VpeNoPen(hdoc);
  VpePicture(hdoc, 0, 0, -1, -1, 'gew.tif', PIC_KEEPIMAGE or PIC_KEEP_DIB_PAGE);

  VpeWrite(hdoc, 250, 110, 1200, -1, '[S 24 C LtRed L PS 0]Stadt Xhausen');
  VpeWrite(hdoc, 250, 500, 1000, -1, '[S 14 C Blue]Mustermann & Co.'+#10+'Feinkost Im- und Export');
  VpeWrite(hdoc, 1200, 460, 1700, -1, '[S 11 B]Dsseldorf');
  VpeWrite(hdoc, 250, 670, 750, -1, 'Schmidt');
  VpeWrite(hdoc, 250, 840, 750, -1, '24.7. 1947');
  VpeWrite(hdoc, 500, 835, 1000, -1, 'Oberammergau');
  VpeWrite(hdoc, 250, 1010, 750, -1, 'Zunderstr. 93');
  VpeWrite(hdoc, 1000, 1000, 1750, -1, '0 27 84 / 16 45 98');
  VpeWrite(hdoc, 250, 1255, 1750, -1, 'Willi-Graf-Str. 17');
  VpeWrite(hdoc, 1000, 1255, 1750, -1, '0 27 84 / 23 54 90');
  VpeWrite(hdoc, 1220, 660, 1750, -1, 'Heinz - Willi');
  Page6Text := StrAlloc(1024);
  try
    StrCopy(Page6Text, '[S 10 J I]');
    StrCat(Page6Text, 'It is very important to mention here, that the bitmap form has a resolution of 96 ');
    StrCat(Page6Text, 'DPI only. The print will not be very nice. Just try a 300 DPI bitmap on your own!');
    VpeWrite(hdoc, 1100, 1500, 1950, -1, Page6Text);
  finally
    StrDispose(Page6Text);
  end;
end;

{Precision demo}
procedure TForm1.Precision(const Mode : integer);
var
  HDoc : longint;
begin
  if Mode = 0 then
  begin
    HDoc := VpeOpenDoc(Handle, 'Precision + Capabilities', -1, -1,
                       VPE_EMBEDDED or VPE_GRID_POSSIBLE or VPE_ROUTE_HELP);
    PrecisionHDoc := HDoc;
  end
  else
  begin
    HDoc := VpeOpenDoc(Handle, 'Precision + Capabilities', -1, -1, 0);
    PBackGndHDoc := HDoc;
  end;

  VpeSetAutoBreak(hdoc, AUTO_BREAK_NO_LIMITS);
  VpeSetFontAttr(hdoc, ALIGN_LEFT, 0, 1, 1);
  VpeSetPen(hdoc, 0, PS_SOLID, 0);
  VpeDefineHeader(hdoc, 100, 100, 1000, 150, 'Precision + Capabilities   /  IDEAL Software');
  VpeSetUnderlined(hdoc, 0);
  VpeDefineFooter(hdoc, 1900, 2800, 2100, 2900, 'Page @PAGE');

  Page1(HDoc);
  Page2(HDoc);
  Page3_4(HDoc);
  Page5(HDoc);
  Page6(HDoc);

  VpeRemoveSet(HDoc, HEADLINE);
  VpeGotoPage(HDoc, 1);

  if Mode = 0 then
    VpePreviewDoc(HDoc, nil, VPE_SHOW_NORMAL)
  else
  begin
    VpePrintDoc(HDoc, 0);
    VpeCloseDoc(HDoc);
  end;
end;

{===Report===}
procedure TForm1.ReportTest;
var
  HDoc : longint;
  y : integer;
begin
  hdoc := VpeOpenDoc(Handle, 'Report', -1, -1, 0);
  VpeSetAutoBreak(hdoc, AUTO_BREAK_NO_LIMITS);
  ReportHDoc := hdoc;
  VpeSetPen(hdoc, 5, PS_SOLID, COLOR_BLACK);
  VpeDefaultBitmapDPI(hdoc, 96, 96);
  VpePicture(hdoc, 1650, 150, -1, -1, 'fruits.bmp', PIC_KEEPIMAGE or PIC_KEEP_DIB_PAGE);
  VpeWriteBox(hdoc, 1650, VpeGet(hdoc, VBOTTOM), VpeGet(hdoc, VRIGHT), -1,
              '[N S 9 CE I C Blue BC Gray TO]Fruits of Doom Software');
  y := VpeGet(hdoc, VBOTTOM) + 100;
  VpePrint(hdoc, 150, 200, '[N S 26 U]Year End Results');
  VpePrint(hdoc, 150, 400, '[N S 32]Fruits of Doom Software');

  VpeLine(hdoc, 150, y, 2000, y);
  y := y + 50;

  VpeNoPen(hdoc);
  VpePrintBox(hdoc, 150, y, '[N S 18 C Blue]Product: Apples');
  y := VpeGet(hdoc, VBOTTOM) + 10;
  VpePrint(hdoc, 150, y, '[S 16 C Purple]Country');
  VpePrint(hdoc, 650, y, 'Quantity');
  VpePrint(hdoc, 1150, y, 'Value (in $)');

  y := VpeGet(hdoc, VBOTTOM);
  VpeSetTransparentMode(hdoc, integer(FALSE));
  VpeSetBkgColor(hdoc, COLOR_GRAY);
  VpeBox(hdoc, 150, y, 1550, y+60);
  VpeSetTransparentMode(hdoc, integer(TRUE));
  VpePrint(hdoc, 150, y, '[S 14 C Black]Germany');
  VpeWrite(hdoc, 650, y, 900, y+60, '[R]2.450,00');
  VpeWrite(hdoc, 1150, y, 1450, y+60, '120.050,00');

  y := VpeGet(hdoc, VBOTTOM);
  VpeSetTransparentMode(hdoc, integer(FALSE));
  VpeSetBkgColor(hdoc, COLOR_CYAN);
  VpeBox(hdoc, 150, y, 1550, y+60);
  VpeSetTransparentMode(hdoc, integer(TRUE));
  VpePrint(hdoc, 150, y, 'Great Britain');
  VpeWrite(hdoc, 650, y, 900, y+60, '2.250,00');
  VpeWrite(hdoc, 1150, y, 1450, y+60, '110.250,00');

  y := VpeGet(hdoc, VBOTTOM);
  VpeSetTransparentMode(hdoc, integer(FALSE));
  VpeSetBkgColor(hdoc, COLOR_GRAY);
  VpeBox(hdoc, 150, y, 1550, y+60);
  VpeSetTransparentMode(hdoc, integer(TRUE));
  VpePrint(hdoc, 150, y, 'France');
  VpeWrite(hdoc, 650, y, 900, y+60, '1.700,00');
  VpeWrite(hdoc, 1150, y, 1450, y+60, '83.300,00');

  y := VpeGet(hdoc, VBOTTOM);
  VpeSetTransparentMode(hdoc, integer(FALSE));
  VpeSetBkgColor(hdoc, COLOR_CYAN);
  VpeBox(hdoc, 150, y, 1550, y+60);
  VpeSetTransparentMode(hdoc, integer(TRUE));
  VpePrint(hdoc, 150, y, 'USA');
  VpeWrite(hdoc, 650, y, 900, y+60, '3.200,00');
  VpeWrite(hdoc, 1150, y, 1450, y+60, '156.800,00');

  y := VpeGet(hdoc, VBOTTOM);
  VpeSetTransparentMode(hdoc, integer(FALSE));
  VpeSetBkgColor(hdoc, COLOR_GRAY);
  VpeBox(hdoc, 150, y, 1550, y+60);
  VpeSetTransparentMode(hdoc, integer(TRUE));
  VpePrint(hdoc, 150, y, 'Australia');
  VpeWrite(hdoc, 650, y, 900, y+60, '1.080,00');
  VpeWrite(hdoc, 1150, y, 1450, y+60, '52.920,00');

  y := VpeGet(hdoc, VBOTTOM);
  VpePrint(hdoc, 150, y, 'Total');
  VpeWrite(hdoc, 650, y, 900, y+60, '10.680,00');
  VpeWrite(hdoc, 1150, y, 1450, y+60, '523.320,00');

  y := y + 210;
  VpePrintBox(hdoc, 150, y, '[N S 18 C Blue]Product: Oranges');
  y := VpeGet(hdoc, VBOTTOM) + 10;
  VpePrint(hdoc, 150, y, '[S 16 C Purple]Country');
  VpePrint(hdoc, 650, y, 'Quantity');
  VpePrint(hdoc, 1150, y, 'Value (in $)');

  y := VpeGet(hdoc, VBOTTOM);
  VpeSetTransparentMode(hdoc, integer(FALSE));
  VpeSetBkgColor(hdoc, COLOR_GRAY);
  VpeBox(hdoc, 150, y, 1550, y+60);
  VpeSetTransparentMode(hdoc, integer(TRUE));
  VpePrint(hdoc, 150, y, '[S 14 C Black]Germany');
  VpeWrite(hdoc, 650, y, 900, y+60, '[R]2.450,00');
  VpeWrite(hdoc, 1150, y, 1450, y+60, '120.050,00');

  y := VpeGet(hdoc, VBOTTOM);
  VpeSetTransparentMode(hdoc, integer(FALSE));
  VpeSetBkgColor(hdoc, COLOR_CYAN);
  VpeBox(hdoc, 150, y, 1550, y+60);
  VpeSetTransparentMode(hdoc, integer(TRUE));
  VpePrint(hdoc, 150, y, 'Great Britain');
  VpeWrite(hdoc, 650, y, 900, y+60, '2.250,00');
  VpeWrite(hdoc, 1150, y, 1450, y+60, '110.250,00');

  y := VpeGet(hdoc, VBOTTOM);
  VpeSetTransparentMode(hdoc, integer(FALSE));
  VpeSetBkgColor(hdoc, COLOR_GRAY);
  VpeBox(hdoc, 150, y, 1550, y+60);
  VpeSetTransparentMode(hdoc, integer(TRUE));
  VpePrint(hdoc, 150, y, 'France');
  VpeWrite(hdoc, 650, y, 900, y+60, '1.700,00');
  VpeWrite(hdoc, 1150, y, 1450, y+60, '83.300,00');

  y := VpeGet(hdoc, VBOTTOM);
  VpeSetTransparentMode(hdoc, integer(FALSE));
  VpeSetBkgColor(hdoc, COLOR_CYAN);
  VpeBox(hdoc, 150, y, 1550, y+60);
  VpeSetTransparentMode(hdoc, integer(TRUE));
  VpePrint(hdoc, 150, y, 'USA');
  VpeWrite(hdoc, 650, y, 900, y+60, '3.200,00');
  VpeWrite(hdoc, 1150, y, 1450, y+60, '156.800,00');

  y := VpeGet(hdoc, VBOTTOM);
  VpeSetTransparentMode(hdoc, integer(FALSE));
  VpeSetBkgColor(hdoc, COLOR_GRAY);
  VpeBox(hdoc, 150, y, 1550, y+60);
  VpeSetTransparentMode(hdoc, integer(TRUE));
  VpePrint(hdoc, 150, y, 'Australia');
  VpeWrite(hdoc, 650, y, 900, y+60, '1.080,00');
  VpeWrite(hdoc, 1150, y, 1450, y+60, '52.920,00');

  y := VpeGet(hdoc, VBOTTOM);
  VpePrint(hdoc, 150, y, 'Total');
  VpeWrite(hdoc, 650, y, 900, y+60, '10.680,00');
  VpeWrite(hdoc, 1150, y, 1450, y+60, '523.320,00');

  y := y + 210;
  VpePrintBox(hdoc, 150, y, '[N S 18 C Blue]Product: Bananas');
  y := VpeGet(hdoc, VBOTTOM) + 10;
  VpePrint(hdoc, 150, y, '[S 16 C Purple]Country');
  VpePrint(hdoc, 650, y, 'Quantity');
  VpePrint(hdoc, 1150, y, 'Value (in $)');

  y := VpeGet(hdoc, VBOTTOM);
  VpeSetTransparentMode(hdoc, integer(FALSE));
  VpeSetBkgColor(hdoc, COLOR_GRAY);
  VpeBox(hdoc, 150, y, 1550, y+60);
  VpeSetTransparentMode(hdoc, integer(TRUE));
  VpePrint(hdoc, 150, y, '[S 14 C Black]Germany');
  VpeWrite(hdoc, 650, y, 900, y+60, '[R]2.450,00');
  VpeWrite(hdoc, 1150, y, 1450, y+60, '120.050,00');

  y := VpeGet(hdoc, VBOTTOM);
  VpeSetTransparentMode(hdoc, integer(FALSE));
  VpeSetBkgColor(hdoc, COLOR_CYAN);
  VpeBox(hdoc, 150, y, 1550, y+60);
  VpeSetTransparentMode(hdoc, integer(TRUE));
  VpePrint(hdoc, 150, y, 'Great Britain');
  VpeWrite(hdoc, 650, y, 900, y+60, '2.250,00');
  VpeWrite(hdoc, 1150, y, 1450, y+60, '110.250,00');

  y := VpeGet(hdoc, VBOTTOM);
  VpeSetTransparentMode(hdoc, integer(FALSE));
  VpeSetBkgColor(hdoc, COLOR_GRAY);
  VpeBox(hdoc, 150, y, 1550, y+60);
  VpeSetTransparentMode(hdoc, integer(TRUE));
  VpePrint(hdoc, 150, y, 'France');
  VpeWrite(hdoc, 650, y, 900, y+60, '1.700,00');
  VpeWrite(hdoc, 1150, y, 1450, y+60, '83.300,00');

  y := VpeGet(hdoc, VBOTTOM);
  VpeSetTransparentMode(hdoc, integer(FALSE));
  VpeSetBkgColor(hdoc, COLOR_CYAN);
  VpeBox(hdoc, 150, y, 1550, y+60);
  VpeSetTransparentMode(hdoc, integer(TRUE));
  VpePrint(hdoc, 150, y, 'USA');
  VpeWrite(hdoc, 650, y, 900, y+60, '3.200,00');
  VpeWrite(hdoc, 1150, y, 1450, y+60, '156.800,00');

  y := VpeGet(hdoc, VBOTTOM);
  VpeSetTransparentMode(hdoc, integer(FALSE));
  VpeSetBkgColor(hdoc, COLOR_GRAY);
  VpeBox(hdoc, 150, y, 1550, y+60);
  VpeSetTransparentMode(hdoc, integer(TRUE));
  VpePrint(hdoc, 150, y, 'Australia');
  VpeWrite(hdoc, 650, y, 900, y+60, '1.080,00');
  VpeWrite(hdoc, 1150, y, 1450, y+60, '52.920,00');

  y := VpeGet(hdoc, VBOTTOM);
  VpePrint(hdoc, 150, y, 'Total');
  VpeWrite(hdoc, 650, y, 900, y+60, '10.680,00');
  VpeWrite(hdoc, 1150, y, 1450, y+60, '523.320,00');

  y := VpeGet(hdoc, VBOTTOM) + 210;
  VpePrint(hdoc, 150, y, '[N S 20 U]Yearly Country Sales Total: $1.569.960,00');

  { Draw a pie
    use the VpeGet()-stuff to easily position this anywhere on the paper
    ====================================================================}
  VpePageBreak(hdoc);
  VpeSelectFont(hdoc, 'Times New Roman', 12);
  VpePrint(hdoc, 200, VBOTTOM, '[N S 18 U]Analyze of Paradise:');
  VpeSetPen(hdoc, 3, PS_SOLID, COLOR_BLACK);
  VpeSetTransparentMode(hdoc, 0);
  VpeSetBkgColor(hdoc, COLOR_RED);

  VpePie(hdoc, 200, VpeGet(hdoc, VBOTTOM) + 100, -600, -600, 0, 300);
  VpeStorePos(hdoc);
  VpeBox(hdoc, VpeGet(hdoc, VRIGHT) + 200, VpeGet(hdoc, VTOP) + 20, -30, -30);
  VpePrint(hdoc, VpeGet(hdoc, VRIGHT) + 30, VpeGet(hdoc, VTOP) - 10, '[N T]Apples');

  VpeRestorePos(hdoc);
  VpeSetBkgColor(hdoc, COLOR_BLUE);
  VpePie(hdoc, VLEFT, VTOP, VRIGHT, VBOTTOM, 300, 750);
  VpeStorePos(hdoc);
  VpeBox(hdoc, VpeGet(hdoc, VRIGHT) + 200, VpeGet(hdoc, VTOP) + 70, -30, -30);
  VpePrint(hdoc, VpeGet(hdoc, VRIGHT) + 30, VpeGet(hdoc, VTOP) - 10, '[N T]Oranges');

  VpeRestorePos(hdoc);
  VpeSetBkgColor(hdoc, COLOR_LTYELLOW);
  VpePie(hdoc, VLEFT, VTOP, VRIGHT, VBOTTOM, 750, 1500);
  VpeStorePos(hdoc);
  VpeBox(hdoc, VpeGet(hdoc, VRIGHT) + 200, VpeGet(hdoc, VTOP) + 120, -30, -30);
  VpePrint(hdoc, VpeGet(hdoc, VRIGHT) + 30, VpeGet(hdoc, VTOP) - 10, '[N T]Bananas');

  VpeRestorePos(hdoc);
  VpeSetBkgColor(hdoc, COLOR_GREEN);
  VpePie(hdoc, VLEFT, VTOP, VRIGHT, VBOTTOM, 1500, 2900);
  VpeStorePos(hdoc);
  VpeBox(hdoc, VpeGet(hdoc, VRIGHT) + 200, VpeGet(hdoc, VTOP) + 170, -30, -30);
  VpePrint(hdoc, VpeGet(hdoc, VRIGHT) + 30, VpeGet(hdoc, VTOP) - 10, '[N T]Cherries');

  VpeRestorePos(hdoc);
  VpeSetBkgColor(hdoc, COLOR_CYAN);
  VpePie(hdoc, VLEFT, VTOP, VRIGHT, VBOTTOM, 2900, 0);
  VpeStorePos(hdoc);
  VpeBox(hdoc, VpeGet(hdoc, VRIGHT) + 200, VpeGet(hdoc, VTOP) + 220, -30, -30);
  VpePrint(hdoc, VpeGet(hdoc, VRIGHT) + 30, VpeGet(hdoc, VTOP) - 10, '[N T]Coconuts');

  VpeSetTransparentMode(hdoc, 1);

  VpeGotoPage(hdoc, 1);

  VpePreviewDoc(hdoc, nil, VPE_SHOW_NORMAL);
end;

{===Color Test===}
procedure TForm1.ColorTest;
const
  range = 1400;
  step = 1;
  color_step = 2;
  min_color = 0;
  max_color = 255;
var
  HDoc : longint;
  rc : TRect;
  x, y : integer;
  r, g, b : integer;
  delta_r, delta_g, delta_b : integer;
  xx, factor : double;
begin
  hdoc := VpeOpenDoc(Handle, 'Colors', -1, -1, VPE_NO_MOUSE_SCALE or
                                                   VPE_NO_USER_MOVE or
                                                   VPE_NO_USER_CLOSE or
                                                   VPE_NO_STATBAR or
                                                   VPE_NO_RULER or
                                                   VPE_NO_HELPBTN or
                                                   VPE_NO_INFOBTN);
  VpeSetAutoBreak(hdoc, AUTO_BREAK_NO_LIMITS);
  VpeSetScale(hdoc, 0.25);
  ColorsHDoc := hdoc;

  VpeSetPen(hdoc, 0, PS_SOLID, COLOR_BLACK);
  VpeSelectFont(hdoc, 'Arial', 30);

  xx := -3.1415;
  factor := 2 * abs(xx) / range * step;

  r := 192;
  delta_r := color_step;
  g := min_color+1;
  delta_g := color_step;
  b := min_color+1;
  delta_b := color_step;

  x:=100;
  while x < range+100 do
  begin
   y := trunc(sin(xx) * 500.0 + 500);
   VpeSetTextColor(hdoc, RGB( r, g, b));
   VpeWriteBox(hdoc, x, y, x+800, y + 120, 'Color Test');

   if (x mod 10 = 0) then
   begin
      xx := xx + factor;
      x := x + step;
      y := trunc(sin(xx) * 500.0 + 500);
      VpeSetTextColor(hdoc, COLOR_BLACK);
      VpeWriteBox(hdoc, x, y, x+800, y + 120, 'Color Test');
   end;

   xx := xx + factor;
   if (r > min_color) and (r < max_color) then
   begin
      r := r + delta_r;
      if (r < min_color) then
         r := min_color;
      if (r > max_color) then
         r := max_color;
   end
   else if (g > min_color) and (g < max_color) then
   begin
      g := g + delta_g;
      if (g < min_color) then
         g := min_color;
      if (g > max_color) then
         g := max_color;
   end
   else if (b > min_color) and (b < max_color) then
   begin
      b := b + delta_b;
      if (b < min_color) then
         b := min_color;
      if (b > max_color) then
         b := max_color;
   end;

   if (r >= max_color) and (b >= max_color) then
   begin
      delta_r := -color_step;
      r := max_color-1;
   end;
   if (r >= min_color) and (g >= max_color) then
   begin
      delta_g := -color_step;
      g := max_color-1;
   end;
   if (g = min_color) and (b >= max_color) then
   begin
      delta_b := -color_step;
      b := max_color-1;
   end;

   if (r=min_color) and (g=min_color) and (b=min_color) then
   begin
      r := min_color+1; g:=min_color+1; b:=min_color+1;
      delta_r := color_step;
      delta_g := color_step;
      delta_b := color_step;
   end;
   x := x + step;
  end;

  rc.left := 0;
  rc.top := 0;
  rc.right := 280;
  rc.bottom :=200;
  VpePreviewDoc(hdoc, @rc, VPE_SHOW_NORMAL);
end;

{===PrintJournal===}
const
  RPT_PATH = 'journal.rpt';
  sum_amount : double = 0.0;
  sum_prorated : double = 0.0;
  sum_tax : double = 0.0;

{Generate Report}
procedure GenerateReport;
const
  count : longint = 0;
  table : longint = 0;
var
  fh : System.TextFile;
  i, stepper, min, z : integer;
  FileBuf : array[1..4095] of Char; {Text file buffer for speed}
begin
  Randomize;
  AssignFile(fh, RPT_PATH);
  Rewrite(fh);
  SetTextBuf(fh, FileBuf);
  try
    writeln(fh, 'Test-Document');
    writeln(fh, '1996');
    writeln(fh);
    z := 0;

    while (count < 20000) do
    begin
      inc(z);
      if (z < (random(32767) + 10)) then
      begin
        stepper := 4;
        min := 3;
      end
      else
      begin
        stepper := 21;
        min := 20;
        z := 0;
      end;

      inc(table);
      writeln(fh, Format('@Table %d', [table]));

      {Use random(32767) for compatibility with C/C++ demo}
      i := random(32767) mod stepper + min;
      while i > 0 do
      begin
        writeln(fh, Format('%d', [count]));
        writeln(fh,
        FormatDateTime('ddddd', EncodeDate(1995, random(32767) mod 12 + 1, random(32767) mod 28 + 1)));
        writeln(fh, Format('%d'+DecimalSeparator+'%.2d', [random(32767), random(32767) mod 100]));
        writeln(fh, Format('%d'+DecimalSeparator+'%.2d', [random(32767), random(32767) mod 100]));
        writeln(fh, Format('%d'+DecimalSeparator+'%.2d', [random(32767), random(32767) mod 100]));
        writeln(fh);
        Writeln(fh);
        inc(count, 7);
        dec(i);
      end;
    end;
  finally
    System.CloseFile(fh);
  end;
end;

{PrintHeader}
procedure PrintHeader(HDoc : longint; Table : PChar);
begin
  VpeSetAlign(hdoc, ALIGN_CENTER);
  VpeSelectFont(hdoc, 'Arial', 14);
  VpeSetBkgColor(hdoc, COLOR_LTGRAY);
  VpeWriteBox(hdoc, VLEFTMARGIN, VBOTTOM, VRIGHTMARGIN, -60, table);

  VpeSetFontAttr(hdoc, ALIGN_CENTER, 1, 0, 0);
  VpeSelectFont(hdoc, 'Arial', 11);
  VpeWriteBox(hdoc, VLEFTMARGIN, VBOTTOM, -200, -50, 'No.');
  VpeWriteBox(hdoc, VRIGHT, VTOP, -200, VBOTTOM, 'Date');
  VpeWriteBox(hdoc, VRIGHT, VTOP, -250, VBOTTOM, 'Amount');
  VpeWriteBox(hdoc, VRIGHT, VTOP, -250, VBOTTOM, 'Prorated Amount');
  VpeWriteBox(hdoc, VRIGHT, VTOP, -250, VBOTTOM, 'Tax');
  VpeWriteBox(hdoc, VRIGHT, VTOP, VRIGHTMARGIN, VBOTTOM, 'Remark');
  VpeSetFontAttr(hdoc, ALIGN_LEFT, 0, 0, 0);
  VpeSetBkgColor(hdoc, RGB(255, 255, 255));
end;

{PrintFooter}
procedure PrintFooter(HDoc : longint);
var
  s : string[20];
  TempInt : Longint;
begin
  VpeSetFontAttr(hdoc, ALIGN_CENTER, 1, 0, 0);
  VpeSetBkgColor(hdoc, COLOR_LTGRAY);
  VpeWriteBox(hdoc, VLEFTMARGIN, VBOTTOM, -400, -50, 'Sum');
  VpeSetFontAttr(hdoc, ALIGN_RIGHT, 1, 0, 0);
  TempInt := Round(sum_amount * 100);
  s := Format('%m', [TempInt * 0.01]) + #0;
  VpeWriteBox(hdoc, VRIGHT, VTOP, -250, VBOTTOM, @s[1]);
  TempInt := Round(sum_prorated * 100);
  s := Format('%m', [TempInt * 0.01]) + #0;
  VpeWriteBox(hdoc, VRIGHT, VTOP, -250, VBOTTOM, @s[1]);
  TempInt := Round(sum_tax * 100);
  s := Format('%m', [TempInt * 0.01]) + #0;
  VpeWriteBox(hdoc, VRIGHT, VTOP, -250, VBOTTOM, @s[1]);
  VpeWriteBox(hdoc, VRIGHT, VTOP, VRIGHTMARGIN, VBOTTOM, '');
  VpeSetFontAttr(hdoc, ALIGN_LEFT, 0, 0, 0);
  VpeSetBkgColor(hdoc, RGB(255, 255, 255));
end;

{PrintFoot}
procedure PrintPageFooter(HDoc : longint; Name : PChar; Page : integer);
var
  buf : string[32];
begin
   VpeStorePos(hdoc);
   VpeNoPen(hdoc);
   VpeWriteBox(hdoc, VLEFTMARGIN, VBOTTOMMARGIN, VpeGet(hdoc, VRIGHTMARGIN) - 400, -50, name);
   buf := Format('Journal Page %d', [page]) + #0;
   VpeSetAlign(hdoc, ALIGN_RIGHT);
   VpeWriteBox(hdoc, VRIGHT, VBOTTOMMARGIN, VRIGHTMARGIN, -50, @buf[1]);
   VpeSetPen(hdoc, 3, PS_SOLID, COLOR_BLACK);
   VpeRestorePos(hdoc);
end;

{PageBreak}
procedure PageBreak(HDoc : longint; Page : integer);
begin
  VpePageBreak(HDoc);

  if (Page mod 10 = 0) then
  begin
    Form2.Memo1.Clear;
    Form2.Memo1.Lines.Add(Format('Generating page # %d from textfile', [page]));
    Application.ProcessMessages;
  end;
end;

{PrintJournal}
function PrintJournal : boolean;
const
  footer_ok : boolean = false;
var
  hdoc : longint;
  page : integer;
  fh : System.TextFile;
  s : string[255];
  buf : array[0..513] of char;
  name : string[80];
  year : string[8];
  period : string[32];
  table : string[128];
  FileBuf : array[1..4095] of Char;
  holdvalue : single;
  Form2Showing : boolean;
begin
  {Remove $ or DM or whatever currency string is assigned from Control Panel}
  CurrencyString := '';
  Form2.Position := poScreenCenter;
  Screen.Cursor := crHourGlass;
  page := 1;
  try
    try
      AssignFile(fh, RPT_PATH);
      Reset(fh);
    except
      on E:EInOutError do
      begin
        Form2Showing := Form2.Visible;
        Form2.Visible := true;
        Form2.Memo1.Clear;
        Form2.Memo1.Lines.Add('Generating report data.');
        Application.ProcessMessages;
        GenerateReport;
        Form2.Memo1.Lines.Add('Done generating report data.');
        Application.ProcessMessages;
        Form2.Visible := Form2Showing;
        Form2.Memo1.Clear;
        Reset(fh);
      end;
    end;
    SetTextBuf(fh, FileBuf);
    hdoc := VpeOpenDoc(Form1.Handle, 'Speed + Tables', -1, -1, VPE_GRID_POSSIBLE);
    VpeSetAutoBreak(hdoc, AUTO_BREAK_NO_LIMITS);
    Form1.SpeedHDoc := hdoc;
    VpeSetTransparentMode(hdoc, integer(FALSE));

    Form2Showing := Form2.Visible;
    Form2.Visible := true;

    try
      {// Read constant data block:}
      {// =========================}
      readln(fh, name);
      name := name + #0;
      readln(fh, year);
      readln(fh, s);

      if (length(s) > 0) then
       period := ', ' + s
      else
       period := '';

      s := Format('Journal %s%s', [year, period]) + #0;
      VpeSetPen(hdoc, 0, 0, COLOR_BLACK);
      VpeSetFontAttr(hdoc, ALIGN_CENTER, 0, 1, 0);
      VpeSelectFont(hdoc, 'Arial', 16);
      VpeWriteBox(hdoc, VLEFTMARGIN, VTOPMARGIN, VRIGHTMARGIN, VFREE, @s[1]);

      VpeSetPen(hdoc, 3, PS_SOLID, COLOR_BLACK);
      VpeSetFontAttr(hdoc, ALIGN_LEFT, 0, 0, 0);
      VpeSelectFont(hdoc, 'Arial', 11);

      {// process variable data:}
      {// ======================}
      {while not eof and readln returns data do}
      while not eof(fh) do
      begin
        readln(fh, s);
        s := s + #0;
        if (s[1] = '@') then
        begin
           {// Beginning of a new table:}
           {// =========================}
           if (footer_ok) then
              PrintFooter(hdoc);
           sum_amount := 0.0;
           sum_prorated := 0.0;
           sum_tax := 0.0;

           {// Is the room to the page-bottom big enough for a new table ?}
           if (VpeGet(hdoc, VBOTTOMMARGIN) - VpeGet(hdoc, VBOTTOM) < 400) then
           begin
              {// No, add a new page:}
              PrintPageFooter(hdoc, @name[1], page);
              PageBreak(hdoc, page);
              inc(page);
           end
           else
           begin
              {// Beginning of new table is 1cm below previous table:}
              VpeSet(hdoc, VBOTTOM, VpeGet(hdoc, VBOTTOM) + 100);
           end;
           table := copy(s, 2, length(s));
           PrintHeader(hdoc, @table[1]);
           footer_ok := FALSE;
        end
        else
        begin
           {// list part:}
           {// ==========}
           footer_ok := TRUE;
           VpeSetTransparentMode(hdoc, 1);
           VpeSetAlign(hdoc, ALIGN_RIGHT);
           VpeWriteBox(hdoc, VLEFTMARGIN, VBOTTOM, -200, -50, @s[1]);

           readln(fh, s);
           s := s + #0;
           VpeWriteBox(hdoc, VRIGHT, VTOP, -200, VBOTTOM, @s[1]);

           readln(fh, s);
           holdvalue := StrToFloat(s);
           sum_amount := sum_amount + holdvalue;
           s := Format('%m', [holdvalue]) + #0;
           VpeWriteBox(hdoc, VRIGHT, VTOP, -250, VBOTTOM, @s[1]);

           readln(fh, s);
           holdvalue := StrToFloat(s);
           sum_prorated := sum_prorated + holdvalue;
           s := Format('%m', [holdvalue]) + #0;
           VpeWriteBox(hdoc, VRIGHT, VTOP, -250, VBOTTOM, @s[1]);

           readln(fh, s);
           holdvalue := StrToFloat(s);
           sum_tax := sum_tax + holdvalue;
           s := Format('%m', [holdvalue]) + #0;
           VpeWriteBox(hdoc, VRIGHT, VTOP, -250, VBOTTOM, @s[1]);

           readln(fh, s);
           strpcopy(buf, s);
           strcat(buf, ' ');
           readln(fh, s);
           s := s + #0;
           strcat(buf, @s[1]);
           VpeSetAlign(hdoc, ALIGN_LEFT);
           VpeSelectFont(hdoc, 'Arial', 6);
           VpeWriteBox(hdoc, VRIGHT, VTOP, VRIGHTMARGIN, VBOTTOM, buf);
           VpeSelectFont(hdoc, 'Arial', 11);
           VpeSetTransparentMode(hdoc, 0);

           if (VpeGet(hdoc, VBOTTOM) + 150 > VpeGet(hdoc, VBOTTOMMARGIN)) then
           begin
              {// Bottom of page reached:}
              {// =======================}
              PrintFooter(hdoc);
              PrintPageFooter(hdoc, @name[1], page);
              PageBreak(hdoc, page);
              inc(page);
              PrintHeader(hdoc, @table[1]);
           end;
        end; {// else}
      end; {// while}

      PrintFooter(hdoc);
      PrintPageFooter(hdoc, @name[1], page);

      VpeGotoPage(hdoc, 1);

      s := Format('Generated %d pages out of textfile!', [VpeGetPageCount(hdoc)]) + #0;
      VpeWriteBox(hdoc, 100, 100, 1000, 150, @s[1]);
    except
      on E:Exception do
      begin
        Form1.SpeedHDoc := 0;  {Set handle holder to 0}
        raise E;  {re-raise the exception for the default exception handler}
      end;
    end;
  finally
    System.CloseFile(fh);
    Screen.Cursor := crDefault;
    Form2.Visible := Form2Showing;
  end;

  VpePreviewDoc(hdoc, nil, VPE_SHOW_MAXIMIZED);

  Result := true;
end;


{AutoRender}
procedure AutoRender;
const
   MAX_TEXT_LEN = 64000;     { due to 16-bit windows limits }
var
   hdoc, len: LongInt;
   fh : TFileStream;
   text : PChar;
begin
   Screen.Cursor := crHourGlass;
   fh := TFileStream.Create('unit1.pas', fmOpenRead);

   GetMem(text, MAX_TEXT_LEN + 1);
   len := fh.Read(text^, MAX_TEXT_LEN);
   text[len] := char(0);
   fh.Destroy;

   hdoc := VpeOpenDoc(Form1.Handle, 'Auto Rendering', -1, -1, VPE_GRID_POSSIBLE);
   Form1.AutoRenderHDoc := hdoc;

   VpeSelectFont(hdoc, 'Courier New', 10);

   { Header will be placed outside default output rectangle: }
   VpeNoPen(hdoc);
   VpeSetUnderlined(hdoc, 1);
   VpeDefineHeader(hdoc, 100, 100, -700, -50, 'Auto Text Break Demo - Page @PAGE');

   { On every intial page:
      VLEFT   = VLEFTMARGIN
      VTOP    = VTOPMARGIN
      VRIGHT  = VRIGHTMARGIN
      VBOTTOM = VBOTTOMMARGIN !!!!!!!!!! }
   VpeSetUnderlined(hdoc, 0);
   VpeSetPen(hdoc, 3, PS_SOLID, 0);
   VpeWriteBox(hdoc, VLEFT, VBOTTOM, VRIGHT, VFREE, '[N TO BC LtGray CE S 12 B]Start of Listing');
   VpeWriteBox(hdoc, VLEFT, VBOTTOM, VRIGHT, VFREE, text);
   VpeWriteBox(hdoc, VLEFT, VBOTTOM, VRIGHT, VFREE, '[N TO BC LtGray CE S 12 B]End of Listing');

   FreeMem(text, MAX_TEXT_LEN);
   VpeGotoPage(hdoc, 1);
   Screen.Cursor := crDefault;
   VpePreviewDoc(hdoc, nil, VPE_SHOW_MAXIMIZED);
end;

{TForm1 Methods}
procedure TForm1.AppOnMessage(var Msg: TMsg; var Handled: boolean);
begin
  {Respond to VPE custom messages}
  case Msg.Message of
    VPE_DESTROYWINDOW : begin
      if Msg.LParam = PrecisionHDoc then
      begin
        PrecisionHDoc := 0;
        Form2.Visible := false;
      end
      else if Msg.LParam = SpeedHDoc then
        SpeedHDoc := 0
      else if Msg.LParam = ColorsHDoc then
      begin
        ColorsHDoc := 0;
        CloseColors1.Enabled := false;
        Colors1.Enabled := true;
      end
      else if Msg.LParam = ReportHDoc then
        ReportHDoc := 0
      else if Msg.LParam = AutoRenderHDoc then
        AutoRenderHDoc := 0;
    end; {VPE_DESTROYWINDOW}

    VPE_PRINT, VPE_PRINTCANCEL : begin
      if Msg.WParam > 0 then
        inc(CanClose)
      else
      begin
        dec(CanClose);
        if Msg.LParam = PBackGndHDoc then
        begin
          PBackGndHDoc := 0;
          if Msg.Message = VPE_PRINT then
          begin
            Form2.Memo1.Lines.Add('Message: Background-Processing finished.');
            Form2.Visible := true;
          end
          else
          begin
            Form2.Memo1.Lines.Add('Message: Background-Processing aborted.');
            Form2.Visible := true;
          end;
        end;
      end;
    end; {VPE_PRINT, VPE_PRINTCANCEL}

  end; {case}

end;

procedure TForm1.VPEHelp(var Msg: TMsg);
begin
  {Respond to VPE_HELP for Precision demo.}
  {VPE_HELP is sent to the form, not the application.}
  ShowMessage('User requested help');
end;

procedure TForm1.WMKeyDown(var Msg: TWMKeyDown);
begin
  {Route keystrokes to embedded VPE window for arrows, etc.}
  if PrecisionHDoc <> 0 then
    SendMessage(VPEWindowHandle(PrecisionHDoc), Msg.Msg, Msg.CharCode, Msg.KeyData);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  Application.OnMessage := AppOnMessage;

  CanClose := 0;
  CloseColors1.Enabled := false;

  DemoText := StrAlloc(2048);
  MakeDemoText(DemoText);

  PrecisionHDoc := 0;
  PBackGndHDoc := 0;
  ReportHDoc := 0;
  ColorsHDoc := 0;
  SpeedHDoc := 0;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  StrDispose(DemoText);
end;

procedure TForm1.Exit1Click(Sender: TObject);
begin
  Application.Terminate;
end;

procedure TForm1.CapabilitiesPrecision1Click(Sender: TObject);
var
  R : TRect;
begin
  if PrecisionHDoc = 0 then
  begin
    Precision(0);
    with Form2.Memo1.Lines do
    begin
      Clear;
      Add('It''s easy to embed a VPE window on a Delphi Form''s client area ' +
          'You just need a few lines of code!');
    end;
    R := Application.MainForm.BoundsRect;
    with Form2 do
    begin
      Top := (((R.Bottom-R.Top)-Height) div 2) + R.Top;
      Left := (((R.Right-R.Left)-Width) div 2) + R.Left;
      Visible := true;
    end;
  end;
end;

procedure TForm1.GenerateData1Click(Sender: TObject);
begin
  Screen.Cursor := crHourGlass;
  try
    GenerateReport;
  finally
    Screen.Cursor := crDefault;
  end;
end;

procedure TForm1.DeleteReport1Click(Sender: TObject);
begin
  DeleteFile(RPT_PATH);
end;

procedure TForm1.SpeedTables1Click(Sender: TObject);
begin
  if SpeedHDoc = 0 then
    PrintJournal
  else
    ShowMessage('Speed test is already running');
end;

procedure TForm1.Colors1Click(Sender: TObject);
begin
  ColorTest;
  Colors1.Enabled := false;
  CloseColors1.Enabled := true;
end;

procedure TForm1.Report1Click(Sender: TObject);
begin
  if ReportHDoc = 0 then
    ReportTest
  else
    ShowMessage('Report test is already running');
end;

procedure TForm1.AutoRender1Click(Sender: TObject);
begin
  if AutoRenderHDoc = 0 then
    AutoRender
  else
    ShowMessage('Auto Rendering Demo is already running');
end;

procedure TForm1.FormResize(Sender: TObject);
begin
  if PrecisionHDoc <> 0 then
    MoveWindow(VpeWindowHandle(PrecisionHDoc), 0, 0, ClientWidth, ClientHeight, false);
end;

procedure TForm1.PrintinBackground1Click(Sender: TObject);
begin
  with Form2.Memo1.Lines do
  begin
    Clear;
    Add('Here no preview is shown. Also no printer-setup is done - the settings ' +
        'of the default printer are taken.');
  end;
  Precision(1);
end;

procedure TForm1.CloseColors1Click(Sender: TObject);
begin
  if not WordBool(VpeCloseDoc(ColorsHDoc)) then
    ShowMessage('Can''t close ''color test'' because it is printing');
end;

end.
