#include "xspinbtn.h"


XSpinButton :: XSpinButton( HWND hwnd): XControl( hwnd )
{ ;}

XSpinButton :: XSpinButton( XWindow * owner, XRect * rec, USHORT id, ULONG style, const char * string): XControl(rec, style, owner, string, WC_SPINBUTTON, id)
{ ;}


LONG XSpinButton :: GetValue( void)
{
   LONG l;
   WinSendMsg( winhandle,  SPBM_QUERYVALUE, MPFROMP( (VOID *) &l), 0);
   return l;
}


void XSpinButton :: SetLimits( LONG lowerLimit, LONG upperLimit)
{
   WinSendMsg( winhandle,  SPBM_SETLIMITS, (MPARAM) upperLimit, (MPARAM) lowerLimit);
}


void XSpinButton :: SetValue( LONG val)
{
   WinSendMsg( winhandle,  SPBM_SETCURRENTVALUE, (MPARAM) val, 0);
}


