#include "xheaders.h"

#include XClipBoard_i
#include XWindow_i

#include <string.h>

/*DOC
CLASS XClipBoard
FUNCTION XClipBoard
GROUP constructors/destructors
REMARKS Open the clipboard
Parameters: XWindow * theOwner          the owning window
*/
XClipBoard :: XClipBoard( XWindow * win)
{
  isOpen = FALSE;
  hab = WinQueryAnchorBlock( win->GetHandle());
  if( WinOpenClipbrd(hab) == FALSE)
     return;
  isOpen = TRUE;
}


/*DOC
CLASS XClipBoard
FUNCTION GetText
GROUP get data
REMARKS get the text in th eclipboard
Returns:    char *                       the text
*/
char * XClipBoard :: GetText( void )
{
   return (char*) WinQueryClipbrdData( hab, CF_TEXT);
}


/*DOC
CLASS XClipBoard
FUNCTION GetBitamp
GROUP get data
REMARKS get a bitmap from the clipboard
Returns:    OOL_BITMAPHANDLE             the system-handle to the bitmap
*/
HBITMAP XClipBoard :: GetBitmap( void )
{
   return WinQueryClipbrdData( hab, CF_BITMAP);
}


/*DOC
CLASS XClipBoard
FUNCTION SetBitamp
GROUP set data
REMARKS set a bitmap to the clipboard
Parameters: OOL_BITMAPHANDLE             the handle of the bitmap
Returns:    BOOL                         success
*/
BOOL XClipBoard :: SetBitmap( HBITMAP bmp)
{
  return WinSetClipbrdData( hab, (ULONG) bmp, CF_BITMAP, CFI_HANDLE);
}


/*DOC
CLASS XClipBoard
FUNCTION SetText
GROUP set data
REMARKS set text to the clipboard
Parameters: char * theText               text
Parameters: ULONG len                    length of the text (default is 0)
Returns:    BOOL                         success
*/
BOOL XClipBoard :: SetText( char * p, ULONG len)
{
  void * pp;

  if(len ==0)
     len = 1 + strlen(p);

  DosAllocSharedMem(&pp, NULL, len, PAG_READ | PAG_WRITE | PAG_COMMIT | OBJ_GIVEABLE);
  strcpy ((char *) pp, p);
  return WinSetClipbrdData ( hab, (ULONG) pp, CF_TEXT, CFI_POINTER);
}


/*DOC
CLASS XClipBoard
FUNCTION ~XClipBoard
GROUP constructors7destructors
Never forget to close the clipboard by calling the destructor!
*/
XClipBoard :: ~XClipBoard()
{
  if(isOpen)
     WinCloseClipbrd( hab );
}


