#include "sample3.h"

#include XColor_i
#include XMessageBox_i
#include XFileDialog_i
#include XString_i
#include XControlEvent_i

#include <stdlib.h>

SHORT volume = 50;

MyAppWindow :: MyAppWindow( XApplication * app, XResource * r ): XFrameWindow( r, "Sample3 - Videoplayer", XFrameWindow::defaultDialogStyle | FRM_TASKLIST | FRM_ICON)
{
   //we create a toolbar for the buttons at the top...
   toolBar = new XToolBar( this, TB_TOP );

   //now create pushbuttons with bitmaps, the bitmaps are in the resources of the exe
   XRect rec( 0, 0, 20, 20);

   back = new XPushButton( toolBar, &rec, (USHORT) IDM_BACK, BU_BITMAP);
   play = new XPushButton( toolBar, &rec, (USHORT) IDM_PLAY, BU_BITMAP);
   halt = new XPushButton( toolBar, &rec, (USHORT) IDM_HALT, BU_BITMAP);
   mini = new XPushButton( toolBar, &rec, (USHORT) IDM_MIN, BU_BITMAP);
   plus = new XPushButton( toolBar, &rec, (USHORT) IDM_PLUS, BU_BITMAP);
   sel = new XPushButton( toolBar, &rec, (USHORT) IDM_SEL, BU_BITMAP);

   //disable buttons
   play->Enable(FALSE);
   halt->Enable(FALSE);
   back->Enable(FALSE);

   //add the pushbuttons to the toolbar, the toolbar will use the size of the first button
   toolBar->AddWindow( play , FALSE, TRUE);
   toolBar->AddWindow( halt );
   toolBar->AddWindow( back );
   toolBar->AddWindow( plus, TRUE );
   toolBar->AddWindow( mini );
   toolBar->AddWindow( sel, TRUE );

   // set the size of the window and display it
   XColor col( COL_BLACK);
   SetBackgroundColor( &col);

   XRect rect( 150, 150, 280, 230);
   SetSize(&rect);

   Show();

   // know we generate a videoplayer and open it
   video = new XVideo ( this); //this is the needed REIHENFOLGE
   video->OpenDevice();

   // if you dont set the viewport like this, the default ULTIMOTION-window
   // will be opened, but our window will receive the media-control messages
   // (see below function DoControl() )
   video->SetViewPort( this);

   Activate();
}


MyAppWindow :: ~MyAppWindow()
{
   /* we MUST close the video and destroy it ourselves */
   video->CloseDevice();
   delete video;
}


void MyAppWindow :: Draw( void )
{
   FillBackground( );
}


/* here the command of the toolbar are posted */
void MyAppWindow :: DoCommand( LONG com)
{
  switch(com)
     {
         case IDM_SEL:
            {
               XFileDialog dlg( this, "c:\\mmos2\\movies\\*.AVI");
               if( dlg.GetCommand() == DID_OK)
                  {
                     XString s;
                     dlg.GetFileName( &s );
                     video->SetDataFile( s );
                     play->Enable();
                  }
            }
            return;
         case IDM_PLAY:
            back->Enable();
            halt->Enable();
            play->Enable(FALSE);
            video->Play();
            return;
         case IDM_BACK:
            video->Rewind();
            return;
         case IDM_HALT:
            video->Pause();
            return;
         case IDM_PLUS:
            if( volume < 100)
               {
                  volume += 10;
                  video->SetVolume( volume );
               }
            if(volume == 100)
               plus->Enable(FALSE);
            if(volume == 10)
               mini->Enable();
            return;
         case IDM_MIN:
            if( volume > 0)
               {
                  volume -= 10;
                  video->SetVolume( volume );
               }
            if(volume == 0)
               mini->Enable(FALSE);
            if(volume == 90)
               plus->Enable();
            return;
     }
}


void MyAppWindow :: DoControl( XControlEvent * event)
{
   //here the control-messages are posted, we only care about media-messages */
   switch( event->GetEventID())
      {
         case MEDIA_PLAYED: //end of file reached
            play->Enable(FALSE);
            halt->Enable(FALSE);
            return;
         case MEDIA_PAUSED: //video stopped
            halt->Enable(FALSE);
            play->Enable();
            return;
         case MEDIA_REWINDED: //file has been seeked to start
            halt->Enable(FALSE);
            back->Enable(FALSE);
            play->Enable();
            return;
      }
}


MyApp :: MyApp(): XApplication()
{
   XResource r( IDM_MAIN, GetResourceLibrary());
   window = new MyAppWindow( this, &r );   //create new framewindow (see above)
}

void main ( void)
{
   MyApp * app = new MyApp();  //create a new application
   app->Start();               //let the application work
}
