#ifndef __OOL_XWINDOWDRAG_H__
#define __OOL_XWINDOWDRAG_H__

/*===========================================================================*/
/* OOL ------------------- the Open Object Library ------ OS/2 version 0.01a */
/*===========================================================================*/
/*                              class: XWindowDrag                           */
/*                       derived from: XObject                               */
/*                        last update: 4/96                                  */
/*                      programmed by: Stefan von Brauk                      */
/*===========================================================================*/

#include "xobject.h"

#ifdef OOL_FOR_OS2_X86

   //image type and options
   #define IMG_ICON     DRG_ICON
   #define IMG_BITMAP   DRG_BITMAP
   #define IMG_STRETCH  DRG_STRETCH

#endif

class XWindow;
class XDragItem;
class XBitmap;

class _export_ XWindowDrag: public XObject
{
   private:
      PDRAGINFO pInfo;
      SHORT count;
      DRAGIMAGE * pImage;
      SHORT imageCount;
      XWindow * ownerWindow;
   public:
      XWindowDrag( XWindow * owner, SHORT itemCount );
      ~XWindowDrag();
      void AddImage( OOL_ICONHANDLE handle, SHORT style = IMG_ICON, SHORT xOffset=0, SHORT yOffset=0, SHORT stretch=0);
      void AddImage( XBitmap *, SHORT xOffset=0, SHORT yOffset=0, SHORT stretch=0);
      OOL_WINDOWHANDLE PerformDrag( void );
      void QueryDragItem( XDragItem * item, SHORT number);
      SHORT QueryItemCount(void);
      LONG QuerySupportedOperation( void );
      void SetDragItem( XDragItem * item, SHORT number);
};

#endif
