#ifndef __OOL_XSCROLLWND_H__
#define __OOL_XSCROLLWND_H__

/*===========================================================================*/
/* OOL ------------------- the Open Object Library ------ OS/2 version 0.01a */
/*===========================================================================*/
/*                              class: XScrollWindow                         */
/*                       derived from: XFrameWindow                          */
/*                        last update: 4/96                                  */
/*                      programmed by: Stefan von Brauk                      */
/*===========================================================================*/


#include "xfrmwnd.h"

class XEdgeWin;
class XScrollBar;
class XResource;

class _export_ XScrollWindow: public XFrameWindow{
   private:
      void AddDummy(void);
      void DeleteDummy( void);
   protected:
      void CalcHorzSize( void );
      void CalcVertSize( void );
      LONG virtualX, virtualY, scrollPosX, scrollPosY;
      SHORT xStep, yStep, xPage, yPage;
      SWP clientSwp;
   public:
      XScrollWindow(XResource * resource = NULL,
                 char * title=NULL,
                 ULONG createstyle = XFrameWindow::defaultStyle,
                 XRect * rec = NULL,
                 XFrameWindow * parent = NULL,
                 BOOL buildFromResource = FALSE);
      virtual ~XScrollWindow();
      void AddVertScroller( void );
      void AddHorzScroller( void );
      void DeleteVertScroller( void );
      void DeleteHorzScroller( void );
      LONG GetHorzPos( void ) { return scrollPosX; }
      XScrollBar * GetHorzScroller(void) { return horz; }
      LONG GetVertPos( void ) { return scrollPosY; }
      XScrollBar * GetVertScroller(void) { return vert; }
      virtual void HScroll( LONG );
      void SetVirtualX( LONG x);
      void SetVirtualY( LONG y);
      void SetXPageSize( SHORT p) { xPage = p; }
      void SetYPageSize( SHORT p) { yPage = p; }
      void SetXStepSize( SHORT p) { xStep = p; }
      void SetYStepSize( SHORT p) { yStep = p; }
      virtual MRESULT HandleMessage(ULONG msg, MPARAM mp1, MPARAM mp2);
      virtual void VScroll( LONG );
};

#endif
