#ifndef __OOL_XPROCES_H__
#define __OOL_XPROCES_H__

/*===========================================================================*/
/* OOL ------------------- the Open Object Library ------ OS/2 version 0.01a */
/*===========================================================================*/
/*                              class: XProcess                              */
/*                       derived from: XObject                               */
/*                        last update: 7/96                                  */
/*                      programmed by: Stefan von Brauk                      */
/*===========================================================================*/



#include "xobject.h"

class XFrameWindow;
class XString;

#ifdef OOL_FOR_OS2_X86
   #define EXE_SYNC       EXEC_SYNC
   #define EXE_ASYNC      EXEC_ASYNC
#endif

class _export_ XProcess: public XObject
{
      friend class XResourceLibrary;
      friend class XHelpInstance;
      friend XFrameWindow;
   protected:
      HAB hab;
      HMQ queue;
      QMSG messagequeue;
      SHORT windows;
      XFrameWindow ** frames;
      void AddWindow( XFrameWindow * );
      void RemoveWindow( XFrameWindow*);
   public:
      XProcess();
      virtual ~XProcess() {;}
      static void Beep (LONG f, LONG d);
      static LONG ExecuteProg( char * path, char * args, char * env, ULONG flag, LONG * result);
      static OOL_POINTERHANDLE LoadIcon( char * p, BOOL copy = FALSE );
      virtual BOOL QueryForQuit( void );
      static BOOL ScanEnvironment( char * valueToSearch, XString * buffer);
      static void Sleep (LONG d);
      void Start( void );
      virtual void Terminate( void );
};

#endif
