#ifndef __OOL_XMOUSEHANDLER_H__
#define __OOL_XMOUSEHANDLER_H__

/*===========================================================================*/
/* OOL ------------------- the Open Object Library ------ OS/2 version 0.01a */
/*===========================================================================*/
/*                              class: XMouseHandler                         */
/*                       derived from: XHandler                              */
/*                        last update: 5/96                                  */
/*                      programmed by: Stefan von Brauk                      */
/*===========================================================================*/

#include "xhandler.h"


class XMouseEvent;

/*DOC
CLASS XMouseHandler
To catch events from the mouse like moving using mouse-buttons etc you must
register a XMouseHandler. Therfor you derive a class from XMouseHandler
and override the method HandleEvent where you will get events (XMouseEvent) posted
from the mouse.
*/
class _export_ XMouseHandler: public XHandler
{
   public:
      XMouseHandler( XWindow * w): XHandler( OOL_MOUSEHANDLER, w ) { ;}
      virtual BOOL HandleEvent( XMouseEvent *);
};


/*DOC
CLASS XMouseHandler
FUNCTION XMouseHandler
Parameters: XWindow * window       The window to handle the mouseevents for.
*/
#endif
