#ifndef __OOL_XMOUSEEVENT_H__
#define __OOL_XMOUSEEVENT_H__

/*===========================================================================*/
/* OOL ------------------- the Open Object Library ------ OS/2 version 0.01a */
/*===========================================================================*/
/*                              class: XMouseEvent                           */
/*                       derived from: XEvent                                */
/*                        last update: 5/96                                  */
/*                      programmed by: Stefan von Brauk                      */
/*===========================================================================*/

#include "xevent.h"
#include "xpoint.h"


#ifdef OOL_FOR_OS2_X86
   #define MOU_BTN1CLICK                 1
   #define MOU_BTN1DBLCLICK              2
   #define MOU_BTN1DOWN                  3
   #define MOU_BTN1UP                    4
   #define MOU_BTN2CLICK                 5
   #define MOU_BTN2DBLCLICK              6
   #define MOU_BTN2DOWN                  7
   #define MOU_BTN2UP                    8
   #define MOU_BTN3CLICK                 9
   #define MOU_BTN3DBLCLICK              10
   #define MOU_BTN3DOWN                  11
   #define MOU_BTN3UP                    12
   #define MOU_INITDRAG                  WM_INITDRAG
   #define MOU_MOVE                      WM_MOUSEMOVE
#endif


/*DOC
CLASS XMouseEvent
To catch event from the mouse like moving using mouse-buttons etc you must
install a XMouseHandler. If you use this handler you recieve XMouseEvents
which contains information about the mouse-state. For drag/drop you dont
need a XMousehandler but a XDragHandler. Possible event-IDs are
   MOU_BTN1CLICK      button 1 clicked
   MOU_BTN1DBLCLICK   button 1 double-click
   MOU_BTN1DOWN       button 1 down
   MOU_BTN1UP         button 1 up
   MOU_BTN2CLICK      button 2 clicked
   MOU_BTN2DBLCLICK   button 2 double-click
   MOU_BTN2DOWN       button 2 down
   MOU_BTN2UP         button 2 up
   MOU_BTN3CLICK      button 3 clicked
   MOU_BTN3DBLCLICK   button 3 double-click
   MOU_BTN3DOWN       button 3 down
   MOU_BTN3UP         button 3 up
   MOU_INITDRAG       the user requested a drag-operation
   MOU_MOVE           mouse moved
*/
class _export_ XMouseEvent: public XEvent
{
      friend MRESULT HandleDefault( XWindow * w, ULONG msg, MPARAM mp1, MPARAM mp2, BOOL& handled);
   private:
      XMouseEvent( LONG, void*, void*);
      SHORT keyboardState;
   public:
      XPoint p;
      SHORT GetKeyInfo(void ) { return keyboardState; }
};


#endif
