#ifndef __OOL_XFILE_H__
#define __OOL_XFILE_H__

/*===========================================================================*/
/* OOL ------------------- the Open Object Library ------ OS/2 version 0.01a */
/*===========================================================================*/
/*                              class: XFile                                 */
/*                       derived from: XObject                               */
/*                        last update: 7/96                                  */
/*                      programmed by: Stefan von Brauk                      */
/*===========================================================================*/

#include "xobject.h"

#ifdef OOL_FOR_OS2_X86
   //seek relative positions
   #define XFILE_BEGIN                   0
   #define XFILE_CURRENT                 1
   #define XFILE_END                     2

   //modeForOpen, can be or-ed
   #define XFILE_FAIL_IF_NEW             OPEN_ACTION_FAIL_IF_NEW
   #define XFILE_CREATE_IF_NEW           OPEN_ACTION_CREATE_IF_NEW

   #define XFILE_REPLACE_EXISTING        OPEN_ACTION_REPLACE_IF_EXISTS
   #define XFILE_OPEN_EXISTING           OPEN_ACTION_OPEN_IF_EXISTS
   #define XFILE_FAIL_EXISTING           OPEN_ACTION_FAIL_IF_EXISTS

   //modeForAccess, can be or-ed
   #define XFILE_SHARE_DENYREAD          OPEN_SHARE_DENYREAD
   #define XFILE_SHARE_DENYWRITE         OPEN_SHARE_DENYWRITE
   #define XFILE_SHARE_DENYREADWRITE     OPEN_SHARE_DENYREADWRITE
   #define XFILE_SHARE_DENYNONE          OPEN_SHARE_DENYNONE

   #define XFILE_READONLY                OPEN_ACCESS_READONLY
   #define XFILE_WRITEONLY               OPEN_ACCESS_WRITEONLY
   #define XFILE_READWRITE               OPEN_ACCESS_READWRITE

#endif


class _export_ XFile: public XObject
{
   private:
      HFILE handle;
      ULONG pointerPos;
   public:
      void Close() { DosClose(handle); handle = 0; }
      XFile() { handle = 0; pointerPos = 0;}
      ~XFile( ) { if(handle) Close(); }
      static BOOL ChangeCurrentDir( char * path) { return DosSetCurrentDir( (PSZ) path); }
      static ULONG Copy(char* from, char * to) { DosCopy( (PSZ) from, (PSZ) to, 0); }
      static ULONG Move(char* from, char * to) { DosMove( (PSZ) from, (PSZ) to); }
      ULONG Open(char * filename, ULONG size, ULONG modeForOpen, ULONG modeForAcces, EAOP2 * ealist=NULL);
      ULONG QueryPointerPos ( void ) { return pointerPos; }
      ULONG Read( PVOID buffer, ULONG sizeofbuffer)
            {
               ULONG r;
               DosRead(handle, buffer, sizeofbuffer, &r);
               return r;
            }
      static BOOL Remove(char* path) { return DosDelete((PSZ) path); }
      ULONG Seek(LONG pos, ULONG relativePos = XFILE_BEGIN){ return DosSetFilePtr(handle, pos, relativePos, &pointerPos); }
      ULONG Write( PVOID buffer,ULONG sizeofbuffer)
            {
                ULONG r;
                DosWrite(handle, buffer, sizeofbuffer, &r);
                return r;
            }
};


#endif
