#ifndef __OOL_XDRAGEVENT_H__
#define __OOL_XDRAGEVENT_H__

/*===========================================================================*/
/* OOL ------------------- the Open Object Library ------ OS/2 version 0.01a */
/*===========================================================================*/
/*                              class: XDragEvent                            */
/*                       derived from: XEvent                                */
/*                        last update: 7/96                                  */
/*                      programmed by: Stefan von Brauk                      */
/*===========================================================================*/

#include "xevent.h"

#ifdef OOL_FOR_OS2_X86
   //events
   #define DRG_DROPPED   1
   #define DRG_DRAGOVER  2

   //target accept-mode
   #define DRG_DROP      DOR_DROP
   #define DRG_NODROP    DOR_NODROP
   #define DRG_NODROPOP  DOR_NODROPOP
   #define DRG_NEVERDROP DOR_NEVERDROP

   //target operation
   #define DRG_COPY            DO_COPY
   #define DRG_MOVE            DO_MOVE
   #define DRG_LINK            DO_LINK
   #define DRG_ENDCONVERSATION DM_ENDCONVERSATION
   #define DRG_DISCARDOBJECT   DM_DISCARDOBJECT
#endif


class XPoint;
class XDragItem;


/*DOC
CLASS XDragEvent
For drag-events a XDragEvent is generated, to catch them you need to install
a XDragHandler. Possible event-IDs are:

   DRG_DROPPED   an item was dropped
   DRG_DRAGOVER  an item fly over the window

For drag-events in container see:
XContainerDragEvent
XContainerEvent
XContainerHandler
*/
class _export_ XDragEvent: public XEvent
{
      friend MRESULT HandleDefault( XWindow * w, ULONG msg, MPARAM mp1, MPARAM mp2, BOOL& handled);
   private:
      SHORT accept;
      SHORT operation;
      DRAGINFO * dragInfo;
      ~XDragEvent();
   public:
      XDragEvent( LONG, void*);
      BOOL QueryDragItem( XDragItem * itm, SHORT index);
      SHORT QueryDragItemCount( void );
      BOOL QueryDropPos( XPoint * p);
      OOL_WINDOWHANDLE QuerySourceWindow( void );
      SHORT QueryDragOperation(void);
      void SetAcceptMode( SHORT);
      void SetOperation( SHORT);
};


#endif
