#ifndef __OOL_XCOLOR_H__
#define __OOL_XCOLOR_H__

/*===========================================================================*/
/* OOL ------------------- the Open Object Library ------ OS/2 version 0.01a */
/*===========================================================================*/
/*                              class: XColor                                */
/*                       derived from: XObject                               */
/*                        last update: 7/96                                  */
/*                      programmed by: Stefan von Brauk                      */
/*===========================================================================*/



#include "xobject.h"

#define COL_BLACK                        1
#define COL_BLUE                         2
#define COL_RED                          3
#define COL_PINK                         4
#define COL_GREEN                        5
#define COL_CYAN                         6
#define COL_YELLOW                       7
#define COL_BROWN                        8
#define COL_DARKGRAY                     9
#define COL_DARKBLUE                     10
#define COL_DARKRED                      11
#define COL_DARKPINK                     12
#define COL_DARKGREEN                    13
#define COL_DARKCYAN                     14
#define COL_PALEGRAY                     15
#define COL_WHITE                        16


/*DOC
CLASS XColor
DESCRIPTION All classes use colors in RGB format.
*/
class _export_ XColor: public XObject
{
      friend class XWindow;
      friend class XFrameWindow;
      friend class XGraphicObject;
   private:
      char color[4];
   public:
      XColor( LONG col = COL_WHITE);
      XColor( char red, char grenn, char blue);
      virtual ~XColor() {;}
      void SetRed( char red) { color[2] =  red; }
      void SetGreen( char green) { color[1] =  green; }
      void SetBlue( char blue) { color[0] = blue; }
      char GetRed(void) { return color[2]; }
      char GetGreen(void) { return color[1]; }
      char GetBlue(void) { return color[0]; }
      LONG GetColor(void)
         {
            LONG c=0;
            memcpy( &c, &color, 3);
            return c;
         }
};


#endif
