#include "xheaders.h"

#include XWindow_i
#include XWindowDrag_i
#include XDragItem_i
#include XBitmap_i

#include <stdlib.h>
#include <string.h>


XWindowDrag :: XWindowDrag( XWindow * owner, SHORT itemCount )
{
   count = itemCount;
   ownerWindow = owner;
   pInfo = DrgAllocDraginfo( count );
   imageCount = 0;
   pImage = NULL;
}


XWindowDrag :: ~XWindowDrag()
{
/*
   free( pImage );
   DrgDeleteDraginfoStrHandles( pInfo );
   DrgFreeDraginfo( pInfo );
*/
}


OOL_WINDOWHANDLE XWindowDrag :: PerformDrag( void )
{
   return DrgDrag( ownerWindow->GetHandle(), pInfo, pImage, imageCount, VK_BUTTON2, NULL);
}


void XWindowDrag :: AddImage( OOL_ICONHANDLE handle, SHORT style, SHORT xOffset, SHORT yOffset, SHORT stretch)
{
   imageCount += 1;
   pImage = (DRAGIMAGE*) realloc( pImage, sizeof( DRAGIMAGE) * imageCount);
   pImage[imageCount-1].cb = sizeof(DRAGIMAGE);
   pImage[imageCount-1].cxOffset = xOffset;
   pImage[imageCount-1].cyOffset = yOffset;
   pImage[imageCount-1].hImage = handle;
   pImage[imageCount-1].fl = style;
   pImage[imageCount-1].sizlStretch.cx = pImage[imageCount-1].sizlStretch.cy = stretch;
}


void XWindowDrag :: AddImage( XBitmap * bmp, SHORT xOffset, SHORT yOffset, SHORT stretch)
{
   imageCount += 1;
   pImage = (DRAGIMAGE*) realloc( pImage, sizeof( DRAGIMAGE) * imageCount);
   pImage[imageCount-1].cb = sizeof(DRAGIMAGE);
   pImage[imageCount-1].cxOffset = xOffset;
   pImage[imageCount-1].cyOffset = yOffset;
   pImage[imageCount-1].hImage = bmp->hbm;
   pImage[imageCount-1].fl = IMG_BITMAP;
   pImage[imageCount-1].sizlStretch.cx = pImage[imageCount-1].sizlStretch.cy = stretch;
}


SHORT XWindowDrag :: QueryItemCount(void)
{
   return pInfo->cditem;
}


void XWindowDrag :: SetDragItem( XDragItem * item, SHORT number)
{
   DrgSetDragitem( pInfo, item->item, sizeof(DRAGITEM), number);
}


void XWindowDrag :: QueryDragItem( XDragItem * item, SHORT number)
{
   DrgQueryDragitem( pInfo, sizeof(DRAGITEM), item->item, number);
}


LONG XWindowDrag :: QuerySupportedOperation( void )
{
   return pInfo->usOperation;
}


XDragItem :: XDragItem( XWindow * sourceWindow, SHORT operation, LONG id, char * type, char * mechanism)
{
   item = (DRAGITEM*) malloc( sizeof(DRAGITEM));
   memset(item, 0, sizeof(DRAGITEM));
   allocated = TRUE;
   item->hwndItem  = sourceWindow->GetHandle();
   item->ulItemID  = (ULONG) id;
   item->hstrType  = DrgAddStrHandle( (PSZ) type );
   item->hstrRMF   =  DrgAddStrHandle( (PSZ) mechanism );
   item->fsControl = 0;
   item->fsSupportedOps = operation;
}


void XDragItem :: SetMechanism( char * m)
{
   item->hstrRMF = DrgAddStrHandle( (PSZ) m );
}


void XDragItem :: EndConversation( BOOL success )
{
   LONG t = DMFL_TARGETSUCCESSFUL;

   if( success == FALSE)
      t = DMFL_TARGETFAIL;
   DrgSendTransferMsg( item->hwndItem, DM_ENDCONVERSATION, MPFROMLONG( item->ulItemID ), MPFROMLONG( t ));
}


void XDragItem :: QueryTargetName( XString * target)
{
   DrgQueryStrName( item->hstrTargetName, 512, (PSZ) target->GetBuffer( 512 ));
   target->ReleaseBuffer();
}


void XDragItem :: QueryName( XString * sourceName)
{
   DrgQueryStrName( item->hstrSourceName, 512, (PSZ) sourceName->GetBuffer( 512 ));
   sourceName->ReleaseBuffer();
}


void XDragItem :: QueryMechanism( XString * mechanism)
{
   DrgQueryStrName( item->hstrRMF, 512, (PSZ) mechanism->GetBuffer( 512 ));
   mechanism->ReleaseBuffer();
}


void XDragItem :: QueryType( XString * type)
{
   DrgQueryStrName( item->hstrType, 512, (PSZ) type->GetBuffer( 512 ));
   type->ReleaseBuffer();
}


void XDragItem :: QueryContainerName( XString * containerName)
{
   DrgQueryStrName( item->hstrContainerName, 512, (PSZ) containerName->GetBuffer( 512 ));
   containerName->ReleaseBuffer();
}


void XDragItem :: Accept( BOOL accept )
{
   if( accept )
      DrgSendTransferMsg( item->hwndItem, DM_ENDCONVERSATION, (MPARAM) item->ulItemID, MPFROMLONG( DMFL_TARGETSUCCESSFUL ) );
   else
      DrgSendTransferMsg( item->hwndItem, DM_ENDCONVERSATION, (MPARAM) item->ulItemID, MPFROMLONG( DMFL_TARGETFAIL ) );
}


BOOL XDragItem :: VerifyItemType( char * mechanism, char * format)
{
   return DrgVerifyRMF( item, (PSZ) mechanism, (PSZ) format);
}


LONG XDragItem :: QueryID(void)
{
   return item->ulItemID;
}


void XDragItem :: SetContainerName( char * containerName)
{
   item->hstrContainerName = DrgAddStrHandle( (PSZ) containerName );
}


void XDragItem :: SetName( char * name)
{
   item->hstrSourceName = DrgAddStrHandle( (PSZ) name );
}


void XDragItem :: SetTargetName( char * target)
{
   item->hstrTargetName = DrgAddStrHandle( (PSZ) target );
}


XDragItem :: ~XDragItem()
{
/*
   if(allocated)
      free( item );
*/
}
