#include "xcolor.h"

#include <string.h>

/*DOC
CLASS XColor
FUNCTION XColor
GROUP constructors/destructors
REMARKS The constructor of XColor.

Parameters:    LONG theColor      The color to initialize. Valid parameters are:
                                  <HTML>
                                     COL_BLACK<BR>
                                     COL_BLUE<BR>
                                     COL_RED<BR>
                                     COL_PINK<BR>
                                     COL_GREEN<BR>
                                     COL_CYAN<BR>
                                     COL_YELLOW<BR>
                                     COL_BROWN<BR>
                                     COL_DARKGRAY<BR>
                                     COL_DARKBLUE<BR>
                                     COL_DARKRED<BR>
                                     COL_DARKPINK<BR>
                                     COL_DARKGREEN<BR>
                                     COL_DARKCYAN<BR>
                                     COL_PALEGRAY<BR>
                                     COL_WHITE<BR>
                                     other: color in RGB-format, forth byte is ignored</HTML>
*/
XColor :: XColor( LONG col)
{
  color[3] = 0;

  switch( col)
   {
     case COL_BLACK:
        color[0] = color[1] = color[2] = 0; break;
     case COL_BLUE:
        color[0] = 255;
        color[1] = 0;
        color[2] = 0;
        break;
     case COL_RED:
        color[0] = 0;
        color[1] = 0;
        color[2] = 255;
        break;
     case COL_PINK:
        color[0] = 255;
        color[1] = 0;
        color[2] = 255;
        break;
     case COL_GREEN:
        color[0] = 0;
        color[1] = 255;
        color[2] = 0;
        break;
     case COL_CYAN:
        color[0] = 255;
        color[1] = 255;
        color[2] = 0;
        break;
     case COL_YELLOW:
        color[0] = 0;
        color[1] = 255;
        color[2] = 255;
        break;
     case COL_BROWN:
        color[0] = 0;
        color[1] = 128;
        color[2] = 128;
        break;
     case COL_DARKGRAY:
        color[0] = color[1] = color[2] = 128; break;
     case COL_DARKBLUE:
        color[0] = 128;
        color[1] = 0;
        color[2] = 0;
        break;
     case COL_DARKRED:
        color[0] = 0;
        color[1] = 0;
        color[2] = 128;
        break;
     case COL_DARKPINK:
        color[0] = 128;
        color[1] = 0;
        color[2] = 128;
        break;
     case COL_DARKGREEN:
        color[0] = 0;
        color[1] = 128;
        color[2] = 0;
        break;
     case COL_DARKCYAN:
        color[0] = 128;
        color[1] = 128;
        color[2] = 0;
        break;
     case COL_PALEGRAY:
        color[0] = color[1] = color[2] = 206;
        break;
     case COL_WHITE:
        color[0] = color[1] = color[2] = 255;
        break;
     default:
        memcpy(&color, &col, 4);
   }
}


XColor :: XColor( char red, char green, char blue)
{
  color[2] = red;
  color[1] = green;
  color[0] = blue;
  color[3] = 0;
}

/*
void XColor :: SetRed( char red)
{ color[2] =  red; }

void XColor :: SetGreen( char green)
{ color[1] =  green; }

void XColor :: SetBlue( char blue)
{ color[0] = blue; }

char XColor :: GetRed(void)
{ return color[2]; }

char XColor :: GetGreen(void)
{ return color[1]; }

char XColor :: GetBlue(void)
{ return color[0]; }

LONG XColor :: GetColor(void)
{
  LONG c=0;
  memcpy( &c, &color, 3);
  return c;
}
*/
