#include "xcircsld.h"


XCircularSlider :: XCircularSlider(HWND hwnd): XControl( hwnd )
{ ;}

XCircularSlider :: XCircularSlider( XWindow * owner, XRect * rec, USHORT id, ULONG style):XControl( rec, style, owner, "", WC_CIRCULARSLIDER, id)
{; }


SHORT XCircularSlider :: GetValue( void )
{
   SHORT val;
   WinSendMsg( winhandle,  CSM_SETRANGE, MPFROMP(&val), 0);
   return val;
}

BOOL XCircularSlider :: SetIncrements( SHORT ticks, SHORT steps)
{
   return SHORT1FROMMR( WinSendMsg( winhandle,  CSM_SETINCREMENT, MPFROMSHORT(steps), MPFROMSHORT(ticks)));
}


BOOL XCircularSlider :: SetLimits( LONG lowerLimit, LONG upperLimit)
{
   return SHORT1FROMMR( WinSendMsg( winhandle,  CSM_SETRANGE, MPFROMSHORT(lowerLimit), MPFROMSHORT(upperLimit)));
}


BOOL XCircularSlider :: SetValue( LONG val)
{
   return SHORT1FROMMR( WinSendMsg( winhandle,  CSM_SETVALUE, MPFROMSHORT(val), 0));
}


