#include "sample5.h"

#include XColor_i
#include XMessageBox_i
#include XString_i
#include XMenuBar_i
#include XControlEvent_i
#include XPoint_i



#define DEPARTMENT 1
#define WORKER 2

#include <stdlib.h>

MyApp * app;
XResourceLibrary * resourceLib;

//here a window is created out of the resource-file, the last parameter tells the library
//to build the window with the ID given in XResource. Works with resource-DLLs too.
MyAppWindow :: MyAppWindow( XApplication * app, XResource * r ): XScrollWindow( r, "Sample5 - Container", XFrameWindow::defaultStyle | FRM_TASKLIST | FRM_CENTER,  NULL, NULL, TRUE )
{
   //we add a menubar to the window, the resources are in the resource-DLL
   XResource res(IDM_MENU, resourceLib);
   XMenuBar * menu = new XMenuBar( this, &res);

   //add scroller to the window
   AddVertScroller();
   AddHorzScroller();

   //because we have added a menubar and scrollers, we must resize the window
   XRect rec;
   GetSize( &rec );
   rec.SetHight( rec.GetHight() + 40);
   rec.SetWight( rec.GetWight() + 15);
   SetSize( &rec );

   //Activate the window
   Activate();
}


MyAppWindow :: ~MyAppWindow()
{
}


/* here the commands of the menu and the pushbuttons are posted */
void MyAppWindow :: DoCommand( LONG com)
{
   switch( com )
      {
         //the two menu-items of interest, we terminate the application in every case
         case IDM_CANCEL:
         case IDM_OK:
         //also push-buttons post a command if they are pressed
         case PUSH_OK:
         case PUSH_CANCEL:
            {
               app->Terminate();
            }
            break;
      }
}


//here the control-events of our window-contents are posted
void MyAppWindow :: DoControl( XControlEvent * event)
{
   switch( event->GetEventID()) //what type of event?
      {
         case WIN_CHANGED:      //window-content changed
            {
               switch( event->GetWindowID()) //which window posted the event?
                  {
                     case RADIO_MALE:        //the radio-button MALE is clicked
                        //add your code here to handle the event
                        break;
                     case RADIO_FEMALE:      //the radio-button FEMALE is clicked
                        //add your code here to handle the event
                        break;
                     default:
                        break;        //entry-field, ignored in this sample
                  }
            }
      }
}


MyApp :: MyApp(): XApplication()
{
   //we create a resource-DLL (sample5.dll), it contains the resources for the window
   resourceLib = new XResourceLibrary( this, "sample5" );

   //we create a resource with our DLL which contains the id of the resource-window (see sample5.dlg)
   XResource r( WIN_MAIN, resourceLib);
   app = this;

   //create the window
   window = new MyAppWindow( this, &r );
}


void main ( void)
{
   MyApp * app = new MyApp();  //create a new application
   app->Start();               //let the application work
}
