#include "sample2.h"
#include "dialog.h"

#include XColor_i
#include XMessageBox_i
#include XDragHandler_i


MyApp * app;

class MyAboutWin: public XFrameWindow
{
  public:
    MyAboutWin( XResource *);
    void DoCommand( LONG);
};


void MyAboutWin :: DoCommand( LONG com)
{
  if( com == DID_PUSH_OK)  //ok-button pressed, close window
     delete this;//Close();
}


MyAboutWin :: MyAboutWin ( XResource * r): XFrameWindow ( r, "About", XFrameWindow::defaultDialogStyle | FRM_CENTER, NULL, NULL, TRUE)
{
}


BOOL MyApp :: QueryForQuit( void )
{
  XMessageBox mBox( "Do you realy want to quit?", "To the User", MB_YESNO | MB_ICONQUESTION|MB_MOVEABLE, window);

  if( mBox.GetCommand() == MBID_YES)
     return TRUE;
  else
     return FALSE;
}


BOOL MyAppWindow :: QueryForClose( void )
{
  XMessageBox mBox( "Ready to go?", "To the User", MB_YESNO | MB_ICONQUESTION|MB_MOVEABLE, this);

  if( mBox.GetCommand() == MBID_YES)
     {
        return TRUE;
     }
  else
     return FALSE;
}


MyAppWindow :: MyAppWindow( XApplication * app, XResource r ): XScrollWindow( &r, "Sample2 - Its not Netscape", XFrameWindow::defaultDialogStyle | FRM_MINBUTTON | FRM_TASKLIST | FRM_ICON, &XRect( 100, 100, 670, 500))
{
   SetBackgroundColor( &XColor( COL_WHITE));

   //we want a menubar, it is defined in the resources of the exe-file with the id IDM_MAIN
   XResource rs( IDM_MAIN, app->GetResourceLibrary());
   menu = new XMenuBar( this, &rs);

   //we create a toolbar for the buttons at the top...
   toolBar1 = new XToolBar( this, TB_TOP );

   //now create pushbuttons with bitmaps, the bitmaps must be in the resources of the exe
   XRect rec( 0, 0, 30, 30);
   back = new XPushButton( toolBar1, &rec, (USHORT) IDM_BACK, BU_BITMAP);
   forward = new XPushButton( toolBar1, &rec, (USHORT) IDM_FORWARD, BU_BITMAP);
   home = new XPushButton( toolBar1, &rec, (USHORT) IDM_HOME, BU_BITMAP);

   //add the pushbuttons to the toolbar, the toolbar will use the size of the first button
   toolBar1->AddWindow( back , FALSE, TRUE);
   toolBar1->AddWindow( forward );
   toolBar1->AddWindow( home );

   //create another toolbar
   toolBar2 = new XToolBar( this);
   toolBar2->SetHight( 50 );

   text = new XStaticText( toolBar2, "Location:", &XRect( 0, 0, 80, 20), TX_RIGHT);
   text->SetForegroundColor( &XColor( COL_BLACK) );
   toolBar2->AddWindow( text, FALSE, FALSE, NULL, 0, -23);

   http = new XComboBox(toolBar2, &XRect( 0, 0, 490, 200));
   SHORT res = http->InsertItem( "http://www.ibm.com" );
   http->SelectItem( res );
   toolBar2->AddWindow( http, TRUE, FALSE, NULL, -10, - 20);

   /* now a grphic-button will be created. the button displays a simple animation. */
   /* to do so, the buttons needs a list of bitmap-IDs (from bitmaps in the resources)*/
   /* which build the animation. in this case we have 6 bitmaps */
   SHORT list[6] = {STAR1, STAR2, STAR3, STAR4, STAR5, STAR6};

   /* give in the constructor the styles for playing animation. additionaly the button */
   /* has two states (if you press the button, it will not come up automaticaly */
   animation = new XGraphicButton( toolBar2, &XRect(0,0,0,0), IDM_ANIMATION, WIN_VISIBLE | GB_ANIMATION | GB_AUTOTWOSTATE, "", 6, list);

   /* set the speed of the animation */
   animation->SetAnimationRate( 50 );

   /* add the button to the toolbar */
   toolBar2->AddWindow( animation, FALSE, TRUE, NULL, 10);

   //..and a toolbar at the bottom

   toolBar3 = new XToolBar( this, TB_BOTTOM);
   toolBar3->SetHight( 30);

   key = new XStaticBitmap( toolBar3, &XRect(0,0,40,40), IDM_KEY);
   toolBar3->AddWindow( key, FALSE, FALSE, NULL, 10, -3);

   border = new XStaticFrame( toolBar3, &XRect( 0,0, 500, 20));
   toolBar3->AddWindow( border, TRUE, FALSE, 0, -4);

   text2 = new XStaticText( toolBar3, "Document done", &XRect( 0, 0, 150, 20), TX_LEFT | TX_VCENTER);
   text2->SetForegroundColor( &XColor( COL_BLACK) );
   toolBar3->AddWindow( text2, FALSE, FALSE, NULL, -490);
   text2->SetFont( "8.Helvetica");

   //we want a vertical scrollbar
   AddVertScroller();

   //setup the menu

   menu->CheckItem( IDM_TOOLBAR, TRUE);
   menu->CheckItem( IDM_URL, TRUE);
   menu->CheckItem( IDM_STATUSLINE, TRUE);

   /* we create a >about< window */
   MyAboutWin * win = new MyAboutWin( &XResource( DIALOG_ABOUT, app->GetResourceLibrary()));

   /* show the window application-modal */
   win->ShowModal( this );

   /* the >about< window is destructed, now play the animation! */
   animation->Animate();
}


void MyAppWindow :: Draw( void )
{
   FillBackground( );
}


void MyAppWindow :: DoCommand( LONG com)
{
  switch(com)
     {
        case IDM_ANIMATION:
           if( animation->IsSelected() == TRUE)
             animation->Animate(FALSE);
           else
             animation->Animate( TRUE, FALSE);
           return;
        case IDM_ABOUT:  //menuitem <about> selected, show the window
           {
              MyAboutWin * win = new MyAboutWin( &XResource( DIALOG_ABOUT, app->GetResourceLibrary()));
              win->ShowModal( this );
           }
           break;
        case IDM_TOOLBAR:
           {
              if( toolBar1->IsVisible())
                 {
                    menu->CheckItem( IDM_TOOLBAR, FALSE);
                    toolBar1->Hide();
                 }
              else
                 {
                    menu->CheckItem( IDM_TOOLBAR, TRUE);
                    toolBar1->Show();
                 }
           }
           break;
        case IDM_STATUSLINE:
           {
              if( toolBar3->IsVisible())
                 {
                    menu->CheckItem( IDM_STATUSLINE, FALSE);
                    toolBar3->Hide();
                 }
              else
                 {
                    menu->CheckItem( IDM_STATUSLINE, TRUE);
                    toolBar3->Show();
                 }
           }
           break;
        case IDM_URL:
           {
              if( toolBar2->IsVisible())
                 {
                    menu->CheckItem( IDM_URL, FALSE);
                    toolBar2->Hide();
                 }
              else
                 {
                    menu->CheckItem( IDM_URL, TRUE);
                    toolBar2->Show();
                 }
           }
           break;
     }
}


void main ( void)
{
   app = new MyApp();  //create a new application

   XResource r( IDM_ICON, app->GetResourceLibrary());

   app->window = new MyAppWindow( app, r );   //create new framewindow (see above)

   app->Start();               //let the application work
}
