#ifndef __OOL_XCONTAINERHANDLER_H__
#define __OOL_XCONTAINERHANDLER_H__

/*===========================================================================*/
/* OOL ------------------- the Open Object Library ------ OS/2 version 0.01a */
/*===========================================================================*/
/*                              class: XContainerHandler                     */
/*                       derived from: XHandler                              */
/*                        last update: 5/96                                  */
/*                      programmed by: Stefan von Brauk                      */
/*===========================================================================*/

#include "xhandler.h"


class XContainerEvent;
class XContainerControl;

/*DOC
CLASS XContainerHandler
To catch events from a container you need to derive a class from XContainerHandler
and override the method HandleEvent where you will get the events.
In the case of drag-events XContainerDragEvent are posted, in the method HandleEvent
you can typecast in this case.
*/
class _export_ XContainerHandler: public XHandler
{
   public:
      XContainerHandler( XFrameWindow * w): XHandler( OOL_CONTAINERHANDLER, (XWindow*) w ) { ;}
      virtual BOOL HandleEvent( XContainerEvent *) { return FALSE;}
};


#endif
