# $Header: E:/Projects/OCL/EMX/rcs/EMXLIB.MAK 1.4 1996/01/16 10:12:10 B.STEIN Release B.STEIN $

!include $(OCL)\COMMON.INC
!include $(OCL)\OCLOBJ.INC

# When compiling the debug version use the following statements
# CFLAGS = $(EMX_COMPILE_DEBUG)
# EMX_LIB_NAME = OCLEMXD

CFLAGS = $(EMX_COMPILE)
MAKEDEP = EMXLIB.MAK

.all: .\OCLEMX.LIB .\OCLEMX.DEF OCLEMXI.LIB .\OIPEMX.LIB .\OIPEMX.DEF

OCL: .\OCLEMX.LIB .\OCLEMX.DEF OCLEMXI.LIB
OIP: .\OIPEMX.LIB .\OIPEMX.DEF
ALL: OCL OIP 

.SUFFIXES:
.SUFFIXES: .cpp .obj

{$(OCL)\Source}.cpp.obj:
  @echo Compiling: $(@B)
  @gcc $(CFLAGS) %s

.\OCLEMX.LIB: $(ALLOBJ) $(MAKEDEP)
  emxomfar rc OCLEMX.LIB *.obj
  @del *.obj >NUL
  @copy OCLEMX.LIB $(OCL)\LIB\OCLEMX.LIB

.\OCLEMX.DEF: .\OCLEMX.LIB $(MAKEDEP)
  @echo LIBRARY OCLEMX INITINSTANCE TERMINSTANCE >OCLEMX.DEF
  @echo DESCRIPTION 'OCL C++ Class Library 1.50 ($EMX09b/GCC270) (c) 1996 by Cubus - All Rights reserved.' >>OCLEMX.DEF
  @echo DATA MULTIPLE NONSHARED READWRITE LOADONCALL >>OCLEMX.DEF
  @echo CODE LOADONCALL >>OCLEMX.DEF
  @echo PROTMODE >>OCLEMX.DEF
  @echo IMPORTS >>OCLEMX.DEF 
  @echo   DosQuerySysState = DOSCALLS.368 >>OCLEMX.DEF
  @echo EXPORTS >>OCLEMX.DEF
  @emxexp -n -o OCLEMX.LIB >>OCLEMX.DEF

.\OIPEMX.LIB: $(OIPOBJ) $(MAKEDEP)
  emxomfar rc OIPEMX.LIB *.obj
  @del *.obj >NUL
  @copy OIPEMX.LIB $(OCL)\LIB\OIPEMX.LIB

.\OIPEMX.DEF: .\OIPEMX.LIB $(MAKEDEP)
  @echo LIBRARY OIPEMX INITINSTANCE TERMINSTANCE >OIPEMX.DEF
  @echo DESCRIPTION 'OIP C++ Class Library 1.50 ($EMX09b/GCC270) (c) 1996 by Cubus - All Rights reserved.' >>OIPEMX.DEF
  @echo DATA MULTIPLE NONSHARED READWRITE LOADONCALL >>OIPEMX.DEF
  @echo CODE LOADONCALL >>OIPEMX.DEF
  @echo PROTMODE >>OIPEMX.DEF
  @echo EXPORTS >>OIPEMX.DEF
  @emxexp -n -o OIPEMX.LIB >>OIPEMX.DEF


.\OCLEMXI.LIB: .\OCLEMX.DEF .\OIPEMX.DEF
  @if exist OCLEMXI.LIB erase OCLEMXI.LIB
  implib .\OCLEMXI.LIB .\OCLEMX.DEF .\OIPEMX.DEF
  @copy OCLEMXI.LIB $(OCL)\LIB\OCLEMXI.LIB

!include $(OCL)\COMMON.DEP
