/*	kibo.c		program for randomly replacing words on the standard
 *			input with "kibo", appropriately capitalised.
 *			Author:		acb
 *			Commenced:	19-7-1993
 *
 *			This program is part of the Emperor Norton Utilities.
 *			(K) All rites reversed.
 */
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#define ALLCAPS	0
#define nocaps 	1
#define Initcap	2
char *kibo[] = {"SLACK", "slack", "Slack"};
#define isdelim(sil) (isspace(sil) || ispunct(sil))
#define goahead ((random()&0x0f) == 1)
/*#define goahead (1)*/
char get() {	char c = getchar(); if (c==EOF) exit(0); return c; }
int caps(char w[]) {
	if (!isupper(w[0])) return nocaps;
	else if (isupper(w[1])) return ALLCAPS;
	else return Initcap;
}
void main() {
	int started=0;
	char word[256];
	while(1) {
		char c;
		int i;
		/* Seek to start of word */
		do { c = get(); if (isdelim(c)) putchar(c); } while isdelim(c);
		if (!started) { srandom(started); started = 1; }
		/* Now read in the word */
		i=0;
		do {
			word[i++] = c;
			c=get();
		} while (!isdelim(c));
		word[i]='\0';
		if goahead printf("%s", kibo[caps(word)]);
		else printf("%s", word);
		putchar(c);
	}
}
