{***************************************************************************}
{*                                                                         *}
{* The Portable TrueType Engine - Copyright 1996 David TURNER              *}
{*_________________________________________________________________________*}
{*                                                                         *}
{*                                                                         *}
{*   TTVars : A Very simple unit to declare the engine's variables         *}
{*            and layout.                                                  *}
{*                                                                         *}
{*                                                                         *}
{***************************************************************************}

unit TTVars;

interface

uses TTTypes;

const

  (* Rounding Mode constants *)

  TTRoundOff          = 0;
  TTRoundToHalfGrid   = 1;
  TTRoundToGrid       = 2;
  TTRoundToDoubleGrid = 3;
  TTRoundUpToGrid     = 4;
  TTRoundDownToGrid   = 5;
  TTRoundSuper        = 6;

  (* Touch flags masks *)

  TTFlagOnCurve       = 1;
  TTFlagTouchedX      = 2;
  TTFlagTouchedY      = 4;
  TTFlagTouchedBoth   = TTFlagTouchedX or TTFlagTouchedY;

var
  GS        : TGraphicsState; (* Current Graphics State record  *)
                              (* NOTE : this is not a pointer ! *)

  CVT       : PShortArray;   (* Pointer to the current CVT *)
  CvtSize   : int;           (* Size of the current CVT    *)



  Scale1,               (* These values are used to scale quickly *)
  Scale2    : LongInt;  (* from EM to pixel coordinates           *)

  PointSize : F26dot6;  (* The PointSize in 26.6 fixed point *)



implementation

end.
