{**********************************************************}
{*                                                        *}
{* The following routines are inline assembly, they are   *}
{* thus processor and bitness specific. Replace them      *}
{* with your own if you want to port the TrueType Engine  *}
{* To different platforms                                 *}
{*                                                        *}
{* There are C equivalents in comments                    *}

{**********************************************************}
{* Four operations to convert from Motorola to Intel      *}
{*                                                        *}
{* Make these void macros if you don't need them..        *}

(*
   void Do16( unsigned short* S )
   {
     *S = ( *S >> 8 ) | ( *S << 8 );
   }
*)

procedure Do16( var S ); assembler;
asm
  push ecx
  mov ecx,[S].dword
  mov ax,[ecx]
  xchg al,ah
  mov [ecx],ax
  pop ecx
end;

(*
   void Do16s( unsigned short* S, int Cnt )
   {
     while ( Cnt > 0 )
     {
       *S = ( *S >> 8 ) | ( *S << 8 );
       S++;
       Cnt--;
     }
   }
*)

procedure Do16s( var S; Cnt : Int ); assembler; {&USES ebx, ecx }
asm
  mov ebx,[S].dword
  mov ecx,[Cnt]
 @1:
  mov ax,[ebx]
  xchg al,ah
  mov [ebx],ax
  add ebx,2
  dec cx
  jnz @1
end;

(*
  void Do32( unsigned long* L )
  {
    *L = ( *L << 24 ) | ( ( *L  << 8 ) & 0x0F00 ) |
         ( ( *L >> 8 ) & 0x00F0 ) | ( *L >> 24 );
  }
*)

procedure Do32( var L ); assembler; {&USES ebx}
asm
  mov ebx,[L]
  mov dx,[ebx].word
  mov ax,[ebx+2].word
  xchg al,ah
  xchg dl,dh
  mov [ebx+2].word,dx
  mov [ebx].word,ax
end;

(*
  void Do32s( unsigned long* L, int Cnt )
  {
    while ( Cnt > 0 )
    {
      *L = ( *L << 24 ) | ( ( *L  << 8 ) & 0x0F00 ) |
           ( ( *L >> 8 ) & 0x00F0 ) | ( *L >> 24 );
      L++;
      Cnt--;
    }
  }
*)

procedure Do32s( var L; Cnt : int ); assembler; {&USES ebx, ecx}
asm
  mov ebx,[L].dword
  mov ecx,[Cnt]
 @1:
  mov dx,[ebx].word
  mov ax,[ebx+2].word
  xchg al,ah
  xchg dl,dh
  mov [ebx+2].word,dx
  mov [ebx].word,ax
  add ebx,4
  dec cx
  jnz @1
end;



{**********************************************************}
{* Calc A*B/C with Intermediate 64 bit precision          *}

(*
  long MulDiv( long A, B, C )
  {
    return ((A*B)/C);  // And a good optimising compiler
  }
*)

function MulDiv( A, B, C : Int32 ): Int32; assembler; {&USES ebx, ecx}
asm
  mov eax,[A]
  mov ecx,[B]
  mov ebx,[C]
  imul ecx
  idiv ebx
end;



{**********************************************************}
{* 64 Bit Addition                                        *}

procedure Add64( var X, Y, Z : Int64 ); assembler; {&USES ebx, edx}
asm
  mov ebx,[X].dword
  mov eax,[ebx]
  mov edx,[ebx+4]

  mov ebx,[Y].dword
  add eax,[ebx]
  adc edx,[ebx+4]

  mov ebx,[Z].dword
  mov [ebx],eax
  mov [ebx+4],edx
end;


{**********************************************************}
{* 64 Bit Substraction                                    *}

procedure Sub64( var X, Y, Z : Int64 ); assembler; {&USES ebx, edx}
asm
  mov ebx,[X].dword
  mov eax,[ebx]
  mov edx,[ebx+4]

  mov ebx,[Y].dword
  sub eax,[ebx]
  sbb edx,[ebx+4]

  mov ebx,[Z].dword
  mov [ebx],eax
  mov [ebx+4],edx
end;


{**********************************************************}
{* Multiply two Int32 to an Int64                         *}

procedure MulTo64( X, Y : Int32; var Z : Int64 ); assembler; {&USES ebx, edx }
asm
  mov ebx,[Z].dword
  mov eax,[X]
  imul [Y]
  mov [ebx],eax
  mov [ebx+4],edx
end;


{**********************************************************}
{* Divide an Int64 by an Int32                            *}

function Div64by32( var X : Int64; Y : Int32 ) : Int32; assembler;
         {&USES ebx, edx}
asm
  mov ebx,[X].dword
  mov eax,[ebx]
  mov edx,[ebx+4]
  idiv [Y]
end;


{**********************************************************}
{* MSB index ( return -1 for 0 )                          *}

function Order64( var Z : Int64 ) : int; assembler; {&USES ebx, ecx, edx}
asm
  mov ebx,[Z].dword
  mov eax,[ebx  ]
  mov edx,[ebx+4]
  mov ebx,63
  mov ecx,$80000000

 @1:
  test edx,ecx
  jnz @3
  dec ebx
  ror ecx,1
  jns @1

 @2:
  test eax,ecx
  jnz @2
  dec ebx
  ror ecx,1
  jns @2

 @3:
  mov eax,ebx
end;


{**********************************************************}
{* MSB index ( return -1 for 0 )                          *}

function Order32( Z : Int32 ) : int; assembler; {&USES ebx, ecx, edx}
asm
  mov eax,[Z]
  mov ebx,31
  mov ecx,$80000000

 @1:
  test edx,ecx
  jnz @2
  dec ebx
  ror ecx,1
  jns @1

 @2:
  mov eax,ebx
end;

