/* sys/sigprocm.c (emx+gcc) -- Copyright (c) 1994-1996 by Eberhard Mattes */

#define INCL_DOSEXCEPTIONS
#include <os2emx.h>
#include <errno.h>
#include <emx/syscalls.h>
#include "syscalls.h"

int __sigprocmask (int how, const sigset_t *iset, sigset_t *oset)
{
  thread_data *tp;
  sigset_t temp, output;

  tp = SYS_THREAD;
  output = tp->sig_blocked;
  if (iset != NULL)
    {
      switch (how)
        {
        case SIG_BLOCK:
          temp = tp->sig_blocked | *iset;
          break;
        case SIG_UNBLOCK:
          temp = tp->sig_blocked & ~*iset;
          break;
        case SIG_SETMASK:
          temp = *iset;
          break;
        default:
          errno = EINVAL;
          return -1;
        }
      SET_BLOCKED (tp, temp);
    }

  if (oset != NULL)
    *oset = output;

  _sys_deliver_pending_signals (tp);
  return 0;
}
