/* accept.c (emx+gcc) -- Copyright (c) 1994-1996 by Eberhard Mattes */

#include <sys/fcntl.h>
#include <errno.h>
#include <emx/io.h>
#include <emx/syscalls.h>

int accept (int handle, struct sockaddr *addr, int *paddrlen)
{
  int s, *pflags;

  s = __accept (handle, addr, paddrlen);
  if (s < 0)
    return -1;
  if ((pflags = _fd_init (s)) == NULL)
    {
      __close (s);
      errno = EMFILE;
      return -1;
    }
  *pflags = O_RDWR | F_SOCKET;
  return s;
}
