/* localeco.c (emx+gcc) -- Copyright (c) 1994-1996 by Eberhard Mattes */

#include <stdlib.h>
#include <limits.h>
#include <locale.h>
#include <emx/locale.h>

/* Assume that all the library modules are compiled with the same
   signedness of char. */

#define CONVERT(F) tmp.F = (_cur_lconv.F == CHAR_MAX \
                           ? (char)char_max : _cur_lconv.F)


/* TODO: This is not yet thread-safe. */

static char grouping[64];
static int gi;

static void convert_grouping (char **dst, char **src, int char_max)
{
  const char *s;

  s = *src;
  while (*s != 0 && *s != CHAR_MAX)
    ++s;
  if (*s == CHAR_MAX)
    {
      *dst = grouping + gi;
      for (s = *src; *s != CHAR_MAX; ++s)
        grouping[gi++] = *s;
      grouping[gi++] = (char)char_max;
    }
}
    

struct lconv *_localeconv (int char_max)
{
  static struct lconv tmp;

  tmp = _cur_lconv;
  CONVERT (int_frac_digits);
  CONVERT (frac_digits);
  CONVERT (p_cs_precedes);
  CONVERT (p_sep_by_space);
  CONVERT (n_cs_precedes);
  CONVERT (n_sep_by_space);
  CONVERT (p_sign_posn);
  CONVERT (n_sign_posn);

  if (char_max != CHAR_MAX)
    {
      gi = 0;
      convert_grouping (&tmp.grouping, &_cur_lconv.grouping, char_max);
      convert_grouping (&tmp.mon_grouping, &_cur_lconv.mon_grouping, char_max);
    }

  return &tmp;
}


struct lconv *(localeconv) (void)
{
  return _localeconv (127);
}
