/* egavline.c (emx+gcc) -- Copyright (c) 1994 by Steffen Haecker */

#include <stdlib.h>
#include <sys/hw.h>
#include "graph2.h"
#include "ega.h"


void _ega_vline (unsigned x, unsigned y, unsigned n, int color)
{
  volatile unsigned char *p;

  GLOCK;
  OUT3 (color << 8, 0x0f01, (0x8000 >> (x & 7)) | 8);
  p = _g_mem + (y * 80 + x / 8);
  while (n > 0)
    {
      ++(*p);
      p += 80;
      --n;
    }
  OUT2 (0xff08, 1);
  GUNLOCK;
}
