/* _rmtmp.c (emx+gcc) -- Copyright (c) 1990-1996 by Eberhard Mattes */

#include <sys/builtin.h>        /* For <sys/fmutex.h> */
#include <sys/fmutex.h>         /* For <sys/rmutex.h> */
#include <sys/rmutex.h>
#include <stdio.h>
#include <emx/io.h>

int _rmtmp (void)
{
  int i, n;
  struct streamvec *sv;

  /* Ignore locked streams to avoid deadlock on process
     termination. */

  n = 0;
  for (sv = &_streamvec_head; sv != NULL; sv = sv->next)
    for (i = 0; i < sv->n; ++i)
      if ((sv->vec[i]._flags & _IOOPEN) && (sv->vec[i]._flags & _IOTMP)
          && STREAM_UNLOCKED (&sv->vec[i])
          && fclose (&sv->vec[i]) == 0)
        ++n;
  return n;
}
