/* Client process that communicates with GNU Emacs acting as server.
   Copyright (C) 1992-1996 Eberhard Mattes

This file is part of GNU Emacs.

GNU Emacs is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Emacs is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Emacs; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#include <stdio.h>
#include <stdlib.h>
#include <process.h>

#define INCL_DOSQUEUES
#define INCL_DOSPROCESS
#define INCL_DOSERRORS
#define INCL_WINSWITCHLIST
#include <os2.h>

#include "getopt.h"

static char *prog_name;

static void error (ULONG rc, const char *fun)
{
  fprintf (stderr, "%s failed, rc=%lu\n", fun, rc);
  exit (1);
}

#define ERROR(fun) if (rc != 0) error (rc, fun)

static void usage (void)
{
  fprintf (stderr, "Usage: %s [-sw] [+linenumber] filename ...\n", prog_name);
  exit (1);
}


int main (int argc, char *argv[])
{
  int i, done, opt, wait_flag, switch_flag;
  ULONG rc, len;
  HQUEUE hq_client, hq_server;
  PID owner_pid;
  REQUESTDATA request;
  BYTE priority;
  PVOID data;
  char string[1024], *p;

  prog_name = argv[0];
  _wildcard (&argc, &argv);
  wait_flag = 1; switch_flag = 1;
  while ((opt = getopt (argc, argv, "sw")) != EOF)
    switch (opt)
      {
      case 's':
        switch_flag = 0;
        break;
      case 'w':
        wait_flag = 0;
        break;
      default:
        usage ();
      }
  if (argc - optind < 1)
    wait_flag = 0;

  sprintf (string, "/queues/emacs19/clients/%d", (int)getpid ());
  rc = DosCreateQueue (&hq_client, QUE_FIFO | QUE_CONVERT_ADDRESS, string);
  ERROR ("DosCreateQueue");
  rc = DosOpenQueue (&owner_pid, &hq_server, "/queues/emacs19/server");
  if (rc == ERROR_QUE_NAME_NOT_EXIST)
    {
      if (argc - optind < 1)
        usage ();
      fprintf (stderr, "%s: Can't create queue; "
               "have you started the server?\n", prog_name);
      return (1);
    }
  ERROR ("DosOpenQueue");
  len = 2;
  for (i = optind; i < argc; i++)
    {
      if (argv[i][0] == '+')
	strcpy (string, argv[i]);
      else
	_abspath (string, argv[i], sizeof (string));
      len += strlen (string) + 1;
    }
  rc = DosAllocSharedMem (&data, 0, len,
			  PAG_COMMIT | OBJ_GIVEABLE | PAG_READ | PAG_WRITE);
  ERROR ("DosAllocSharedMem");
  rc = DosGiveSharedMem (data, owner_pid, PAG_READ);
  ERROR ("DosGiveSharedMem");
  p = data;
  for (i = optind; i < argc; ++i)
    {
      if (argv[i][0] == '+')
	strcpy (string, argv[i]);
      else
	_abspath (string, argv[i], sizeof (string));
      _fnlwr (string);
      strcpy (p, string);
      p += strlen (string);
      *p++ = ' ';
    }
  *p++ = '\n';
  *p = 0;
  rc = DosWriteQueue (hq_server, 0, len, data, 0);
  ERROR ("DosWriteQueue");
  rc = DosFreeMem (data);
  ERROR ("DosFreeMem");

  if (wait_flag)
    {
      printf ("Waiting for Emacs...");
      fflush (stdout);
      do
	{
	  rc = DosReadQueue (hq_client, &request, &len, &data, 0,
			     DCWW_WAIT, &priority, 0);
	  ERROR ("DosReadQueue");
	  fputs (data, stdout);
	  done = (memcmp ("Close:", data, 6) == 0);
	  rc = DosFreeMem (data);
	  ERROR ("DosFreeMem");
	} while (!done);
      rc = DosCloseQueue (hq_server);
      ERROR ("DosCloseQueue");
      rc = DosCloseQueue (hq_client);
      ERROR ("DosCloseQueue");
      if (switch_flag && getenv ("EMACS_PID") == NULL)
	WinSwitchToProgram (WinQuerySwitchHandle (0, getpid ()));
    }
  return (0);
}
