;;; cp850.el --- set up case-conversion and syntax tables for codepage 850

;; Copyright (C) 1993-1996 Eberhard Mattes

;; Author: Eberhard Mattes <mattes@azu.informatik.uni-stuttgart.de>
;; Keywords: i18n

;; This file is part of GNU Emacs.

;; GNU Emacs is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; GNU Emacs is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; Commentary:

;; Written by Eberhard Mattes.  See case-table.el for details.

;;; Code:

(require 'case-table)

(let ((downcase (standard-case-table)))
  (set-case-syntax-pair 128 135 downcase) ; C with cedilla
  ;;                    129               ; See 154
  ;;                    130               ; See 144
  ;;                    131               ; See 182
  ;;                    132               ; See 142
  ;;                    133               ; See 183
  ;;                    134               ; See 143
  ;;                    135               ; See 128
  ;;                    136               ; See 210
  ;;                    137               ; See 211
  ;;                    138               ; See 212
  ;;                    139               ; See 216
  ;;                    140               ; See 215
  ;;                    141               ; See 222
  (set-case-syntax-pair 142 132 downcase) ; A with diaeresis or umlaut mark
  (set-case-syntax-pair 143 134 downcase) ; A with ring
  (set-case-syntax-pair 144 130 downcase) ; E with acute accent
  ;;                    145               ; See 146
  (set-case-syntax-pair 146 145 downcase) ; AE diphthong
  ;;                    147               ; See 226
  ;;                    148               ; See 153
  ;;                    149               ; See 227
  ;;                    150               ; See 234
  ;;                    151               ; See 235
  (set-case-syntax      152 "w" downcase) ; small y with diaeresis
  (set-case-syntax-pair 153 148 downcase) ; O with diaeresis or umlaut mark
  (set-case-syntax-pair 154 129 downcase) ; U with diaeresis or umlaut mark
  ;;                    155               ; See 157
  (set-case-syntax      156 "w" downcase) ; pound sign
  (set-case-syntax-pair 157 155 downcase) ; O with slash
  (set-case-syntax      158 "_" downcase) ; multiplication sign
  (set-case-syntax      159 "_" downcase) ; function f
  ;;                    160               ; See 181
  ;;                    161               ; See 214
  ;;                    162               ; See 224
  ;;                    163               ; See 233
  ;;                    164               ; See 165
  (set-case-syntax-pair 165 164 downcase) ; N with tilde
  (set-case-syntax      166 "_" downcase) ; underlined superscript a
  (set-case-syntax      167 "_" downcase) ; underlined superscript o
  (set-case-syntax      168 "." downcase) ; inverted question mark
  (set-case-syntax      169 "_" downcase) ; registered sign
  (set-case-syntax      170 "_" downcase) ; not sign
  (set-case-syntax      171 "_" downcase) ; fraction one-half
  (set-case-syntax      172 "_" downcase) ; fraction one-quarter
  (set-case-syntax      173 "." downcase) ; inverted exclamation mark
  (set-case-syntax-delims 174 175 downcase) ; angle quotation marks
  ;;                    175               ; See 174
  (set-case-syntax      176 "_" downcase) ; gray shade
  (set-case-syntax      177 "_" downcase) ; gray shade
  (set-case-syntax      178 "_" downcase) ; gray shade
  (set-case-syntax      179 "_" downcase) ; line graphics
  (set-case-syntax      180 "_" downcase) ; line graphics
  (set-case-syntax-pair 181 160 downcase) ; A with acute accent
  (set-case-syntax-pair 182 131 downcase) ; A with circumflex accent
  (set-case-syntax-pair 183 133 downcase) ; A with grave accent
  (set-case-syntax      184 "_" downcase) ; copyright sign
  (set-case-syntax      185 "_" downcase) ; line graphics
  (set-case-syntax      186 "_" downcase) ; line graphics
  (set-case-syntax      187 "_" downcase) ; line graphics
  (set-case-syntax      188 "_" downcase) ; line graphics
  (set-case-syntax      189 "w" downcase) ; cent sign
  (set-case-syntax      190 "w" downcase) ; yen sign
  (set-case-syntax      191 "_" downcase) ; line graphics
  (set-case-syntax      192 "_" downcase) ; line graphics
  (set-case-syntax      193 "_" downcase) ; line graphics
  (set-case-syntax      194 "_" downcase) ; line graphics
  (set-case-syntax      195 "_" downcase) ; line graphics
  (set-case-syntax      196 "_" downcase) ; line graphics
  (set-case-syntax      197 "_" downcase) ; line graphics
  ;;                    198               ; See 199
  (set-case-syntax-pair 199 198 downcase) ; A with tilde
  (set-case-syntax      200 "_" downcase) ; line graphics
  (set-case-syntax      201 "_" downcase) ; line graphics
  (set-case-syntax      202 "_" downcase) ; line graphics
  (set-case-syntax      203 "_" downcase) ; line graphics
  (set-case-syntax      204 "_" downcase) ; line graphics
  (set-case-syntax      205 "_" downcase) ; line graphics
  (set-case-syntax      206 "_" downcase) ; line graphics
  (set-case-syntax      207 "_" downcase) ; ???
  ;;                    208               ; See 209
  (set-case-syntax-pair 209 208 downcase) ; D with stroke, Icelandic eth
  (set-case-syntax-pair 210 136 downcase) ; E with circumflex accent
  (set-case-syntax-pair 211 137 downcase) ; E with diaeresis or umlaut mark
  (set-case-syntax-pair 212 138 downcase) ; E with grave accent
  (set-case-syntax      213 "_" downcase) ; ???
  (set-case-syntax-pair 214 161 downcase) ; I with acute accent
  (set-case-syntax-pair 215 140 downcase) ; I with circumflex accent
  (set-case-syntax-pair 216 139 downcase) ; I with diaeresis or umlaut mark
  (set-case-syntax      217 "_" downcase) ; line graphics
  (set-case-syntax      218 "_" downcase) ; line graphics
  (set-case-syntax      219 "_" downcase) ; block graphics
  (set-case-syntax      220 "_" downcase) ; block graphics
  (set-case-syntax      221 "_" downcase) ; broken vertical line
  (set-case-syntax-pair 222 141 downcase) ; I with grave accent
  (set-case-syntax      223 "_" downcase) ; block graphics
  (set-case-syntax-pair 224 162 downcase) ; O with acute accent
  (set-case-syntax      225 "w" downcase) ; small sharp s, German
  (set-case-syntax-pair 226 147 downcase) ; O with circumflex accent
  (set-case-syntax-pair 227 149 downcase) ; O with grave accent
  ;;                    228               ; See 229
  (set-case-syntax-pair 229 228 downcase) ; O with tilde
  (set-case-syntax      230 "_" downcase) ; micro sign
  ;;                    231               ; See 232
  (set-case-syntax-pair 232 231 downcase) ; thorn, Icelandic
  (set-case-syntax-pair 233 163 downcase) ; U with acute accent
  (set-case-syntax-pair 234 150 downcase) ; U with circumflex accent
  (set-case-syntax-pair 235 151 downcase) ; U with grave accent
  ;;                    236               ; See 237
  (set-case-syntax-pair 237 236 downcase) ; Y with acute accent
  (set-case-syntax      238 "w" downcase) ; macron
  (set-case-syntax      239 "w" downcase) ; acute accent
  (set-case-syntax      240 "_" downcase) ; ???
  (set-case-syntax      241 "_" downcase) ; plus or minus sign
  (set-case-syntax      242 "_" downcase) ; ???
  (set-case-syntax      243 "_" downcase) ; fraction three-quarters
  (set-case-syntax      244 "w" downcase) ; pilcrow
  (set-case-syntax      245 "w" downcase) ; section sign
  (set-case-syntax      246 "_" downcase) ; division sign
  (set-case-syntax      247 "w" downcase) ; cedilla
  (set-case-syntax      248 "_" downcase) ; degree sign
  (set-case-syntax      249 "w" downcase) ; diaeresis
  (set-case-syntax      250 "_" downcase) ; middle dot
  (set-case-syntax      251 "w" downcase) ; superscript one
  (set-case-syntax      252 "w" downcase) ; superscript three
  (set-case-syntax      253 "w" downcase) ; superscript two
  (set-case-syntax      254 "_" downcase) ; ???
  (set-case-syntax      255 " " downcase) ; space
)

(provide 'cp850)

;;; cp850.el ends here
