// srvcmd.c

#include <windows.h>
#include <tchar.h>
#include <stdio.h>

VOID DisplayInstructions(VOID);

BOOL ServiceCommands(int argc, char **argv,
      LPTSTR szServiceName, LPTSTR szDisplayName)
{
   SC_HANDLE   hSCManager, hService;
   TCHAR szPath[MAX_PATH];

   if (argc <= 1) return FALSE;

   if ((*argv[1] == '-') || (*argv[1] == '/')) {

      if (lstrcmpi(argv[1]+1, "install") == 0) {

         //------------------------------------------
         // install the service
         //-------------------------------------------

         if ((hSCManager = OpenSCManager(NULL, NULL,
               SC_MANAGER_ALL_ACCESS))) {

            GetModuleFileName(NULL, szPath, MAX_PATH);

            if ((hService = CreateService(hSCManager,
                  szServiceName, szDisplayName,
                  SERVICE_ALL_ACCESS,
                  SERVICE_WIN32_OWN_PROCESS,
                  SERVICE_DEMAND_START,
                  SERVICE_ERROR_NORMAL,
                  szPath, NULL, NULL, NULL, NULL, NULL))) {

                CloseServiceHandle(hService);
               _tprintf(TEXT("Service installed.\n"));
            } else {
               _tprintf(TEXT("Installation failed\n"));
            }

            CloseServiceHandle(hSCManager);
         } else {
            _tprintf(TEXT("Installation failed\n"));
         }
      }

      else if (lstrcmpi(argv[1]+1, "remove") == 0) {

         //-------------------------------------------
         // Remove the service
         //-------------------------------------------

         if ((hSCManager = OpenSCManager(NULL, NULL,
               SC_MANAGER_ALL_ACCESS))) {

            SERVICE_STATUS ss;

            if ((hService = OpenService(hSCManager,
                  szServiceName, SERVICE_ALL_ACCESS))) {

               // Attempt to stop the service
               if (ControlService(hService,
                     SERVICE_CONTROL_STOP, &ss)) {

                  _tprintf(TEXT("Stopping the service."));
                  Sleep(2000);

                  while(QueryServiceStatus(hService, &ss)) {
                     if (ss.dwCurrentState ==
                             SERVICE_STOP_PENDING) {
                         _tprintf(TEXT("."));
                         Sleep(2000);
                     } else {
                         break;
                     }
                  }

                  if (ss.dwCurrentState == SERVICE_STOPPED) {
                     _tprintf(TEXT("\nService stopped.\n"));
                  } else {
                     _tprintf(TEXT("\nRemove failed.\n"));
                  }
               }

               // service is stopped, remove it
               if(DeleteService(hService)) {
                  _tprintf(TEXT("Service removed.\n"));
               } else {
                  _tprintf(TEXT("Remove failed.\n"));
               }

               CloseServiceHandle(hService);

            } else {
               CloseServiceHandle(hSCManager);
               _tprintf(TEXT("Remove failed.\n"));
            }
         } else {
           _tprintf(TEXT("Remove failed.\n"));
         }

      } else {
         DisplayInstructions();
      }
   } else {
       DisplayInstructions();
   }

   return TRUE;
}


VOID DisplayInstructions(VOID)
{
   printf("This service supports the following commands:\n");
   printf("   -install  (Installs the service)\n");
   printf("   -remove   (Remove the service)\n");
}

