/*
	File: ZCapForm.h
	Author: V.Ramachandran
	Date: 07 March, 1996

	ZCaptionFormView is a form view with a caption, which can be used
	anywhere, but most useful when used with a splitter window.
*/

#ifndef __ZCaptionFormView__
#define __ZCaptionFormView__

#define DEFAULT_CAPTION_HEIGHT 15		// 15 arbitrary!

class ZCaptionFormView : public CFormView
{
public:
	ZCaptionFormView (UINT nID, int nHeight = DEFAULT_CAPTION_HEIGHT) 
				: CFormView (nID), m_nCaptionHeight (nHeight), 
				  m_bActive (FALSE)
				{ ASSERT (m_nCaptionHeight >= 0); }
	ZCaptionFormView (LPCSTR lpszTemplateName, 
				int nHeight = DEFAULT_CAPTION_HEIGHT) 
				: CFormView (lpszTemplateName), 
				  m_nCaptionHeight (nHeight), m_bActive (FALSE)
				{ ASSERT (m_nCaptionHeight >= 0); }

public:
	int GetCaptionHeight () const { return m_nCaptionHeight; }
	void SetCaptionHeight (int nHeight) 
				{ 
					ASSERT (m_nCaptionHeight >= 0);
					m_nCaptionHeight = nHeight; 
				}
	void GetCaption (CString& sCaption) { sCaption = m_sCaption; }
	void SetCaption (LPCSTR szCaption) { m_sCaption = szCaption; }

protected:
	virtual void OnActivateView (BOOL bActivate, CView *pActivateView,
					CView *pDeactivateView);
	virtual void OnActivateFrame(UINT nState, CFrameWnd* pFrameWnd);
	virtual void DoDrawCaption (CDC *pDC, const RECT& rect);

	// Generated message map functions
	//{{AFX_MSG(CInfoView)
	afx_msg LRESULT OnNcCalcSize(WPARAM wParam, LPARAM lParam);
	afx_msg void OnNcPaint();
	afx_msg UINT OnNcHitTest (CPoint point);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
	DECLARE_DYNAMIC (ZCaptionFormView)

protected:
	int m_nCaptionHeight;
	CString m_sCaption;
	BOOL m_bActive;		// TRUE if active, FALSE otherwise
};

#endif // __ZCaptionFormView__
