// simlock.c:

#include <malloc.h>
#include "simlock.h"

static LPSTR lpBuffer;
static DWORD dwBufferWidth;
static DWORD dwBitsPerPixel;
static DWORD dwSize;

BOOL
CreateBuffer(const DWORD dwWidth,
             const DWORD dwHeight,
             const DWORD dwBpp)
{
    FreeBuffer();
    dwBufferWidth = dwWidth;
    dwBitsPerPixel = dwBpp;
    dwSize = (dwWidth*dwHeight*dwBpp)/8;
    lpBuffer = malloc(dwSize);
    return lpBuffer != NULL;
}

VOID
FreeBuffer(VOID)
{
    free(lpBuffer);
}

LPVOID
LockBuffer(LPRECT lpRect)
{
    if ( lpBuffer && lpRect ) {
        DWORD dwOff = ((lpRect->top*dwBufferWidth+
                        lpRect->left)*dwBitsPerPixel)/8;
        return (LPVOID)(lpBuffer+dwOff);
    }
    return (LPVOID)lpBuffer;
}

HRESULT
UnlockBuffer(LPDIRECTDRAWSURFACE lpDDSurface)
{
    if ( lpBuffer ) {
        HRESULT hResult;
        DDSURFACEDESC ddsd;

        ZeroMemory(&ddsd, sizeof(ddsd));
        ddsd.dwSize = sizeof(ddsd);
        hResult = IDirectDrawSurface_Lock(lpDDSurface, NULL,
                                          &ddsd, DDLOCK_WAIT,
                                          NULL);
        if ( hResult != DD_OK )
            return hResult;
        memcpy(ddsd.lpSurface, lpBuffer, dwSize);
        return IDirectDrawSurface_Unlock(lpDDSurface, NULL);
    }
    return DD_OK;
}
