//
// BUG0696.CPP
//
// The following bug illuminates a problem in the
// Borland C++ 4.5 16 bit code generator.  If you select
// just the -Oc option, which performs local duplicate
// expression optimization, the routine will fail
// to correctly update buffer[ index ].  Viewing the
// generated assembly code shows that the value is
// in fact not modified at all!
//
// Build with: bcc -Oc bug0696.cpp
//
#include <iostream.h>

int buffer[ 1 ] = { -1 };
unsigned char index = 0;

int set_element( int flag )
{
    int dummy = buffer[ index ];
    buffer[ index ] = ( flag > 0 );
    return dummy;
}

int main()
{
    set_element( 1 );
    cout << "\nbuffer[ 0 ] = "
         << buffer[ 0 ]
         << "\n";
    cout << "\nNote that the value should be "
            "either 0 or 1!\n\n";
    if ( buffer[ 0 ] != 1 )
        cout << "Bug!\n";
    else
        cout << "No bug!\n";
    return 1;
}
//End of file
