// hintbar.h -- Class definitions for hint tag control bar classes.

#include <owl\buttonga.h>
#include <owl\controlb.h>

//----------------------------------------------------------------------------
//--- THintButtonGadget Definition
//----------------------------------------------------------------------------

class THintButtonGadget : public TButtonGadget
{
public:
   THintButtonGadget(TResId bmpResId, int id,
      char far *tag = 0,           // hint tag displayed if mouse lingers
      TType type = Command, bool enabled = false,
      TState state = Up, bool repeat = false);
   ~THintButtonGadget(void);

protected:
   char far *text;

   void MouseEnter(uint modKeys, TPoint& p);
   void MouseLeave(uint modKeys, TPoint& p);
};


//----------------------------------------------------------------------------
//--- THintTagBar Definition
//----------------------------------------------------------------------------

class THintTagBar : public TControlBar
{
public:
   THintTagBar(TWindow *parent = 0, TTileDirection direction = Horizontal,
      TFont *font = new TGadgetWindowFont, TColor textColor = TColor::Black,
      TColor borderColor = TColor::Black,
      TColor brushColor = TColor(255,255,115), TModule *module = 0);
   ~THintTagBar(void);
   bool IdleAction(long idleCount);

   TColor GetTextColor(void) { return colorTag; }
   TPen *GetBorderPen(void) { return penTag; }
   TBrush *GetBackgroundBrush(void) { return brushTag; }

   void SetTagDelay(int delay) { delayTag = delay; }
   void CreateTag(const char far *text);
   void DestroyTag(void);
   TPoint &GetLastPoint(void) { return lastPoint; }

protected:
   TWindow *tag;
   int delayTag;
   TPoint lastPoint;
   bool tagsActive;
   TColor colorTag;
   TPen *penTag;
   TBrush *brushTag;

   void EvLButtonDown(uint modKeys, TPoint& point);
   void EvMouseMove(uint modKeys, TPoint& point);
   void EvTimer(uint timerId);
   void ShutDownTags(void);

   DECLARE_RESPONSE_TABLE(THintTagBar);
   DECLARE_CASTABLE;
};

