;****************************************************************************
;                                                                           *
; THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY     *
; KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE       *
; IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR     *
; PURPOSE.                                                                  *
;                                                                           *
; Copyright (C) 1993-95  Microsoft Corporation.  All Rights Reserved.       *
;                                                                           *
;****************************************************************************

PAGE 58,132
;******************************************************************************
TITLE TRAPLIST 
;******************************************************************************
;
;   Title:      TRAPLIST.ASM 
;
;   Version:    3.00
;
;==============================================================================

        .386p

;******************************************************************************
;                             I N C L U D E S
;******************************************************************************

        .XLIST
        INCLUDE VMM.Inc
        INCLUDE Debug.Inc
        INCLUDE IFSMGR.Inc
        INCLUDE TRAPLIST.Inc
        .LIST

R0_OPENCREATFILE		equ	0D500h	; Open/Create a file
R0_WRITEFILE			equ	0D601h	; Write to a file, no context
R0_CLOSEFILE			equ	0D700h	; Close a file

;******************************************************************************
;                V I R T U A L   D E V I C E   D E C L A R A T I O N
;******************************************************************************

Declare_Virtual_Device TRAPLIST, 3, 0, TRAPLIST_Control, TRAPLIST_Dev_ID, VMM_INIT_ORDER+1
                                    
;******************************************************************************
;                         L O C A L   D A T A
;******************************************************************************

VxD_LOCKED_DATA_SEG
        ALIGN   4

TRAPS_SUPPORTED EQU  400

pPrevHook dd 0
numTraps dw 0
VxDNameBuf db 80 dup (0)
FileName  db "vxdtraps.lst", 0
FileHandle dd 0
FilePos    dd 0
IFDEF WIN31
V86Address
ENDIF
TrapStruc STRUCT
Port dd 0
VxDAddr dd 0
TrapStruc ENDS

TrapTable db (SIZE TrapStruc * TRAPS_SUPPORTED) dup (0)

HexTable db 30h, 31h, 32h, 33h, 34h, 35h, 36h, 37h, 38h, 39h
         db 41h, 42h, 43h, 44h, 45h, 46h
         
VxD_LOCKED_DATA_ENDS


VxD_ICODE_SEG

;******************************************************************************
;
;   TRAPLIST_Sys_Crit_Init
;
;   DESCRIPTION:
;       This routine gets some "VM BLOCK" memory.
;   
;
;==============================================================================

BeginProc TRAPLIST_Sys_Crit_Init

        GetVxDServiceOrdinal eax, Install_IO_Handler ; hook this service
        mov     esi, OFFSET32 TRAPLIST_HookProc     ; with this little front end
        VMMCall Hook_Device_Service         ; grab it
        jc      SHORT not_hooked            ; huh?
        mov     [pPrevHook], esi
  
not_hooked:
        clc
        ret

EndProc TRAPLIST_Sys_Crit_Init

BeginProc ShortToAscii

    ;AX=short integer, SI=locaion for ascii string (must be 4 bytes)
    ;uses BX
    lea ebx, HexTable
    push ax
    and ax, 000Fh
    xlat
    mov BYTE PTR [esi+3], al
    pop ax
    shr ax, 4
    push ax
    and ax, 000Fh
    xlat
    mov BYTE PTR [esi+2], al
    pop ax
    shr ax, 4
    push ax
    and ax, 000Fh
    xlat
    mov BYTE PTR [esi+1], al
    pop ax
    shr ax, 4
    push ax
    and ax, 000Fh
    xlat
    mov BYTE PTR [esi+0], al
    pop ax
    ret
          
EndProc ShortToAscii

VxD_ICODE_ENDS


;******************************************************************************


VxD_LOCKED_CODE_SEG

;******************************************************************************
;
;   TRAPLIST_Control
;
;   DESCRIPTION:
;
;       This is a call-back routine to handle the messages that are sent
;       to VxD's to control system operation. 
;
;
;==============================================================================

BeginProc TRAPLIST_Control

        Control_Dispatch Sys_Critical_Init, TRAPLIST_Sys_Crit_Init
        Control_Dispatch Init_Complete, TRAPLIST_Init_Complete
        Control_Dispatch System_Exit, TRAPLIST_System_Exit
        clc
        ret

EndProc TRAPLIST_Control

BeginProc TRAPLIST_Init_Complete

IFNDEF WIN3X
    mov esi, OFFSET32 FileName
ELSE        
    VMMcall _Allocate_Temp_V86_Data_Area, 13, 0>
    or      eax, eax        ; zero if error
    jz      error
    mov     [V86Address], eax  ; address of temporary block
ENDIF
    call    FileCreate
    mov     FileHandle, eax
    
    movzx   ecx, numTraps
    dec     ecx
    
getname:    
    push ecx
    mov esi, DWORD PTR TrapTable[ecx*8+4]
    mov ebx, OFFSET32 VxDNameBuf
    VMMCall _GetVxDName, <esi, ebx>
    pop ecx
    mov esi, OFFSET32 VxDNameBuf+10
    mov eax, DWORD PTR TrapTable[ecx*8+0]  
    call ShortToAscii
    mov BYTE PTR [esi+4], 0Dh
    mov BYTE PTR [esi+5], 0Ah
    
    mov     ebx, FileHandle
    mov     edx, FilePos
    mov     esi, OFFSET32 VxDNameBuf
    push    ecx
    mov     ecx, 16
    call    FileWrite
    add     FilePos, 16
            
    pop ecx
    dec ecx
    jnz getname
;    loop getname
    
    mov ebx, FileHandle
    call FileClose
    
    clc
    ret
    
EndProc TRAPLIST_Init_Complete

    ;ESI->name, returns handle in EAX
BeginProc FileCreate
IFNDEF WIN3X
    mov eax, R0_OPENCREATFILE
    mov bx, 2011h   ; write access, deny r/w, no int 24
    mov dx, 12h     ; always create
    xor cx, cx      ; regular file
    call FileCommon
    ret
ELSE    
    mov     [ebp.Client_DS], offset FileName 
    mov     [ebp.Client_DX], offset FileName 
    mov     [ebp.Client_CX], 0011h  ;write access, deny r/w
    mov     [ebp.Client_AX], 003Ch  ;Create File with Handle
    call FileCommon
    ret
ENDIF    
EndProc FileCreate

    ;EBX=handle
BeginProc FileClose
IFNDEF WIN3X
    mov eax, R0_CLOSEFILE
    call FileCommon
    ret
ELSE    
    mov     ah, 3Eh              ;Close File with Handle
    call FileCommon
    ret
ENDIF    
EndProc FileClose
    
    ;EBX=handle, EDX=file pos, ESI->buffer, ECX=len
BeginProc FileWrite
IFNDEF WIN3X
    mov eax, R0_WRITEFILE
    call FileCommon
    ret
ELSE    
    mov     dx, seg Buffer
    mov     ds, dx
    mov     dx, offset Buffer   ;ds:dx points to buffer containing data
    mov     ah, 40h             ;Write File or Device
    call FileCommon
    ret
ENDIF    
EndProc FileWrite

BeginProc FileCommon
IFNDEF WIN3X    
    VxDCall IFSMgr_Ring0_FileIO
    jc err
err:
    ret
ELSE
    Push_Client_State             ; Save all registers
    VMMcall Begin_Nest_V86_Exec	   ; Enter nested execution in V86-mode
    mov     [ebp.Client_AH], 30h  ; 30h = get MS-DOS version #
    mov     eax, 21h              	; Execute an Int 21h in the
    VMMcall Exec_Int              	; current VM to call MS-DOS
    mov     ax, [ebp.Client_AX]   ; Load MS-DOS version into AX register
    VMMcall End_Nest_Exec         ; end of nested exec calls
    Pop_Client_State              ; Restore all registers when done
    ret
ENDIF    
EndProc FileCommon    

BeginProc TRAPLIST_System_Exit

    ; Remove the hook
    mov      esi, offset32 TRAPLIST_HookProc
    GetVxDServiceOrdinal eax, Install_IO_Handler
    VMMCall  Unhook_Device_Service
;    jc       Error
    ret
    
EndProc TRAPLIST_System_Exit  


BeginProc TRAPLIST_HookProc, HOOK_PROC, pPrevHook, LOCKED

    pushfd                  ; Remember, hooks must preserve all regs
    pushad                  ;
    movzx ecx, numTraps
    cmp ecx, TRAPS_SUPPORTED
    ja outahere
    mov DWORD PTR TrapTable[ecx*8+0], edx
    mov DWORD PTR TrapTable[ecx*8+4], esi
    inc numTraps
outahere:    
    popad
    popfd
    jmp        [pPrevHook]  ; Chain to previous hook

EndProc TRAPLIST_HookProc

VxD_LOCKED_CODE_ENDS


VxD_CODE_SEG

VxD_CODE_ENDS

        END

