Attribute VB_Name = "MainModule"
'___Sub Main records the add-in's presence in VB.INI

Option Explicit
#If Win16 Then
    Declare Function OSWritePrivateProfileString% Lib "Kernel" Alias "WritePrivateProfileString" (ByVal AppName$, ByVal KeyName$, ByVal keydefault$, ByVal FileName$)
    Declare Function OSGetPrivateProfileString% Lib "Kernel" Alias "GetPrivateProfileString" (ByVal AppName$, ByVal KeyName$, ByVal keydefault$, ByVal ReturnString$, ByVal NumBytes As Integer, ByVal FileName$)
#Else
    Declare Function OSWritePrivateProfileString% Lib "kernel32" Alias "WritePrivateProfileStringA" (ByVal AppName$, ByVal KeyName$, ByVal keydefault$, ByVal FileName$)
    Declare Function OSGetPrivateProfileString% Lib "kernel32" Alias "GetPrivateProfileStringA" (ByVal AppName$, ByVal KeyName$, ByVal keydefault$, ByVal ReturnString$, ByVal NumBytes As Integer, ByVal FileName$)
#End If

'Mouse Cursor Settings
Global Const DEFAULT = 0
Global Const HOURGLASS = 11
Global gobjIDEAppInst As Object
Global gfnameTBFile As String
Global Const opLoad = 0
Global Const opSave = 1
Sub Main()

    Dim ReturnString As String
    Dim Section As String
    Dim ErrCode As Variant

    On Error GoTo errMain
    Screen.MousePointer = HOURGLASS

'___check for VB.INI entry
    #If Win16 Then
        Section = "Add-Ins16"
    #Else
        Section = "Add-Ins32"
   #End If

    ReturnString = String$(255, Chr$(0))
    ErrCode = OSGetPrivateProfileString(Section, "tbWiz.ConnectClass", _
        "NotFound", ReturnString, Len(ReturnString) + 1, "VB.INI")
'___register Add-In' if needed
    If Left$(ReturnString, InStr(ReturnString, Chr$(0)) - 1) = "NotFound" Then
        ErrCode = OSWritePrivateProfileString%(Section, "tbWiz.ConnectClass", "0", "VB.INI")
        MsgBox ("tbWiz has been added to your VB Ini file!")
    End If

    Screen.MousePointer = DEFAULT
    Exit Sub

errMain:
    Screen.MousePointer = DEFAULT
    MsgBox ("An error occurred while checking the VB.INI file.  " & Error$)
    End

End Sub
