Option Explicit

Function GetDosMemory (ByVal SizeCode As Integer)
  Dim Size As Long
  Dim Value As Long
  If SizeCode > Size32K Then
    SELFTEST.Print "SizeCode out of range"
    GetDosMemory = 0
    Exit Function
  End If
  Size = 2 ^ (SizeCode + 4)
  Value = GlobalDosAlloc(Size)
  If Value Then
    'return selector
    GetDosMemory = (&HFFFF& And Value)
  Else
    SELFTEST.Print "Cannot allocate Dos memory ("; Size; ")"
    GetDosMemory = 0
  End If

End Function

Function GoOnline (ByVal ThePort As Integer)
  Dim Selector As Integer
  Dim I As Integer
  Dim Code As Integer
  'allocating RX buffer
  Selector = GetDosMemory(Size1024)
  Code = SioRxBuf(ThePort, Selector, Size1024)
  If Code < 0 Then
    SELFTEST.Print "Cannot allocate RX buffer"
    Exit Function
  End If
  'save selector
  SelectorList(NbrSelectors) = Selector
  NbrSelectors = NbrSelectors + 1
  'allocate TX buffer
  Selector = GetDosMemory(Size1024)
  Code = SioTxBuf(ThePort, Selector, Size1024)
  If Code < 0 Then
    SELFTEST.Print "Cannot allocate TX buffer"
    Exit Function
  End If
  'save selector
  SelectorList(NbrSelectors) = Selector
  NbrSelectors = NbrSelectors + 1
  'reset the port
  Code = SioReset(ThePort, Baud38400)
  If Code < 0 Then
    Call SioError(SELFTEST, Code)
    Exit Function
  End If
  SELFTEST.Print "COM" + LTrim$(Str$(1 + ThePort)) + " reset"
  'set DTR & RTS
  Code = SioDTR(ThePort, Asc("S"))
  Code = SioRTS(ThePort, Asc("S"))
  'turn on hardware flow control
  Code = SioFlow(ThePort, 18)
  SELFTEST.Print "RTS/CTS flow control on"
  'turn on UART FIFO if 16550
  Code = SioFIFO(ThePort, LEVEL_8)
  If Code > 0 Then
    SELFTEST.Print "16550 Detected"
  End If
  ' set parms
  Code = SioParms(ThePort, NoParity, OneStopBit, WordLength8)
  Code = SioRxClear(ThePort)
  Code = SioTxClear(ThePort)
  'are TX interrupts enabled ?
  If SioInfo(Asc("I")) > 0 Then
    SELFTEST.Print "TX interrupts enabled"
  Else
    SELFTEST.Print "TX interrupts not enabled"
  End If
  ' we're online !
  GoOnline = 1
End Function

Sub Loopback (ByVal Port As Integer)
SELFTEST.Print "Loopback test: ";
If SioLoopBack(Port) Then
  SELFTEST.Print "FAILS";
Else
  SELFTEST.Print "SUCCESS";
End If
  SELFTEST.Print " for COM"; LTrim$(Str$(1 + Port))
End Sub

Sub ShowCaption ()
  Dim A As String
  Dim B As String
  A = "COM" + LTrim$(Str$(1 + The1stPort))
  B = "COM" + LTrim$(Str$(1 + The2ndPort))
  SELFTEST.Caption = "SelfTest: " + A + " ===> " + B
End Sub

Sub ShowConfig ()
  Dim Version As Integer
  Version = SioInfo(Asc("V"))
  SELFTEST.Print "*** SELFTEST 1.0"
  SELFTEST.Print "*** PCL4VBW Version ";
  SELFTEST.Print LTrim$(Str$(Version \ 16)) + ".";
  SELFTEST.Print LTrim$(Str$(Version Mod 16))
End Sub

Sub ShutDown ()
  Dim I As Integer
  Dim Code As Integer
  Code = SioDone(The1stPort)
  Code = SioDone(The2ndPort)
  If NbrSelectors > 0 Then
  '''SELFTEST.Print "Freeing "; NbrSelectors; " selectors"
   For I = 0 To NbrSelectors - 1
     '''Code = GlobalPageUnlock(SelectorList(I))
     Code = GlobalDosFree(SelectorList(I))
   Next I
   NbrSelectors = 0
  End If
End Sub

