{}
{          Intuitive Vision Software                          }
{          P.O. Box 257773                                    }
{           Chicago, IL 60625-7773                             }
{  ۱        (312) 583-2480                                     }
{                                                              }
{                                                               }
{             "Today's Leader in Sensible Software Solutions"    }
{                                                                   }
{ S O F T W A R E (tm)                                                       }
{                                                                            }
{ Nexus (tm) - Next Epoch matriX User System (tm)                            }
{                                                                            }
{ Data Structures (Turbo Pascal (tm) Format)                                 }   
{                                                                            }
{ All Material Contained Herein Is Copyright 1996 Intuitive Vision Software. }
{ All Rights Reserved.                                                       }
{                                                                            }
{ Nexus, Next Epoch matriX User System, and the IV Software Logo are         }
{ Trademarks of Intuitive Vision Software.  Turbo Pascal is a Trademark of   }
{ Borland International.                                                     }
{                                                                            }
{}

{ Pre-release Structures for Nexus 1.00 -------------------------------------}
{                                                                            }
{ Note to developers: These are the pre-release structures.  All structures  }
{ have not been included in this version due to the fact that there will be  }
{ major changes on those files.  You will most notably note the absence of   }
{ the File Base (.NFB) structures.  These will be getting a very large       }
{ reworking before the final release, so we have chosen not to include the   }
{ current structures.                                                        }
{                                                                            }
{ Intuitive Vision Software does not guarantee that these structures will    }
{ remain unchanged for the final (1.00) release.  We will do what we can to  }
{ keep to these structures, as we do not wish to cause anyone undue work.    }
{                                                                            }
{ Thank you for considering developing for Nexus!                            }
{                                                                            }
{                                              Intuitive Vision Software     }
{----------------------------------------------------------------------------}
{----------------------------------------------------------------------------}
{ NOTES TO TURBO PASCAL DEVELOPERS:                                          }
{                                                                            }
{     Intuitive Vision Software provides for no reliability of these data    }
{ structures.  Intuitive Vision Software has provided these structures to    }
{ allow Turbo Pascal Developers to develop Nexus compatible applications.    }
{ These structures are provided AS IS.  Intuitive Vision Software provides   }
{ no warranty, expressed or implied, to those who use these structures.  At  }
{ no time, for any reason, may Intuitive Vision Software, its employees,     }
{ contractees, or other affiliates be held responsible for any loss due to   }
{ the use of these structures, whether direct or indirect.                   }
{                                                                            }
{                                                                            }
{   IMPORTANT - IMPORTANT - IMPORTANT - IMPORTANT - IMPORTANT - IMPORTANT    }
{                                                                            }
{  DO NOT MODIFY any variables that are labeled as RESERVED.  These are      }
{  reserved for future enhancements and modifying them may cause current or  }
{  future versions of Nexus to run improperly or even crash.                 }
{----------------------------------------------------------------------------}

{----------------------------------------------------------------------------}
{ Version Number Information:                                                }
{                                                                            }
{ <Version>    String formatted typed CONSTANT representing the string       }
{              display of the version number                                 }
{ <MajVersion> Major/Minor Version numbers - byte format. This is the current}
{ <MinVersion> version that these structures support.  This can be used to   }
{              check the MATRIX.DAT for the version number that it is being  }
{              used with, for compatibility sake.                            }
{----------------------------------------------------------------------------}

CONST

Version         : STRING[4]='0.99';
MajVersion      : BYTE=0;
MinVersion      : BYTE=99;


{----------------------------------------------------------------------------}
{ CONSTANT Declarations:                                                     }
{                                                                            }
{ Various CONSTANTS that are used internally in Nexus.  They are included    }
{ here for reference.  They give you an idea of what type of limitations     }
{ that Nexus places on certain data files, so that you can impose the same   }
{ limitations in your programs.  Please follow these restrictions closely,   }
{ as if you add more than the maximum allowed, those above maximum will not  }
{ be used by Nexus.                                                          }
{----------------------------------------------------------------------------}

CONST

MaxMsgBases     = 32767;          { 0 to 32767                               }
MaxFileBases    = 32767;          { 0 to 32767                               }
MaxMenuCommands = 50;             { 1 to 50                                  }
MaxGlobalCmds   = 20;             { 1 to 20                                  }


{----------------------------------------------------------------------------}
{ TYPE Declarations:                                                         }
{                                                                            }
{ Various TYPES that are used throughout Nexus for internal workings and for }
{ data structures in data files.  If a structure is the specific foundation  }
{ of a file, the filename and information will be listed before the structure}
{ information, so as to help you with which structures go with which files.  }
{----------------------------------------------------------------------------}

TYPE

ACString        = STRING[20];     { Access Control String                    }
JoinedConfs     = 'A'..'Z';       { Conference Set                           }


{----------------------------------------------------------------------------}
{ Filename: USERS.IDX                                                        }
{ Location: DATA Directory                                                   }
{ Format  : 1 <UserIDX> record per entry, 0 record is blank buffer           }
{                                                                            }
{ Notes   : Used to have a quick index to to the USERS.DAT file.  Records    }
{           must correspond with the appropriate record in the USERS.DAT     }
{           file.  i.e. Record 1 of USERS.IDX should match Record 1 of       }
{           USERS.DAT.  The <number> variable is a safeguard for a case      }
{           where they do not match.                                         }
{----------------------------------------------------------------------------}

UserIDX=
RECORD
    Alias    : STRING[36];        { Alias                                    }
    RealName : STRING[36];        { Real Name                                }
    Number   : INTEGER;           { Record Number in USERS.DAT               }
    UserID   : LONGINT;           { UserID number matching the UserREC.UserID}
    RESERVED : ARRAY[1..5] of
                            BYTE; { RESERVED - DO NOT MODIFY                 }
END;

{----------------------------------------------------------------------------}
{ Filename: USERID.IDX                                                       }
{ Location: DATA Directory                                                   }
{ Format  : 1 <UserIDREC> record per entry                                   }
{                                                                            }
{ Notes   : Used to have a quick index to to the UserIDs.  There will be one }
{           record for each UserID.  The <Number> variable will be set to -1 }
{           if the user has been deleted.                                    }
{----------------------------------------------------------------------------}

UserIDREC=
RECORD
    UserID      : LONGINT;      { UserID Number matching UserREC.UserID      }
    Number      : INTEGER;      { Record number in USERS.DAT                 }
END;


{----------------------------------------------------------------------------}
{ Filename: USERS.DAT                                                        }
{ Location: DATA Directory                                                   }
{ Format  : 1 <userrec> record per entry, 0 record is blank buffer           }
{                                                                            }
{ Notes   : Used to store user information.  One record per user. Record     }
{           #0 is a blank record that is used to buffer the file out so      }
{           that the user numbers start at 1.                                }
{----------------------------------------------------------------------------}

{----------------------------------------------------------------------------}
{ Uflags Set:                                                                }
{               Items have a starting designation character to tell you what }
{               type of flag they are:                                       }
{                                                                            }
{               r  =  Restriction                                            }
{               c  =  Control                                                }
{               s  =  Special Priveledge                                     }
{                                                                            }
{----------------------------------------------------------------------------}

ARFlagSet       = '@'..'Z';       { AR flags                                 }

Uflags =
   (rLogon,                       { Restrict: One Call Per Day               }
    rChat,                        { Restrict: Cannot Page SysOp              }
    RESERVED1,                    { RESERVED - DO NOT MODIFY                 }
    RESERVED2,                    { RESERVED - DO NOT MODIFY                 }
    RESERVED3,                    { RESERVED - DO NOT MODIFY                 }
    RESERVED4,                    { RESERVED - DO NOT MODIFY                 }
    rPost,                        { Restrict: Cannot Post Messages           }
    rPrivate,                     { Restrict: Cannot Post Private Messages   }
    RESERVED5,                    { RESERVED - DO NOT MODIFY                 }
    rDelMsg,                      { Restrict: Force Private Message Deletion }
    RESERVED6,                    { RESERVED - DO NOT MODIFY                 }
    cQuickKey,                    { Control : QuickKey Input Mode            }
    RESERVED7,                    { RESERVED - DO NOT MODIFY                 }
    cPause,                       { Control : Pause When Screen Full         }
    cNovice,                      { Control : Novice Help Level for Menus    }
    cAnsi,                        { Control : ANSI when detected             }
    cColor,                       { Control : Display Color                  }
    cAlert,                       { Control : Alert SysOp When User Logs On  }
    cUseTaglines,                 { Control : Use Taglines for Messages      }
    cRip,                         { Control : RIP when detected              }
    sNoULDLRatio,                 { Special : No UL/DL Ratio enforced        }
    sNoPostRatio,                 { Special : No Post/Call Ratio enforced    }
    sNoFilePts,                   { Special : No File Point Checking enforced}
    sNoDeletion);                 { Special : May not be Deleted             }


UserREC=
RECORD
    Alias        : STRING[36];    { User's Alias                             }
    RealName     : STRING[36];    { User's Real Name                         }
    UserID       : LONGINT;
    RESERVED1    : ARRAY[1..33]
                        of BYTE;  { RESERVED - DO NOT MODIFY                 }
    AccessKey    : STRING[20];    { Access Key                               }
    VoicePhone   : STRING[20];    { Voice Phone Number                       }
    DataPhone    : STRING[20];    { Data Phone Number                        }
    OptPhone1    : STRING[20];    { Optional Phone #1                        }
    OptPhone2    : STRING[20];    { Optional Phone #2                        }
    Street1      : STRING[30];    { Street Address Line #1                   }
    Street2      : STRING[30];    { Street Address Line #2                   }
    CityState    : STRING[40];    { City, State (Province)                   }
    ZipCode      : STRING[20];    { Zipcode                                  }
    Birthdate    : STRING[8];     { Birthdate                                }
    Gender       : CHAR;          { Gender                                   }
    Option1      : STRING[30];    { Optional Field #1                        }
    Option2      : STRING[40];    { Optional Field #2                        }
    Option3      : STRING[40];    { Optional Field #3                        }
    SysopNote    : STRING[40];    { SysOp note                               }
    CallingFrom  : STRING[40];    { Calling From String                      }
    Title        : STRING[20];    { Title (FUTURE USE)                       }
    Description  : ARRAY[1..4]
                   of STRING[40]; { User Self Description (FUTURE USE)       }
    ClearEntry   : ARRAY[1..20]   
                   of BOOLEAN;    { Clear Entries Flags                      }

    FileScanDate : STRING[8];     { Last Date that a New File Scan was done  }
    RESERVED2    : ARRAY[1..39]
                     of BYTE;     { RESERVED - DO NOT MODIFY                 }
    phEntryType  : BYTE;          { Phone Number Entry Type:                 }
                                  { 1: US/Canada  2: International           }
    zipEntryType : BYTE;          { Zipcode Entry Type:                      }
                                  { 1: US         2: Canada/International    }
    FirstOnDate  : STRING[8];     { First Called BBS Date (xx/xx/xx)         }
    LastOnDate   : STRING[8];     { Last Called BBS Date  (xx/xx/xx)         }
    LastFileScan : LONGINT;       { Last File Newscan Date/Time              }
    SecurityLevel: BYTE;          { Security Level (1-100)                   }
    UserFlags    : SET of Uflags; { User Flags                               }
    UserARFlags  : SET of ARflagSet;{ User AR Flags                            }
    LockedOut    : BOOLEAN;       { Is User Locked Out?                      } 
    Deleted      : BOOLEAN;       { Is User Deleted?                         }
    LockedFile   : STRING[8];     { Lockout File to Display to User          }


    RESERVED3    : ARRAY[1..50]
                     of BYTE;     { RESERVED - DO NOT MODIFY                 }
    TotalTime    : LONGINT;       { Total Minutes spent on this BBS          }
    TotalCalls   : INTEGER;       { Number of Calls to this BBS              }
    TimeLeftToday: INTEGER;       { Number of Minutes Left Today             }
    CallsToday   : BYTE;          { Number of Calls Today                    }
    IllegalLogons: BYTE;          { Number of Illegal Logon Attempts         }
    Credits      : LONGINT;       { Credits                                  }
    TimeBank     : INTEGER;       { Number of Minutes in Time Bank           }
    TimeBankToday: INTEGER;       { Time Added to Time Bank Today            }
    TrapActivity : BOOLEAN;       { Trapping User's Activity?                }
    TrapSeperate : BOOLEAN;       { If above=TRUE, Use seperate TRAP file?   }
    AutoChatLog  : BOOLEAN;       { Automatically Log User's Chat Activity?  }
    ChatLogSep   : BOOLEAN;       { If above=TRUE, Use seperate CHAT file?   }
    LogSep       : BOOLEAN;       { Log this user seperately?                }
    ScreenLength : BYTE;          { Number of Lines on Screen                }
    ColorScheme  : INTEGER;       { Color Scheme Number (SCHEME.DAT)         }
    UserStartMenu: INTEGER;       { Menu Number to Start User On             }
    TimeBankWith : INTEGER;       { time withdrawn from timebank TODAY       }

    RESERVED4    : ARRAY[1..48]
                     of BYTE;     { RESERVED - DO NOT MODIFY                 }
    LastFConf    : BYTE;          { Last File Conference In                  }
    LastFBase    : INTEGER;       { Last File Base In                        }
    UploadKB     : LONGINT;       { KB Uploaded                              }
    DownloadKB   : LONGINT;       { KB Downloaded                            }
    UploadFiles  : INTEGER;       { Number of Files Uploaded                 }
    DownloadFiles: INTEGER;       { Number of Files Downloaded               }
    FilePoints   : INTEGER;       { File Points                              }
    DefProtocol  : CHAR;          { Default Protocol, @=Ask Each Transfer    }
                                  { File Bases that User is Sysop of         }
    FBaseSysop   : ARRAY[1..20] of INTEGER;

    RESERVED5    : ARRAY[1..50]
                     of BYTE;     { RESERVED - DO NOT MODIFY                 }
    LastMConf    : BYTE;          { Last Message Conference In               }
    LastMBase    : INTEGER;       { Last Message Base In                     }
    NumPosts     : INTEGER;       { Number of Posts                          }
    NumFeedback  : INTEGER;       { Number of Feedback Sent                  }
    MessageRuler : BYTE;          { Message Ruler 0 = OFF  1 = ON            }
    MessageEditor: SHORTINT;      {-1 : Nexus Full-Screen Editor             }
                                  { 0 : Nexus Line Editor                    }
                                  { 1^: External Editor                      }
                                  { Message Bases that user is Sysop of      }
    MBaseSysop   : ARRAY[1..20] of INTEGER;

    Subscription : BYTE;          { Current Subscription Level               }
    SubDate      : LONGINT;       { Subscription Level Start Date/Time in    }
                                  { UNIX Date/Time Stamp format              }
    Language     : BYTE;          { Language this user has selected          }
    RESERVED6    : ARRAY[1..99]
                       of BYTE;   { RESERVED - DO NOT MODIFY                 }
END;

{----------------------------------------------------------------------------}
{ Filename: USERxxxx.DAT    (xxxx = Node number in format 0001, 0010, etc.)  }
{ Location: DATA Directory                                                   }
{ Format  : 1 <OnlineREC> record                                             }
{                                                                            }
{ Notes   : Used to provide information to external programs about a         }
{           particular node's current status.  This information is useful    }
{           for a door program that is written specifically to work with     }
{           Nexus, such as a callback verifier or multiline chat program.    }
{           Much of the information found in the USERS.DAT file may not be   }
{           necessary, so the information in the USERxxxx.DAT file may be    }
{           used.  If more information is needed, the <Number> variable      }
{           points to the record number in the USERS.DAT file where this     }
{           user is located.                                                 }
{                                                                            }
{           This file is automatically created when a user logs on to Nexus  }
{           and is deleted when the user logs off.  Nexus creates a file for }
{           the node if it is at the Waiting for Caller screen logged in and }
{           places a 2 in the appropriate index value in the ONLINE.IDX so   }
{           that other nodes of Nexus will see that this node is waiting for }
{           a caller.                                                        }
{----------------------------------------------------------------------------}

OnlineREC=
RECORD
    Name         : STRING[36];    { User Logon Name                          }
    real         : STRING[36];    { User Real Name                           }
    UserID       : LONGINT;       { UserID                                   }
    TimeLeft     : INTEGER;
    RESERVED     : ARRAY[1..31] of
                        BYTE;     { RESERVED - DO NOT MODIFY                 }
    business     : STRING[40];    { User Business (calling from)             }
    number       : INTEGER;       { User Number                              }
    activity     : STRING[20];    { Current Activity                         }
    available    : BOOLEAN;       { User Available?                          }
    paged        : BOOLEAN;       { User Paged?                              }
    pagedby      : INTEGER;       { Paged by Node Number                     }
    pagedstr     : STRING[72];    { Paged Reason                             }
    Baud         : WORD;          { 0 = Local  Other = Connect Rate / 10     }
    LockBaud     : WORD;          { 0 = Port not locked                      }
                                  { Locked Baud Rate / 10                    }
    Comport      : WORD;          { 0=Local                                  }
    Comtype      : BYTE;          { 0=Fossil  1=Interrupt (internal)         }
                                  { 2=Digiboard                              }
    emulation    : WORD;          { 0=TTY   1=ANSI   2=RIPscrip              }
END;

{----------------------------------------------------------------------------}
{ Filename: TAGLINES.DAT                                                     }
{ Location: DATA Directory                                                   }
{ Format  : 1 <TagREC> record per entry                                      }
{                                                                            }
{ Notes   : Used to provide users the ability to add taglines to their       }
{           messages.  A global tagline file is able to be added to by the   }
{           users and then they may select any of the taglines to add to     }
{           their message.                                                   }
{----------------------------------------------------------------------------}
  
TagREC=
RECORD
    Tag          : STRING[75];    { Tagline }
END;

{----------------------------------------------------------------------------}
{ Filename: NETWORK.DAT                                                      }
{ Location: DATA Directory                                                   }
{ Format  : 1 <NetworkREC> record                                            }
{                                                                            }
{ Notes   : Used to store default values and information regarding message   }
{           networks.  There is one record of <NetworkREC> in the            }
{           NETWORK.DAT file.                                                }
{----------------------------------------------------------------------------}

NetworkREC=
RECORD
    Address      : ARRAY[1..30] of               { Address Information       }
        RECORD
                Zone  : WORD;     { Zone number                              }
                Net   : WORD;     { Net number                               }
                Node  : WORD;     { Node number                              }
                Point : WORD;     { Point number                             }
        END;
    Origins      : ARRAY[1..20] of STRING[50];   { Origin Lines              }
    RES2         : ARRAY[1..807] of BYTE;        { RESERVED - DO NOT MODIFY  }
    NodelistType : BYTE;          { Nodelist Type Found in NODELIST PATH     }
                                  {     0: No Nodelist                       }
                                  {     1: Version 7                         }
                                  {     2: Frontdoor                         }
                                  { other: RESERVED                          }
                                  { currently UNUSED                         }
    Text_color   : BYTE;          { default color of standard text           }
    Quote_color  : BYTE;          { default color of quoted text             }
    Tag_color    : BYTE;          { default color of tagline                 }
    Oldtear_color: BYTE;          { default color old tearline ( ~~~ or ___ )}
    Tear_color   : BYTE;          { default color of tear line               }
    Origin_color : BYTE;          { default color of origin line             }
    SKludge      : BOOLEAN;       { default strip kludge lines?              }
    SSeenby      : BOOLEAN;       { default strip SEEN-BY lines?             }
    SOrigin      : BOOLEAN;       { default strip origin line?               }
    nodelistpath : STRING[79];    { Path to Nodelist Files                   }
    isprivate    : BOOLEAN;       { Default Netmail Private?                 }
    iscrash      : BOOLEAN;       { Default Netmail Crash?                   }
    isfattach    : BOOLEAN;       { Default Netmail File Attach?             }
    iskillsent   : BOOLEAN;       { Default Netmail Kill/Sent?               }
    ishold       : BOOLEAN;       { Default Netmail Hold?                    }
    isfilereq    : BOOLEAN;       { Default Netmail File Request?            }
    isreqrct     : BOOLEAN;       { Default Netmail ReturnReceiptRequest?    }
    isdirect     : BOOLEAN;       { Default Netmail Direct?                  }
    res          : ARRAY[1..12] of BYTE;    { RESERVED - DO NOT MODIFY       }
END;

{----------------------------------------------------------------------------}
{ Filename: INTERNET.DAT                                                     }
{ Location: DATA Directory                                                   }
{ Format  : 1 <InternetREC> record                                           }
{                                                                            }
{ Notes   : Used to store default values and information regarding Internet  }
{           gateways.  There is one record of <InternetREC> in the           }
{           INTERNET.DAT file.                                               }
{----------------------------------------------------------------------------}

InternetREC=
RECORD
    Gateways:ARRAY[1..30] of
      RECORD
        Name:STRING[40];          { Name of Gateway (for informational use)  }
        ToName:STRING[36];        { Name messages should be addressed to,    }
                                  { many times 'UUCP'                        }
        ToAddress:RECORD          { Address that messages should be addressed}
                                  { to                                       }
                Zone  : WORD;         { Zone number                          }
                Net   : WORD;         { Net number                           }
                Node  : WORD;         { Node number                          }
                Point : WORD;         { Point number                         }
        END;
        FromAddress:BYTE;         { Address (from NETWORK.DAT) that messages }
                                  { should come from                         }
        RESERVED1:ARRAY[1..30] of
                        BYTE;     { RESERVED - DO NOT MODIFY                 }
      END;
    RESERVED2:ARRAY[1..50] of
                        BYTE;     { RESERVED - DO NOT MODIFY                 }
END;

{----------------------------------------------------------------------------}
{ Filename: CALLINFO.DAT, CALLINFO.xxx                                       }
{ Location: DATA Directory                                                   }
{ Format  : 1 <CallInfoREC> record for each date                             }
{                                                                            }
{ Notes   : Used to store information regarding statistics per node (in the  }
{           CALLINFO.xxx files) and for the whole system (CALLINFO.DAT).     }
{           These statistics are on a per date basis.  Dates may or may not  }
{           be consecutive.  If a date does not exist, there was no activity.}
{----------------------------------------------------------------------------}

CallInfoREC=
RECORD
    Date:STRING[8];                     { Date of entry                      }
    UserBaud:ARRAY[0..40] of INTEGER;   { Number of calls at this particular }
                                        { baud rate.  Baud rates are:        }
                                        {                                    }
                                        {  0 - 300     1 - 1200    2 - 2400  }
                                        {  3 - 4800    4 - 7200    5 - 9600  }
                                        {  6 - 12000   7 - 14400   8 - 16800 }
                                        {  9 - 19200  10 - 21600  11 - 24000 }
                                        { 12 - 26400  13 - 28800  14 - 31200 }
                                        { 15 - 33600  16 - 38400  17 - n/a   }
                                        { 18 - n/a    19 - n/a    20 - n/a   }
                                        { 21 - n/a    22 - 57600  23 - n/a   }
                                        { 24 - n/a    25 - n/a    26 - n/a   }
                                        { 27 - n/a    28 - 76800  29 - n/a   }
                                        { 30 - n/a    31 - n/a    32 - n/a   }
                                        { 33 - n/a    34 - 115200 35 - n/a   }
                                        { 36 - n/a    37 - n/a    38 - n/a   }
                                        { 39 - n/a    40 - All others        }
    Active,                             { Percent Activity                   }
    Calls,                              { Number of Calls                    }
    Newusers,                           { Number of New Users                }
    Pubpost,                            { Public Posts                       }
    Comments,                           { Comments to SysOp                  }
    CriticalErrors:INTEGER;             { Critical Errors                    }
    Uploads,                            { Files Uploaded                     }
    Downloads:INTEGER;                  { Files Downloaded                   }
    UlKB,                               { KB Uploaded                        }
    DlKB:LONGINT;                       { KB Downloaded                      }
    RESERVED:ARRAY[1..20] of BYTE;      { RESERVED - DO NOT MODIFY           }
END;

{----------------------------------------------------------------------------}
{ Filename: TOTALS.DAT, TOTALS.xxx                                           }
{ Location: DATA Directory                                                   }
{ Format  : 1 <TotalsREC> record in each file                                }
{                                                                            }
{ Notes   : Used to store information regarding statistics per node (in the  }
{           TOTALS.xxx files) and for the whole system (TOTALS.DAT).  This   }
{           information is information since the <date> field.               }
{----------------------------------------------------------------------------}

TotalsREC=                          
RECORD
    Date:STRING[8];                     { Date this information is since     }
    Userbaud:ARRAY[0..40] of LONGINT;   { Number of calls at this particular }
                                        { baud rate.  Baud rates are:        }
                                        {                                    }
                                        {  0 - 300     1 - 1200    2 - 2400  }
                                        {  3 - 4800    4 - 7200    5 - 9600  }
                                        {  6 - 12000   7 - 14400   8 - 16800 }
                                        {  9 - 19200  10 - 21600  11 - 24000 }
                                        { 12 - 26400  13 - 28800  14 - 31200 }
                                        { 15 - 33600  16 - 38400  17 - n/a   }
                                        { 18 - n/a    19 - n/a    20 - n/a   }
                                        { 21 - n/a    22 - 57600  23 - n/a   }
                                        { 24 - n/a    25 - n/a    26 - n/a   }
                                        { 27 - n/a    28 - 76800  29 - n/a   }
                                        { 30 - n/a    31 - n/a    32 - n/a   }
                                        { 33 - n/a    34 - 115200 35 - n/a   }
                                        { 36 - n/a    37 - n/a    38 - n/a   }
                                        { 39 - n/a    40 - All others        }
    Active,                             { Percent Activity                   }
    Calls,                              { Number of Calls                    }
    Newusers,                           { Number of New Users                }
    Pubpost,                            { Public Posts                       }
    Comments,                           { Comments to SysOp                  }
    CriticalErrors:LONGINT;             { Critical Errors                    }
    Uploads,                            { Files Uploaded                     }
    Downloads:LONGINT;                  { Files Downloaded                   }
    RESERVED:ARRAY[1..100] of BYTE;     { RESERVED - DO NOT MODIFY           }
END;

{----------------------------------------------------------------------------}
{ Filename: ARCHIVER.DAT                                                     }
{ Location: DATA Directory                                                   }
{ Format  : 1 <ArchiverREC> record in each file                              }
{                                                                            }
{ Notes   : Used to store information regarding statistics per node (in the  }
{           TOTALS.xxx files) and for the whole system (TOTALS.DAT).  This   }
{           information is information since the <date> field.               }
{----------------------------------------------------------------------------}

ArchiverREC=
RECORD
    Active    : BOOLEAN;          { Is archiver active to be used?           }
                                  { Note if set to view with internal methods}
                                  { Nexus will still allow viewing even if   }
                                  { archiver is disabled.                    }
    Name      : STRING[40];       { Name of archiver                         }
    ListFiles : STRING[80];       { List archive commandline (blank=internal)}
    Compress  : STRING[80];       { Compress archive commandline             }
    Decompress: STRING[80];       { Decompress archive commandline           }
    TestFiles : STRING[80];       { Test archive commandline                 }
    Comment   : STRING[80];       { Comment archive commandline              }
    ErrorLevel: INTEGER;          { Errorlevel for success on external       }
    Extension : STRING[3];        { File extention (used only for records 12+}
    RESERVED  : ARRAY[1..100] of BYTE;  { RESERVED -- DO NOT MODIFY          }
END;

{----------------------------------------------------------------------------}
{ Filename: NODExxxx.DAT                                                     }
{ Location: DATA Directory                                                   }
{ Format  : 1 <NodeREC> Record                                               }
{                                                                            }
{ Notes   : Used to store modem and node specific information for each node. }
{           There will be one file for each node that has been configured    }
{           for use in Nexus.                                                }
{----------------------------------------------------------------------------}

NodeREC=
RECORD
    PortNumber   : BYTE;          { Com Port Number/Digiboard Port Number    }
                                  { 1-8  : Fossil/Interrupt                  }
                                  { 1-30 : Digiboard                         }
    MaximumBaud  : LONGINT;       { Maximum/Locked Baud Rate                 }
    LockPort     : BOOLEAN;       { whether to force baud rate               }
    Hangup       : STRING[40];    { hangup string                            }
    drvType      : BYTE;          { 0 : Local Only                           }
                                  { 1 : Fossil                               }
                                  { 2 : Digiboard                            }
                                  { 3 : Interrupt Serial                     }
    chatBegin    : ARRAY[1..7] of 
                        INTEGER;  { Start Time when SysOp is available for   }
                                  { Chat with Users   Start/End=0 Always     }
    chatEnd      : ARRAY[1..7] of
                        INTEGER;  { Chat Time End                            }
    dlBegin      : ARRAY[1..7] of
                        INTEGER;  { Start Time when Users may download files }
                                  { Start/End = 0 for always                 }
    dlEnd        : ARRAY[1..7] of
                        INTEGER;  { Download Time End                        }
    MinBaudRate  : LONGINT;       { Minimum Baud Rate allowed on System      }
    _minStart    : ARRAY[1..7] of
                        INTEGER;  { Start Time when Callers below the Min.   }
                                  { baud rate may log on to the system       }
                                  { Start/End=0 Never allowed on             }
    _minEnd      : ARRAY[1..7] of
                        INTEGER;  { End Below Min Time                       }
    _mindlStart  : ARRAY[1..7] of 
                        INTEGER;  { Start Time when Callers below the Min.   }
                                  { Baud rate may download files.            }
                                  { Start/End = 0  Never Allow               }
    _mindlEnd    : ARRAY[1..7] of
                        INTEGER;  { Below Min. DL Time End                   }
    NoNewUsers   : BOOLEAN;       { This node does not accept New Users      }
    swapProtocol : BYTE;
    swapArchiver : BYTE;
    swapDoor     : BYTE;
    swapEditor   : BYTE;
    swapChat     : BYTE;
    swapLShell   : BYTE;
END;

{----------------------------------------------------------------------------}
{ Filename: SYSTEM.DAT                                                       }
{ Location: DATA Directory                                                   }
{ Format  : 1 <SystemREC> record                                             }
{                                                                            }
{ Notes   : Used to store information neccessary for the BBS to operate.     }
{           This information is sensitive, and should be modified with care. }
{           Modifying the information this file improperly could render a    }
{           system totally useless, and could seriously damage data files.   }
{----------------------------------------------------------------------------}

SystemREC=                            { SYSTEM.DAT }
RECORD
    callernum    : LONGINT;       { System Caller Number                     }
    numusers     : LONGINT;       { Number of Callers to this node           }
    highnode     : INTEGER;       { Highest Node Number Ever Executed        }
    lastdate     : STRING[8];     { Last Date That Nexus Was Run             }
    LastMBaseID:LONGINT;          { Last MBaseID that was used               }
    LastFBaseID:LONGINT;          { Last FBaseID that was used               }
    LastDoorID:LONGINT;           { Last DoorID that was used                }
    LastEditorID:LONGINT;         { Last EditorID that was used              }
    LastUserID:LONGINT;           { Last UserID that was used                }
    NKeywords:LONGINT;            { FUTURE USE                               }
    NDescLines:LONGINT;           { FUTURE USE                               }
    RESERVED     : ARRAY[1..47] of BYTE;        { RESERVED - DO NOT MODIFY   }
END;

{----------------------------------------------------------------------------}
{ Filename: SECURITY.DAT                                                     }
{ Location: DATA Directory                                                   }
{ Format  : Record #0 is holding record                                      }
{           100 <SecurityREC> records                                        }
{                                                                            }
{ Notes   : Used to store security level configuration for each security     }
{           level.  The security level is not used if the <Active> variable  }
{           is set to FALSE.                                                 }
{----------------------------------------------------------------------------}


SecurityREC=
RECORD
    Active       : BOOLEAN;       { Is Security Level begin used?            }
    Description  : STRING[20];    { Description of Security Level            }
    CallsPerDay  : BYTE;          { Number of Calls Per Day for SL           }
    TimePerCall  : INTEGER;       { Time Per Call (minutes)  0=Use Time/Day  }
    TimePerDay   : INTEGER;       { Time Per Day (minutes)                   }
    PostPerCall  : INTEGER;       { Posts Per Call Required                  }
    DLRatioFiles : INTEGER;       { Number of Files DLed before 1 upload req }
    DLRatioKb    : INTEGER;       { Number of Kb DLed before 1 Kb required   }
    MaxInTB      : INTEGER;       { Maximum amount in Time Bank              }
    WithTBDay    : INTEGER;       { Withdrawal Maximum per Day               }
    WithTBCall   : INTEGER;       { Withdrawal Maximum per Call              }
    AddTBDay     : INTEGER;       { Maximum minutes per Day can be Added     }
    AddTBCall    : INTEGER;       { Maximum minutes per Call can be Added    }
    RESERVED1    : ARRAY[1..10] of BYTE;      { RESERVED - DO NOT MODIFY     }
    MaxDLPerCall : ARRAY[1..12] of INTEGER;   { Max Files DLed based on baud }
                                  {           1 =300    2 =1200   3 =2400    }
                                  { 4 =4800   5 =7200   6 =9600   7 =12000   }
                                  { 8 =14400  9 =19200  10=38400  11=57600   }
                                  { 12=115200                                }
    RESERVED2    : ARRAY[1..8] of INTEGER;    { RESERVED - DO NOT MODIFY     }
    MaxKbPerCall : ARRAY[1..12] of LONGINT;   { Max Kb DLed based on baud    }
                                  {           1 =300    2 =1200   3 =2400    }
                                  { 4 =4800   5 =7200   6 =9600   7 =12000   }
                                  { 8 =14400  9 =19200  10=38400  11=57600   }
                                  { 12=115200                                }
    RESERVED3    : ARRAY[1..8] of INTEGER;    { RESERVED - DO NOT MODIFY     }
end;

{----------------------------------------------------------------------------}
{ Filename: MATRIX.DAT                                                       }
{ Location: Main NEXUS Directory                                             }
{ Format  : 1 <MatrixREC> Record                                             }
{                                                                            }
{ Notes   : This is the main Nexus Data File.  It contains various info      }
{           regarding the general setup of the system.  This file will       }
{           usually be read before any other data files in order to obtain   }
{           the path information.  You may obtain the location of this file  }
{           (i.e. the main Nexus Directory) by getting the NEXUS environment }
{           variable ( GETENV('NEXUS'); ).  More information on the Nexus    }
{           environment variable will be found in ENVIRON.DOC in the Nexus   }
{           Developer's Kit.                                                 }
{                                                                            }
{----------------------------------------------------------------------------}

MatrixREC=
RECORD
    MajorVersion : BYTE;           { major version number                    }
    MinorVersion : BYTE;           { major version number                    }
    DataPATH     : STRING[79];     { DATA path                               }
    GraphicsPATH : STRING[79];     { GRAPHICS path                           }
    MenuPATH     : STRING[79];     { MENUS path                              }
    LogPATH      : STRING[79];     { LOG path                                }
    MessagePATH  : STRING[79];     { MESSAGE path                            }
    UtilityPATH  : STRING[79];     { UTILITY path                            }
    SemaphorePATH: STRING[79];     { SEMAPHORE FILE path                     }
    FileReqPATH  : STRING[79];     { FILE REQUEST Holding path               }
    FilePATH     : STRING[79];     { Default FILE path (.NFB Files)          }
    TempPATH     : STRING[79];     { TEMP path (node temp is NODExxxx under) }
    SwapPATH     : STRING[79];     { SWAP path (node swap is NODExxxx under) }
    NetmailPATH  : STRING[79];     { Path To NETMAIL Directory               }
    ExtUploadPATH: STRING[79];     { Path to external program run after      }
                                   { an upload and before checking for       }
                                   { FILE_ID.DIZ                             }
    FileAttPATH  : STRING[79];     { RESERVED - DO NOT MODIFY                }
    RESERVED1path: STRING[79];     { RESERVED - DO NOT MODIFY                }
    
    BBSName      : STRING[80];     { BBS name                                }
    RESERVED1    : ARRAY[1..44]
                        of BYTE;   { RESERVED - DO NOT MODIFY                }
    SysopName    : STRING[30];     { SysOp's Full Real Name or Alias         }
    MaximumUsers : INTEGER;        { Currently unused                        }
    CurrentBuild : BYTE;           { Current Build number (1 => .01 )        }
    CurBuildMod  : CHAR;           { Current Build Modifier (should be       }
                                   { appended to the build number (.01a)     }
                                   { will be #32 if no modifier              }
    RESERVED2    : ARRAY[1..54] of
                        BYTE;      { RESERVED - DO NOT MODIFY                }
    akSysOp      : STRING[20];     { SysOp Access Key (BLANK for None)       }
    akNewUser    : STRING[20];     { NewUser Access Key (BLANK for None)     }
    RESERVED3    : ARRAY[1..62] of
                        BYTE;      { RESERVED - DO NOT MODIFY                }
    PreEventWarn : INTEGER;        { Time before event Warning (min)         }
    defLanguage  : BYTE;           { Default Language (FUTURE)               }
    RESERVED4    : ARRAY[1..29] of
                        BYTE;      { RESERVED - DO NOT MODIFY                }

    acsSysOp     : ACString;       { SysOp Access String                     }
    acsCoSysOp   : ACString;       { Co-SysOp Access String                  }
    acsMsgSysOp  : ACString;       { Message Base SysOp Access String        }
    acsFileSysOp : ACString;       { File Base SysOp Access String           }
    acsSeeAKey   : ACString;       { See Access Key at Logon Access String   }
    acsSeeSysOpAK: ACString;       { See SysOp Access Key remotely           }
    acsNormalPost: ACString;       { Post Public Message Access String       }
    acsNetmail   : ACString;       { Post Netmail Access String              }
    acsSeeUnval  : ACString;       { See Unvalidated Files Access String     }
    acsDLUnval   : ACString;       { Download Unvalidated Files Access String}
    acsNoDLRatio : ACString;       { No UL/DL Ratio Access String            }
    acsRESERVED1 : ACString;       { RESERVED - DO NOT MODIFY                }
    acsNoFilePts : ACString;       { No Filepoint Checking Access String     }
    acsULValidate: ACString;       { Uploads Need Validation Access String   }
    acsSetNetFlag: ACString;       { Set Netmail Flags Access String         }
    acsNetOutZone: ACString;       { Netmail Out-of-Zone Access String       }
    acsNoNodeChk : ACString;       { No Nodelist Check Access String         }
    acsUntagMand : ACString;       { Allow to untag mandatory bases?         }
    RESERVED5    : ARRAY[1..189] of
                        BYTE;      { RESERVED - DO NOT MODIFY                }

    maxFeedback  : BYTE;           { Maximum Feedback per call               }
    maxPublicPost: BYTE;           { Maximum Public Posts per call           }
    maxPage      : BYTE;           { Maximum Sysop Pages per call            }
    maxMsgLines  : BYTE;           { Maximum Lines in Message                }
    maxCSMsgLines: BYTE;           { Maximum Lines in Message for Co-SysOp + }
    maxLogonTries: BYTE;           { Maximum Attempts to enter Access Key    }
    chatSysOp    : BYTE;           { SysOp color in chat mode (TEXTATTR)     }
    chatUser     : BYTE;           { User color in chat mode (TEXTATTR)      }
    minMsgSpace  : INTEGER;        { Minimum KB drive space left to post     }
    RESERVED6    : ARRAY[1..2] of
                        BYTE;      { RESERVED - DO NOT MODIFY                }
    KeepLogDays  : BYTE;           { Days to keep NEXxxxx.LOG                }
    ScreenLength : BYTE;           { Default Screen Length (4-50)            }
    RESERVED7    : ARRAY[1..31] of
                        BYTE;      { RESERVED - DO NOT MODIFY                }

    AskAlias     : BOOLEAN;        { Prompt user for Alias Name or use Real  }
    PhoneAccess  : BOOLEAN;        { Prompt for last 4 digits at logon       }
    lSecurity    : BOOLEAN;        { Local Security: Ask Access Key at Local }
                                   { Logon                                   }
    lViewSecurity: BOOLEAN;        { Local View Security: Display Access Keys}
                                   { locally as they are entered             }
    GlobalDump   : BOOLEAN;        { Dump all screen output to GLOBxxxx.TRP  }
    AutoChatDump : BOOLEAN;        { Automatically Dump all chat activity to }
                                   { CHATxxxx.LOG                            }
    AliasPrimary : BOOLEAN;        { Is Alias used as primary display name in}
                                   { items such as User Listings, Node Lists,}
                                   { etc.                                    }
    AllowIEMSI   : BOOLEAN;        { Allow IEMSI logins?                     }
    RESERVED8    : ARRAY[1..9] of
                        BYTE;      { RESERVED - DO NOT MODIFY                }


    NewUserApp   : INTEGER;        { User Record # to send new user          }
                                   { application to (0=Inactive)             }
    InactBeep    : INTEGER;        { Minutes before Inactivity Beep          }
    InactLogoff  : INTEGER;        { Minutes of Inactvity before Logoff      }
    EMSOverlay   : BOOLEAN;        { Attempt to load overlays in EMS         }
    BiosVideo    : BOOLEAN;        { Use ROM BIOS for local video output     }
    CGASnow      : BOOLEAN;        { Suppress snow on CGA systems            }
    ProtOutput   : BOOLEAN;        { Display output for protocols?           }
    ArcOutput    : BOOLEAN;        { Display output for archivers?           }
    UseEXTchat   : BOOLEAN;        { Use External Chat defined in record 0 of}
                                   { DOORS.DAT?                              }
    RESERVED9    : ARRAY[1..27] of
                        BYTE;      { RESERVED - DO NOT MODIFY                }

    ArcComments  : ARRAY[1..3] of
                        STRING[80];{ Path/Filename of Comment Text Files     }
    fULDLRatio   : BOOLEAN;        { UL/DL Ratio System in use?              }
    fFilePoint   : BOOLEAN;        { FilePoint System in use?                }
                                   { Either, Both, or None of the above two  }
                                   { items may be set to TRUE.               }
    FPCompRatio  : BYTE;           { Percentage of File's File Points that   }
                                   { will be awarded to user upon upload     }
                                   { (0-255)                                 }
    FPKBperPoint : BYTE;           { When file is Uploaded, the Number of    }
                                   { KB required to assign 1 File Point to   }
                                   { the File.  Example: FPKBperPoint is set }
                                   { to 10.  File uploaded is 20Kb in size.  }
                                   { FilePoints assigned to that file would  }
                                   { be 2.                                   }
    ULTimeRefund : BYTE;           { Percentage of UL time spent that is     }
                                   { refunded to the user's account after UL }
                                   { is complete.                            }
    RESERVED10   : BYTE;           { RESERVED - DO NOT MODIFY                }
    AutoValidate : BOOLEAN;        { Validate files automatically?           }
    RemRedirect  : STRING[10];     { Remote redirection device (COMx,etc)    }
    maxTempKB    : INTEGER;        { Maximum KB allowed in Temporary Dirs    }
    minResumeKB  : INTEGER;        { Minimum Filesize in KB to allow resume  }
    minUploadKB  : INTEGER;        { Minimum KB required for Uploads         }
    DupSearchType: BYTE;           { Search for duplicate filenames on upload}
                                   {      0 = NONE                           }
                                   {      1 = All Bases                      }
                                   {      2 = Only Hard Drive Bases          }
    DupStrict    : BOOLEAN;        { Search for duplicates strictly          }
                                   { TRUE = Match Files with Exact Filename  }
                                   {        ONLY.  (Example: File user is    }
                                   {        uploading is FIRST.ARJ.  File    }
                                   {        that already exists is FIRST2.ZIP}
                                   {        This file would NOT be matched.) }
                                   { FALSE= Match Files with Filename found  }
                                   {        somewhere in it.  (Example: File }
                                   {        user is uploading is FIRST.ARJ.  }
                                   {        File that already exists is      }
                                   {        FIRST2.ZIP.  This file WOULD BE  }
                                   {        MATCHED.                         }
    FileListLines: BYTE;           { 0 - 10 lines                            }
                                   { 1 - 5 lines                             }
                                   { 2 - 1 line                              }
    PrvSysOpBase : INTEGER;        { -1 DISABLED                             }
    OfflineReq   : BOOLEAN;        { Allow Offline Files to be requested?    }
    ConvertWithAV: BOOLEAN;        { Convert files with known AV stamp?      }
    ConvertSame  : BOOLEAN;        { Convert archives even if source and     }
                                   { destination are same archive type?      }
    AddWithAV    : BOOLEAN;        { Allow adding of files to archives with  }
                                   { an AV stamp?                            }
    RESERVED11   : ARRAY[1..13] of
                        BYTE;      { RESERVED - DO NOT MODIFY                }

    TimeZone     : BYTE;           { Local Time Zone                         }
                                   { See TIMEZONE.DOC for more info          }
    RESERVED12   : ARRAY[1..214] of
                        BYTE;      { RESERVED - DO NOT MODIFY                }
END;

{----------------------------------------------------------------------------}
{ Filename: SUBSCRIP.DAT                                                     }
{ Location: DATA Directory                                                   }
{ Format  : Record #0 is holding record                                      }
{           Up to 255 <SubscriptionREC> Records (plus holding record)        }
{                                                                            }
{ Notes   : Used to store subscription level configuration.  There may be up }
{           to 255 subscription levels assigned, and each level will have a  }
{           record for it.  This record number corresponds directly to the   }
{           UserREC.Subscription variable.                                   }
{----------------------------------------------------------------------------}

SubscriptionREC=
RECORD
    Description  : STRING[40];    { Description of Subscription Level        }
    SL           : BYTE;          { Security Level of Subscription Level     }
    ARflags      : SET of
                        ARFlagSet;{ AR Flag Set for this Subscription Level  }
    ARmodifier   : BYTE;          { 0: Set AR Flags to this Set              }
                                  { 1: Soft update of AR Flags               }
    ACflags      : SET of UFlags; { AC Flag Set for this Subscription Level  }
    ACmodifier   : BYTE;          { 0: Set AC Flags to this Set              }
                                  { 1: Soft update of AC Flags               }
    FilePoints   : INTEGER;       { File Points for this Subscription Level  }
    FPmodifier   : BYTE;          { 0: Set FP to value                       }
                                  { 1: Add value to FP                       }
                                  { 2: Subtract value from FP                }
    Credits      : LONGINT;       { Credits for this Subscription Level      }
    Cmodifier    : BYTE;          { 0: Set Credits to value                  }
                                  { 1: Add value to Credits                  }
                                  { 2: Subtract value from Credits           }
    TimeBank     : INTEGER;       { Time Bank for this Subscription Level    }
    TBmodifier   : BYTE;          { 0: Set Time Bank to value                }
                                  { 1: Add value to Time Bank                }
                                  { 2: Subtract value from TimeBank          }
    SubLength    : INTEGER;       { Length of subscription level             }
                                  { -1: No length (indefinate)               }
    NewSubLevel  : INTEGER;          { New Subscription Level after expiration  }
    RESERVED     : ARRAY[1..19]
                      OF BYTE;    { RESERVED - DO NOT MODIFY                 }
END;
    
{----------------------------------------------------------------------------}
{ Filename: LANGUAGE.DAT                                                     }
{ Location: DATA Directory                                                   }
{ Format  : Record #0 is holding record                                      }
{           1 record for each installed language                             }
{                                                                            }
{ Notes   : Used to store information regarding installed languages.  There  }
{           will be 1 record for each language.  The record number directly  }
{           corresponds to the UserREC.Language variable.                    }
{----------------------------------------------------------------------------}

LanguageREC=                          { LANGUAGE.DAT }
RECORD
    Name:STRING[40];                { Description of Language                }
    Filename:STRING[8];             { [FILENAME].NXL                         }
    Menuname:STRING[8];             { [MENUNAME].NXM                         }
    Access:ACString;                { Access Control String                  }
    DisplayPATH:STRING[79];         { Display File Path                      }
                                    { <blank> = Use Default Path             }
    CheckDefPath:BOOLEAN;           { If display file does not exist in      }
                                    { DisplayPATH, check Default Path?       }
                                    { Ignored if DisplayPATH is <blank>      }
    Startmenu:WORD;                 { Start Menu # For this Language         }
                                    { Record number+1 in MENUS.DAT           }
    RESERVED1:ARRAY[1..50] of BYTE; { RESERVED - DO NOT MODIFY               }
END;

{----------------------------------------------------------------------------}
{ Filename: MBASES.IDX, FBASES.IDX                                           }
{ Location: DATA Directory                                                   }
{ Format  : 1 <BaseIDX> record for each corresponding Message/File Base      }
{                                                                            }
{ Notes   : This is an index containing one record for each message/file base}
{           that exists.  The Offset variable will contain the the offset to }
{           the record number in the file MBASES.DAT/FBASES.DAT for the base.}
{           The Offset variable MUST match the current record number in the  }
{           index file.  The BaseID value will contain the BaseID for the    }
{           base that is referenced by the index.                            }
{----------------------------------------------------------------------------}

BaseIDX=
RECORD
        Offset:INTEGER;         { Offset to record # in base data file      }
        BaseID:LONGINT;         { Permanent Base ID - Should match record # }
end;

{----------------------------------------------------------------------------}
{ Filename: MBASEID.IDX, FBASEID.IDX                                         }
{ Location: DATA Directory                                                   }
{ Format  : 1 <BaseIDIDX> record for each corresponding Message/File BaseID  }
{                                                                            }
{ Notes   : This is the index of all present AND past Message/File BaseID    }
{           values.  When a BaseID is active, it will contain the number,    }
{           which MUST be the same as the record number in the file, and the }
{           offset variable will contain the record number of the appropriate}
{           file (MBASES.DAT/FBASES.DAT) that contains the base information  }
{           that has this BaseID.                                            }
{----------------------------------------------------------------------------}

BaseIDIDX=
RECORD
        BaseID:LONGINT;         { Permanent Base ID - Should match record # }
        Offset:INTEGER;         { Offset to record # in base data file      }
end;

{----------------------------------------------------------------------------}
{ Filename: MBTAGS.IDX                                                       }
{ Location: DATA Directory                                                   }
{ Format  : 1 <BaseTagIDX> record for each corresponding Message Base        }
{                                                                            }
{ Notes   : Quick index to tagnames for Message Bases.                       }
{----------------------------------------------------------------------------}

BaseTagIDX=
RECORD
        NetTagname:string[50];      { Network/Blue Wave Tag Name for this    }
                                    { base.  MUST NOT BE DUPLICATED!         }
end;

{----------------------------------------------------------------------------}
{ Filename: MBASES.DAT                                                       }
{ Location: DATA Directory                                                   }
{ Format  : 1 <MsgBaseREC> record for each corresponding Message Base        }
{                                                                            }
{ Notes   : Message Base Data File, containing all information about each    }
{           message base.  Up to MaxMsgBases of records.                     }
{----------------------------------------------------------------------------}

MBFlags=                          { Message Base Flags                       }

   (MBUnhidden,                   { whether *VISIBLE* to users w/o access    }
    MBRealname,                   { whether real names are forced            }
    MBFilter,                     { whether to filter ANSI/8-bit ASCII       }
    MBSKludge,                    { strip IFNA kludge lines                  }
    MBSSeenby,                    { strip SEEN-BY lines                      }
    MBNetmail,                    { whether netmail allowed to be sent       }
                                  { from this base                           }
    MBSOrigin);                   { strip origin lines                       }

MBPrivLvl=                        { MSG Types allowed                        }

   (Private,                      { Private Only                             }
    Public,                       { Public Only                              }
    PubPriv);                     { Public OR Private                        }

MsgBaseREC=
RECORD
    Name         : STRING[70];    { Message base description                 }
    Filename     : STRING[8];     { JAM/SQUISH Message Base Filename         }
                                  { *NOT NEEDED for .MSG                     }
    NetTagName   : STRING[50];    { Network Tag Name                         }
    MBType       : INTEGER;       { 0 = Local                                }
                                  { 1 = Echo                                 }
                                  { 2 = Netmail                              }
                                  { 3 = Internet E-Mail                      }
    MSGPath      : STRING[40];    { Messages pathname                        }
                                  { For JAM/Squish this is the path to the   }
                                  { Message Base Files.  For *.MSG, this is  }
                                  { the path to the .MSG files               }
    MBFlag       : SET of
                        MBFlags;  { Message Base Flags                       }
    MBPriv       : SET of
                        MBPrivLvl;{ Message Priveledge Level                 }
    Access       : ACString;      { Access to this Base                      }
    PostAccess   : ACString;      { Access to Post on this Base              }
    MaxMSGS      : WORD;          { Maximum Messages in this Base            }
    AccessKey    : STRING[20];    { Access Key to this Base                  }

                                  { Following colors are in TEXTATTR form:   }

    TextColor    : BYTE;          { color of standard text                   }
    QuoteColor   : BYTE;          { color of quoted text                     }
    TagColor     : BYTE;          { color of taglines                        }
    OldTearColor : BYTE;          { color of old tear lines (___ or ~~~)     }
    TearColor    : BYTE;          { color of tear line                       }
    OriginColor  : BYTE;          { color of origin line                     }
    Address      : ARRAY[1..30] of
                        BOOLEAN;  { Address (1-30) out of NETWORK.DAT        }
                                  { Only one TRUE for ECHOMAIL bases         }
                                  { Only one TRUE for INTERNET EMAIL bases   }
                                  { Any number TRUE for NETMAIL Bases        }
    Origin       : BYTE;          { Origin Line (1-20) out of NETWORK.DAT    }
    RESERVED1    : BYTE;          { RESERVED - DO NOT MODIFY                 }
    MessageType  : BYTE;          { 1 = Squish                               }
                                  { 2 = JAM(mbp)(tm)                         }
                                  { 3 = .MSG                                 }
    DefTagType   : BYTE;          { 0 = Default Tagged                       }
                                  { 1 = Default Untagged                     }
                                  { 2 = Mandatory                            }
    NameUsage    : BYTE;          { 0 = Real Name                            }
                                  { 1 = Alias                                }
                                  { 2 = Ask                                  }
                                  { Included for FUTURE USE                  }
    InConfs      : SET of
                     JoinedConfs; { Conferences this Message Base is in      }
    Gateway:BYTE;                 { For INTERNET BASES : GATEWAY NUMBER from }
                                  { INTERNET.DAT.  Ignored on other bases.   }
    RESERVED2    : ARRAY[1..94] of
                        BYTE;     { RESERVED - DO NOT MODIFY                 }
    MBaseID      : LONGINT;       { permanent index #                        }
END;

{----------------------------------------------------------------------------}
{ Filename: MCONF?.IDX, FCONF?.IDX (where ? is A-Z)                          }
{ Location: DATA Directory                                                   }
{ Format  : 1 <ConfIDX> record                                               }
{                                                                            }
{ Notes   : Conference Index, which contains TRUE for each message base that }
{           is tagged as using this particular conference.  Example:  If you }
{           wish to know if Message Base #10 is in Conference B, you would   }
{           open MCONFB.IDX, and see if <ConfIDX>.Index[10] is TRUE.         }
{                                                                            }
{           An alternative is to open the file as a FILE of BOOLEAN, seek to }
{           the position that you are interested in, read in that boolean and}
{           check the status of it.                                          }
{----------------------------------------------------------------------------}

ConfIDX=
RECORD
     Index:ARRAY[0..32767] of BOOLEAN;  { Array containing Bases          }
END;


{----------------------------------------------------------------------------}
{ Filename: FBASES.DAT                                                       }
{ Location: DATA Directory                                                   }
{ Format  : 1 <FileBaseREC> record for each corresponding File Base          }
{                                                                            }
{ Notes   : File Base Date File, containing all information about each File  }
{           base.  Up to MaxFileBases of records.                            }
{----------------------------------------------------------------------------}

fbFlags=
   (fbNoratio,                    { if all files are FREE }
    fbUnhidden,                   { whether *VISIBLE* to users w/o access }
    fbDirDLpath,                  { if *.NFB file stored in DLPATH }
    fbTicBase,                    { if a Network (TIC) type base }
    fbUseGifSpecs,                { whether to use GifSpecs }
    fbNFMbase,                    { whether NFM uses this base }
    fbAllowOfflineRequest);       { Allow requesting of offline files? }

FileBaseREC=                          { FBASES.DAT : File base records }
RECORD
    Name      : STRING[70];          { Base Description                      }
    Filename  : STRING[8];           { Filename of filebase (no extension)   }
    RESERVED1 : ARRAY[1..4] of BYTE; { RESERVED - DO NOT MODIFY              }
    FilePATH  : STRING[79];          { path to this bases files              }
    RESERVED2 : ARRAY[1..2] of
                BYTE;                { RESERVED - DO NOT MODIFY              }
    MaxFiles  : INTEGER;             { max files allowed                     }
    AccessKey : STRING[20];          { passWORD required                     }
    Archiver,                        { wanted archive type (1..max,0=inactive}
    Comment   : BYTE;                { wanted comment type (1..3,0=inactive) }
    fbFlag    : SET of fbflags;      { file base status vars                 }
    Access,                          { access requirements                   }
    ULAccess,                        { upload requirements                   }
    NameAccess: ACString;            { see-names requirements                }
    CDROM     : BOOLEAN;             { Is this base on a CD?                 }
    cdUploaded: BOOLEAN;             { Has this base been uploaded by NFM?   }
    cdNumber  : INTEGER;             { CD-ROM Disk Number associated with    }
    RESERVED3 : BYTE;                { RESERVED - DO NOT MODIFY              }
    DefTagType: BYTE;                { 0 = Default Tagged                    }
                                     { 1 = Default Untagged                  }
                                     { 2 = Mandatory                         }
    InConfs   : SET of JoinedConfs;  { Conferences this File Base is in      }
    FBaseID:LONGINT;                 { Permanent ID - DO NOT MODIFY          }
    RESERVED4 : ARRAY[1..91] of BYTE;     { RESERVED - DO NOT MODIFY         }
END;

{----------------------------------------------------------------------------}
{ Filename: LASTON.DAT                                                       }
{ Location: DATA Directory                                                   }
{ Format  : 1 <LastonREC> record for each call to the BBS                    }
{           There will be 10 records at all times (records 0-9)              }
{                                                                            }
{ Notes   : The 0 record is the newest entry, down to the last record.       }
{----------------------------------------------------------------------------}

LastonREC=
RECORD
    Name        : STRING[36];     { Name of user (Real or Alias based on     }
                                  { system settings                          }
    RESERVED    : INTEGER;        { RESERVED                                 }
    CallingFrom : STRING[30];     { Caller's Calling From string             }
    UserBaud    : STRING[6];      { Baud rate connected at                   }
    Node        : INTEGER;        { Node connected on                        }
    DateOn      : STRING[8];      { Date connected                           }
    TimeOn      : STRING[8];      { Time connected                           }
END;

{----------------------------------------------------------------------------}
{ Filename: DOORS.DAT, EDITORS.DAT                                           }
{ Location: DATA Directory                                                   }
{ Format  : 1 <DoorREC> record for each door/editor                          }
{           EDITORS.DAT has 0 holding record                                 }
{           DOORS.DAT 0 record is information for External Chat              }
{                                                                            }
{----------------------------------------------------------------------------}

DoorTrackREC=
RECORD

        TimesUsed:LONGINT;
        MinutesUsed:LONGINT;
        DTRESERVED:ARRAY[1..100] of BYTE;
END;

DoorREC=
RECORD          

    DOORFilename: STRING[79];     { Path/Filename to Door or Batch File      }
    DOORName    : STRING[40];     { Name for Display of Door                 }
    DOORDropType: BYTE;           { Drop File Type:                          }
                                  {     1 - DOOR.SYS                         }
                                  {     2 - DOORFILE.SR                      }
                                  {     3 - CHAIN.TXT                        }
                                  {     4 - DORINFO1.DEF                     }
                                  {     5 - SFDOORS.DAT                      }
                                  {     6 - CALLINFO.BBS                     }
                                  {     7 - No drop file                     }
    DOORDropPath: STRING[79];     { Path to the location to place the Drop   }
                                  { File                                     }
    RIPenabled  : BOOLEAN;        { RIPscrip graphics enabled for this door  }
    Realname    : BOOLEAN;        { Use Realnames                            }
    MaxMinutes  : REAL;           { Maximum minutes allowed (time left is    }
                                  { max if less than this value, 0 means     }
                                  { disabled, use time left always           }
    LocalOnly   : BOOLEAN;        { For EDITORS only (ignored in Doors)      }
    ShowLoadStr : BOOLEAN;        { Whether the "Loading..." string should be}
                                  { shown before running this door           }

    DRESERVED1  : ARRAY[1..94] of BYTE;  { RESERVED - DO NOT MODIFY          }
    DoorID      : LONGINT;        { Permanent DoorID number (DO NOT MODIFY)  }
    TRACKToday  : DoorTrackREC;   { Door Tracking for Today - used for       }
                                  { running total and then moved to yesterday}
                                  { at nightly maintenance                   }
    TRACKYest   : DoorTrackREC;   { Door Tracking for Yesterday              }
    TRACKForever: DoorTrackREC;   { Door Tracking for Forever                }

    DRESERVED2  : ARRAY[1..300] of BYTE; { RESERVED - DO NOT MODIFY          }
END;

{----------------------------------------------------------------------------}
{ Filename: PROTOCOL.DAT                                                     }
{ Location: DATA Directory                                                   }
{ Format  : 1 <ProtocolREC> record for each protocol                         }
{                                                                            }
{ Notes   : There is no holding record in this file.                         }
{----------------------------------------------------------------------------}

protFlags=
   (protActive,
    protBatch,
    protResume,
    protUseOpus,
    protNameSingle);

ProtocolREC=
RECORD
    Name     : STRING[40];              { Description of Protocol            }
    KeyChar  : CHAR;                    { Character used to select protocol  }
    pFlags   : SET of protFlags;        { Protocol flags                     }
    Access   : ACString;                { Access Control String              }
    ulCommand: STRING[79];              { UL Batch File Name                 }
    dlCommand: STRING[79];              { DL Batch File Name                 }
    TempLog  : STRING[25];              { Temporary log file                 }
    ulLog,
    dlLog    : STRING[25];              { Permanent log files                }
    EnvCMD   : STRING[60];              { Environment command before transfer}
    dlFList  : STRING[25];              { DL File list filename              }
    ulCode   : INTEGER;                 { UL errorcode OK                    }
    dlCode   : INTEGER;                 { DL errorcode OK                    }
    MaxChars : INTEGER;                 { Maximum characters in cmdline      }
    LogPf,
    LogPs    : INTEGER;                 { Position in log file for data      }
    RESERVED : ARRAY[1..30] of BYTE;    { RESERVED                           }
END;

cdrec=                                  { CDS.DAT }
RECORD
    name:STRING[36];                    { Name of CD for Internal Use }
    volumeid:STRING[12];                { Volume ID of CD }
    uniquefile:STRING[40];              { Unique filename to use instead }
    useunique:boolean;                  { Use Unique Filename instead of
                                                VolumeID}
    viewACS:acstring;
    RESERVED:ARRAY[1..40] of BYTE;      { RESERVED }
END;

{----------------------------------------------------------------------------}
{ Filename: CDS.IDX                                                          }
{ Location: DATA Directory                                                   }
{ Format  : 1 <CDromIDX> record                                              }
{                                                                            }
{ Notes   : There is no holding record in this file.                         }
{           Each element in the array represents a drive letter.  As a double}
{           security measure, the drive letter (capitalized) is placed in the}
{           appropriate spot for the letter, which is ord(letter)-64.        }
{           Therefore, A would be placed in 1, B in 2, etc.                  }
{----------------------------------------------------------------------------}

CDromIDX=
RECORD
    Drives:ARRAY[1..26] of CHAR;     { Drives currently available for CDs    }
END;

{----------------------------------------------------------------------------}
{ Filename: CONFS.DAT                                                        }
{ Location: DATA Directory                                                   }
{ Format  : 1 <ConfsREC> record                                              }
{                                                                            }
{ Notes   : There is no holding record in this file.                         }
{           Each conference is represented by a letter A-Z (1-26).  To access}
{           information for Message Conference A, you would use:             }
{           <ConfsRec>.MSGconf[1].<field>                                    }
{----------------------------------------------------------------------------}

ConferenceREC=
RECORD
        name   : STRING[40];    { Name of this conference                    }
        access : ACString;      { Access String for this conference          }
        active : BOOLEAN;       { Is this conference active?                 }
        hidden : BOOLEAN;       { Is this conference hidden?                 }
END;

ConfsREC=
RECORD
        MSGconf  : ARRAY[1..26] of ConferenceREC;  { Message Conferences     }
        FILEconf : ARRAY[1..26] of ConferenceREC;  { File Conferences        }
END;

{----------------------------------------------------------------------------}
{ Filename: REQUESTS.DAT                                                     }
{ Location: FILE Directory                                                   }
{ Format  : 1 <RequestREC> record for each request                           }
{                                                                            }
{ Notes   : There is no holding record in this file.                         }
{           A new record is added to the file each time a file is requested. }
{----------------------------------------------------------------------------}

RequestREC=
RECORD
    FileAvail  : BOOLEAN;          { whether file has been made available in }
                                   { the Systat.FileReqPath Path             }
    ReqDenied  : BOOLEAN;          { If Sysop has denied File Request        }
    Filename   : STRING[12];       { Filename of File Requested              }
    FileBase   : INTEGER;          { Base Number File is In                  }
    UserReal   : STRING[36];       { User's Real Name that Requested File    }
    RESERVED   : ARRAY[1..100] of
                        BYTE;      { RESERVED                                }                          
end;

{----------------------------------------------------------------------------}
{ Filename: FLAGxxxx.DAT (xxxx is node number)                               }
{ Location: TEMP Directory                                                   }
{ Format  : 1 <FlaggedREC> record for each flagged file                      }
{                                                                            }
{ Notes   : There is no holding record in this file.                         }
{           A new record is added to the file each time a file is flagged.   }
{----------------------------------------------------------------------------}

FlaggedREC=
RECORD
    Filename   : STRING[65];       { Filename of file flagged, full path     }
    Description:array[1..10] of  
                  STRING[45];      { First 10 lines of description           }
    Filebase   : INTEGER;          { Filebase this file is located in, -1 for}
                                   { unlisted.                               }
    Filepoints : INTEGER;          { Filepoints for this file.               }
    KB         : LONGINT;          { Number of KB for this file              }
    TransTime  : REAL;             { Estimated Transfer time                 }
    isCDromFile: BOOLEAN;          { Is this file on CD-ROM?                 }
END;

{----------------------------------------------------------------------------}
{ Filename: MENUS.DAT                                                        }
{ Location: DATA Directory                                                   }
{ Format  : 1 <MenuREC> record for each menu                                 }
{                                                                            }
{ Notes   : There is no holding record in this file.                         }
{           Although menus are numbered 1+, the actual location of the record}
{           is Menu Number - 1.                                              }
{----------------------------------------------------------------------------}


mnuFlags=
   (mnuClrscreen,                 { Clear screen before menu display         }
    mnuNoCenter,                  { Don't center the menu titles!            }
    mnuNoPrompt,                  { No menu prompt whatsoever?               }
    mnuForcePause,                { Force a pause before menu display?       }
    mnuAutoTime,                  { Is time displayed automatically?         }
    mnuFileChange,                { Allow Filebase QuickChange?              }
    mnuMsgChange,                 { Allow Messagebase QuickChange?           }
    mnuNoGlobal);                 { Do not use Global Commands in this menu  }

MenuREC=
RECORD
    Name      : STRING[60];       { Menu Name                                }
    Filename  : STRING[8];        { Menu Filename (*.MNU)                    }
    Header    : STRING[12];       { Menu Header Filename                     }
    Footer    : STRING[12];       { Menu Footer Filename                     }
    Display   : STRING[12];       { Menu Display File (blank=GENERIC)        }
    HelpScreen: STRING[12];       { Menu Help File (blank=GENERIC)           }
    Fallback  : WORD;             { Fallback Menu #                          }
    Title     : ARRAY[1..3] of
                  STRING[100];    { GENERIC Menu Header                      }
    Prompt    : STRING[120];      { Menu Prompt                              }
    Access    : ACString;         { Access Control String                    }
    Accesskey : STRING[15];       { Access Key for Access to Menu            }
    Helplevel : BYTE;             { Force Help Level to                      }
    Columns   : BYTE;             { GENERIC Number of Columns                }
    Colors    : ARRAY[1..3] of
                        BYTE;     { GENERIC Colors                           }
    menuFlags : SET of mnuFlags;  { Menu Flags                               }
END;

{----------------------------------------------------------------------------}
{ Filename: *.MNU                                                            }
{ Location: MENU Directory                                                   }
{ Format  : 1 <MenuCommandREC> record for each menu command                  }
{                                                                            }
{ Notes   : There is no holding record in this file.                         }
{----------------------------------------------------------------------------}

cmdFlags=
   (cmdHidden,                    { Command is ALWAYS hidden                 }
    cmdUnhidden,                  { Command is ALWAYS visible                }
    cmdAutoexec,                  { Auto exececute command upon menu startup }
    cmdTitleline);                { Command is a Title Display line          }

MenuCommandREC=
RECORD
    LongDesc : STRING[70];        { Long Description                         }
    ShortDesc: STRING[35];        { Short Description                        }
    ExecKeys : STRING[14];        { Command Execution Keys                   }
    Access   : ACString;          { Access String                            }
    RESERVED : BYTE;              { RESERVED                                 }
    Command  : ARRAY[1..2] of
                        CHAR;     { Command Type                             }
    CommData : STRING[80];        { Additional Command Data                  }
    cFlags   : SET of cmdFlags;   { Command Flags                            }
END;

{----------------------------------------------------------------------------}
{ Filename: *.NXL                                                            }
{ Location: DATA Directory                                                   }
{ Format  : 1 <StringIDX> record at the beginning of file                    }
{           RAW String Data following Index                                  }
{                                                                            }
{ Notes   : This file type is a RAW data file with an index placed at the    }
{           beginning of the file.  The index is an index placeholder for    }
{           each of the configurable strings.  The index entry may be filled }
{           with either the byte offset in the file of the beginning of the  }
{           string, or -1 if the string is blank.  The strings are stored    }
{           beginning with the first byte in the file after the index.  They }
{           are stored in Turbo Pascal format ([length byte][data]).  The    }
{           best way to find a string is to blockread the contents of the    }
{           index into a variable of type <StringIDX>.  Then when you wish to}
{           retrieve a string, seek to the byte position identified for that }
{           string number in the index (returning a blank string for those   }
{           which contain -1), and blockread one byte into the [0] byte of   }
{           the string.  Once you have obtained this, you can blockread the  }
{           rest of the string.                                              }
{                                                                            }
{----------------------------------------------------------------------------}
{ EXAMPLE:                                                                   }
{           NOTE: StrIdx is a pointer to a StringIDX record, which has been  }
{ allocated and the data read in before calling this function.  Rememeber to }
{ take into account the path information from the MATRIX.DAT when opening the}
{ files shown in this example.  This has not been done in the example.       }
{----------------------------------------------------------------------------}
{ This function will return the string located in string # 'x'               }
{                                                                            }
{ FUNCTION GetString (x:INTEGER):STRING;                                     }
{ VAR f:FILE;                                                                }
{     s:STRING;                                                              }
{     numread:WORD;                                                          }
{ BEGIN                                                                      }
{ if (stridx^.offset[x]<>-1) then begin                                      }
{ assign(f,'ENGLISH.NXL');                                                   }
(*{$I-} reset(f,1); {$I+}                                                   *)
{ if (ioresult<>0) then begin                                                }
{       writeln('Error reading ENGLISH.NXL');                                }
{       GetString:='';                                                       }
{       exit;                                                                }
{ end;                                                                       }
(*{$I-} seek(f,stridx^.offset[x]); {$I+}                                    *)
{ if (ioresult<>0) then begin                                                }
{       writeln('Error reading ENGLISH.NXL');                                }
{       GetString:='';                                                       }
{       close(f);                                                            }
{       exit;                                                                }
{ end;                                                                       }
{ blockread(f,s[0],1,numread);                                               }
{ if (numread<>1) then begin                                                 }
{       writeln('Error reading ENGLISH.NXL');                                }
{       GetString:='';                                                       }
{       close(f);                                                            }
{       exit;                                                                }
{ end;                                                                       }
{ blockread(f,s[1],ord(s[0]),numread);                                       }
{ if (numread<>ord(s[0])) then begin                                         }
{       writeln('Error reading ENGLISH.NXL');                                }
{       gstring:='';                                                         }
{       close(f);                                                            }
{       exit;                                                                }
{ end;                                                                       }
{ close(f);                                                                  }
{ end else s:='';                                                            }
{ GetString:=s;                                                              }
{ end;                                                                       }
{----------------------------------------------------------------------------}

StringIDX=
RECORD
    Offset:ARRAY[1..2000] of LONGINT;
END;

{ End file NEXUS.INC }
