//@doc      CONF
//@module   CONF.H - Public configuration header |
//
//  This is the simplified header for use with the MetaKit library.
//
//  There is no point in exporting the bulky and complex conditional header
//  structure used within the library itself, but the definitions below will
//  have to be changed substantially to support new compilers, etc.
//  
//@devnote  Version 1.2, jcw@meta4.nl
//@normal   Copyright <cp> 1996 Meta Four Software. All rights reserved.

#ifndef __K4CONF_H__
#define __K4CONF_H__

/////////////////////////////////////////////////////////////////////////////
// Microsoft Foundation Classes

#include <afxcoll.h>

typedef class CFile         c4_File;        
typedef class CString       c4_String;
typedef class CPtrArray     c4_PtrArray;

    // MSVC 1.52 thinks a typedef has no constructor, so use a define instead
#if _MSC_VER == 800
    #define c4_String CString
#endif
    
/////////////////////////////////////////////////////////////////////////////
// Microsoft Visual C++

#if NDEBUG && !defined(q4_INLINE)       // expand inline in release builds
    #define q4_INLINE 1
#endif

/////////////////////////////////////////////////////////////////////////////
// Other definitions needed by the public MetaKit library header files

#if q4_INLINE                           // enable inline expansion
    #define d4_inline inline
#else
    #define d4_inline
#endif

#define false 0
#define true 1
#define bool int

typedef unsigned char   uchar;
typedef unsigned short  ushort;
typedef unsigned int    uint;
typedef unsigned long   ulong;
    
/////////////////////////////////////////////////////////////////////////////

#endif
