'***********************************************************************
'* FILE EXEHDR.BAS
'*    Released 17 Jun 1996.
'*
'* PURPOSE
'*    Demonstrates the storing data at the end of an .EXE.
'*
'* NOTES
'*    The program will either create a user record at the end of the
'*    .EXE (if it doesn't already exist), or read the existing user
'*    record and increment the "User.Executed" variable in order to
'*    maintain a record of the number of times the program has been
'*    executed.
'*
'*    Two pieces of information are needed in order to accomplish this
'*    task: the fully qualified filename of the .EXE and the size of the
'*    .EXE (which is independent of the true file size).
'*
'*    FUNCTION GetEXESize& returns the size of the executable by reading
'*    the .EXE header (among the information kept here is the number of
'*    paragraphs used by the .EXE image). FUNCTION ProgName$ (by calling
'*    DOS ISR 21H, Function 51H (Get PSP Address)) is used to return the
'*    fully qualified filename of the .EXE.
'*
'*    If run in the QB or PDS IDE (QB.EXE and QBX.EXE respectively),
'*    FUNCTION ProgName$ returns the filename of the IDE (since, of
'*    course, it *is* the name of the currently executing program! :)
'*    Therefore, DO NOT run this code from within the IDE!
'*
'*    Note that this technique will trigger some anti-virus software.
'*
'*    If you're interested in security you may also want to use, at
'*    least, a rudimentary form of encryption on the data.
'*
'* WARRANTY
'*    Joe Negron disclaims all warranties regarding this software,
'*    whether express or implied, including, but not limited to,
'*    warranties of merchantability, fitness for a particular purpose,
'*    or functionality.
'*
'* LICENSE AGREEMENT
'*    This source code is released to the Public Domain.  However, an
'*    acknowledgement in your documentation will be appreciated.  You
'*    may also, as a further courtesy, give me a registered copy of the
'*    program in which this code is used; please leave me a message (see
'*    CONTACTING THE AUTHOR) should you decide to do this.
'*
'*    I encourage those to whom this code proves useful (and those to
'*    whom it does not) to consider making a donation to their preferred
'*    charity.
'*
'* ACKNOWLEDGEMENTS
'*    My wife, Ana, for allowing me to spend countless hours at the PC.
'*
'* CONTACTING THE AUTHOR
'*    If you have any comments, constructive criticism, bug fixes or
'*    enhancements to offer, you may communicate with me in a variety
'*    of ways (in order of preference):
'*
'*       1. If you have access to FidoNet NetMail, route or crash a
'*          message to Joe Negron at 1:278/216.
'*
'*       2. Log onto my BBS:
'*
'*             The Programmer's Mark BBS, 1:278/216@fidonet
'*                (718) 921-9267
'*                Brooklyn, NY, USA
'*                Joe Negron, Sysop
'*                John Bragazzi, Co-Sysop
'*                Running Maximus/2 v3.01
'*                Available 24 hours/day, 7 days/wk
'*
'*          and leave a message in message area JNEGRON, Support for Joe
'*          Negron Products.
'*
'*       3. If you have access to the Internet, leave a message,
'*          addressed to "joe.negron@consultant.com".
'*
'*       4. Via snail mail:
'*
'*             Joe Negron
'*             P.O. Box 09546
'*             Fort Hamilton Station
'*             Brooklyn, NY  11209
'***********************************************************************
DEFINT A-Z

DECLARE FUNCTION GetEXESize& (FileSpec$, Handle%)
DECLARE FUNCTION ProgName$ ()

'$INCLUDE: 'qb.bi'                           'Comment this, and
''$INCLUDE: 'qbx.bi'                         '  un-comment this, for PDS

TYPE UserData                                'Define our record
   UName    AS STRING * 20                   '  structure
   Executed AS INTEGER
END TYPE

DIM User AS UserData                         'Allocate space for our
                                             '  record
FileSpec$ = ProgName$                        'Get the fully qualified
                                             '  filename of the program

EXESize& = GetEXESize&(FileSpec$, Handle%)   'Get executable file size
FileSize& = LOF(Handle%)                     'Get true file size

DataLoc& = EXESize& + 1                      'Set pointer to data

IF FileSize& = EXESize& THEN                 'If the same size...
   PRINT "User info does not exist..."
   INPUT "Please enter your name: ", User.UName
ELSE
   GET Handle%, DataLoc&, User               'Read user info
END IF

User.Executed = User.Executed + 1            '.EXE has been run again

PRINT "User:           "; User.UName
PRINT "Times executed:"; User.Executed

PUT Handle%, DataLoc&, User                  'Write new data

CLOSE Handle%
SYSTEM

'***********************************************************************
'* FUNCTION GetEXESize&
'*
'* PURPOSE
'*    This function returns the size of an EXE in a long variable.
'*    Note that this routine does not close the file
'*
'* PARAMETER(S)
'*    FileSpec$ - EXE from which to get file size.
'*
'*    Handle%   - File handle used to open FileSpec$.
'***********************************************************************
FUNCTION GetEXESize& (FileSpec$, Handle%) STATIC
   Handle% = FREEFILE                        'Get a free file handle
   OPEN FileSpec$ FOR BINARY AS Handle%

   Hdr$ = SPACE$(6)                          'Read first six bytes
   GET Handle%, 1, Hdr$                      '  of EXE header

   'Calculate the number of partial pages used in the EXE, if any.
   'Bytes three and four hold this info.
   PartialPages& = ASC(MID$(Hdr$, 4)) * 256& + ASC(MID$(Hdr$, 3))

   'Calculate the # of whole pages.
   WholePages& = ASC(MID$(Hdr$, 6)) * 256& + ASC(MID$(Hdr$, 5))

   IF PartialPages& THEN                     'Any fractional pages?
      WholePages& = WholePages& - 1          'Subtract 1 from page count
   END IF

   'Return the .EXE size (number of whole pages plus any partial page)
   GetEXESize& = WholePages& * 512& + PartialPages&
END FUNCTION

'***********************************************************************
'* FUNCTION ProgName$
'*
'* PURPOSE
'*    Uses DOS ISR 21H, Function 51H (Get PSP Address) to return the
'*    name of the currently executing program.  Note that this FUNCTION
'*    requires DOS 3.0 or >.
'***********************************************************************
FUNCTION ProgName$ STATIC
   DIM Reg AS RegType

   Reg.ax = &H5100                              'DOS function 51h
   Interrupt &H21, Reg, Reg                     '  Get PSP Address

   DEF SEG = Reg.bx
   EnvSeg% = PEEK(&H2C) + PEEK(&H2D) * 256      'Get environment address
   DEF SEG = EnvSeg%

   DO
      Byte% = PEEK(Offset%)                     'Take a byte

      IF Byte% = 0 THEN                         'Entries are ASCIIZ
         Count% = Count% + 1                    '  terminated

         IF Count% AND EXEFlag% THEN            '.EXE also ASCIIZ string
            EXIT DO                             'Exit at the end
         ELSEIF Count% = 2 THEN                 'Last entry terminated
            EXEFlag% = -1                       '  with two NULs.  Two
            Offset% = Offset% + 2               '  bytes ahead is the
         END IF                                 '  .EXE file name.
      ELSE                                      'If Byte% <> 0,
         Count% = 0                             '  reset zero counter

         IF EXEFlag% THEN                       'If .EXE name found,
            Temp$ = Temp$ + CHR$(Byte%)         '  build string
         END IF
      END IF

      Offset% = Offset% + 1                     'To grab next byte...
   LOOP                                         'Do it again

   DEF SEG                                      'Reset default segment
   ProgName$ = Temp$                            'Return value
   Temp$ = ""                                   'Clean up
END FUNCTION
