#if !defined(HTML_DEFINED)
#define HTML_DEFINED
#include "strClass.h"
	class
BlockOption : public String{
	friend ostream& operator << ( ostream& out, BlockOption& option);
  protected:
	String name;
  public:
  	BlockOption(BlockOption& b) : String((String&) b), name(b.name){}
  	BlockOption(const char * const _name, const char * const value)
		: name(_name), String(value){}
	BlockOption(const char * const _name) : name(_name){}
	CAST_INJECTORS(BlockOption)
	};
CAST_IOMANIP(BlockOption)
ostream& operator << ( ostream& out, BlockOption& b);
class Block;
ostream& operator << ( ostream& out, Block& b);
	class
Block : public String {
	friend ostream& operator << ( ostream& out, Block& b);
  protected:
	String tag;
	BlockOption* option[10];
	unsigned blockOptionCount;
  public:
	Block():tag(),blockOptionCount(0){}
	Block(const char * const _tag):tag(_tag),blockOptionCount(0){}
	Block( Block& sourceBlock);
	~Block();
		Block& operator
	<< ( BlockOption& opt );
		Block&
	filter(const char * text);
	CAST_INJECTORS(Block)
		Block& operator
	<< ( Block& b ){
		(ostrstream&)*this << b;
		return *this;
		}
  };
CAST_IOMANIP(Block)
  class
Anchor : public Block{
  public:
  	Anchor(const char * const ref) : Block("a"){
		(Block&)*this << BlockOption( "HREF", ref);
		}
	CAST_INJECTORS(Anchor)
		Anchor&
	filter(const char * text){ ((Block&)*this).filter(text); return *this;}
	};
CAST_IOMANIP(Anchor)
	class
Html : public Block {
	friend ostream& operator << ( ostream& out, Html &html);
  protected:
	String title;
	int isIndex;
	static int responseHeader;
  public:
  	Html(const char * const _title, int _isIndex =0)
  		: Block("body"), title(_title), isIndex(_isIndex){};
	Html()
		: Block("body"), title(), isIndex(0){};
	static void noResponseHeader(){ responseHeader =0;}
	CAST_INJECTORS(Html)
	Html& operator << ( Block& b ) {
		((ostrstream&)(Block&)(*this)) << b ;
		return *this;
		}
		Html&
	filter(const char * text){ ((Block&)*this).filter(text); return *this;}
	};
CAST_IOMANIP(Html)
ostream& operator << ( ostream& out, Html &html);
#endif
