{
From: dissel@nunic.nu.edu (David S. Issel)
Modified by: Lief O'Pardy

To use it, simply put the USES CMDLINE; in your program.

Example1:  If you entered:  MYPROG /x/y/z="this is a test"
TurboPascal would respond:  ParamStr(x) Contents
                            =========== =================
                            1           /x/y/z="this
                            2           is
                            3           a
                            4           test"

My unit would respond:      1           /X
                            2           /Y
                            3           /Z=this is a test


Example2:  If you entered:  MYPROG file1,file2,file3
TurboPascal would respond:  ParamStr(x) Contents
                            =========== =================
                            1           file1,file2,file3

My unit would respond:      1           FILE1
                            2           FILE2
                            3           FILE3

My unit replaces the ParamCount variable and ParamStr() function.
The original TurboPascal routines are retained as System.ParamCount and
System.ParamStr()}

Unit CMDLINE;  { Written by David S. Issel, 1989 }

Interface  { public }

type
  string127 = string[127];

Var
  ParamCount:integer;

Function ParamStr(Param:word):string127;
{^ Just like TP's ParamStr.  But better. }
Function ScanParam(st:string127; casesen:boolean):boolean;
{^ Scan the command line for a certain "switch."
    st      = switch to search for.
    casesen = if TRUE then the string being searched for will have to match
              "st" exactly (any upper and lower case chars), otherwise the
              case will not matter. }


Implementation  { private }

uses doorio; {for upcasestr}

Var
  ParamArray:array[1..62] of string127;

{}
Function ScanParam; {added by lief o'pardy}
var i:byte; b:boolean;
begin
  b:=false;
  for i := 1 to ParamCount do begin
    if casesen then begin
      b:=(st=ParamStr(i));
    end else begin
      b:=(upcasestr(st)=upcasestr(ParamStr(i)));
    end;
    if b then break;
  end;
  ScanParam:=b;
end;
{}
Function ParamStr;
  begin
    if Param<=ParamCount
      then ParamStr:=ParamArray[Param]
      else ParamStr:='';
  end;
{}
Procedure SetupParamArray;
  var
    Index:word;
    WorkStr:string;
  procedure TxfrString;
    var
      SrchChar:string;
    begin
      SrchChar:=WorkStr[Index];
      Inc(Index);
      while (Index<=Length(WorkStr)) and (WorkStr[Index]<>SrchChar) do
        begin
          ParamArray[ParamCount]:=ParamArray[ParamCount]+WorkStr[Index];
          Inc(Index);
        end;
      if Index<=Length(WorkStr)
        then Inc(Index);
    end;
  begin
    ParamCount:=0;
    if System.ParamCount<1 then Exit;
    WorkStr:=System.ParamStr(1);
    if System.ParamCount>1
      then for Index:=2 to System.ParamCount do
              WorkStr:=WorkStr+' '+System.ParamStr(Index);
    Index:=1;
    repeat
      Inc(ParamCount);
      ParamArray[ParamCount]:='';
      if (WorkStr[Index]=#34) or (WorkStr[Index]=#39)
        then TxfrString
        else
          begin
            if WorkStr[Index]<>','
              then ParamArray[ParamCount]:=ParamArray[ParamCount]+
                                           Upcase(WorkStr[Index]);
            Inc(Index);
            if Index<=Length(WorkStr)
              then
                begin
                  while (Index<=Length(WorkStr)) and (WorkStr[Index]<>#47)
                      and (WorkStr[Index]<>#32) and (WorkStr[Index]<>#34)
                      and (WorkStr[Index]<>#39) and (WorkStr[Index]<>#44)
                    do
                      begin
                        ParamArray[ParamCount]:=ParamArray[ParamCount]+
                                                Upcase(WorkStr[Index]);
                        Inc(Index);
                      end;
                  if (Index<=Length(WorkStr)) and ((WorkStr[Index]=#34)
                      or (WorkStr[Index]=#39))
                    then TxfrString;
                end;
          end;
      while (Index<=Length(WorkStr)) and (WorkStr[Index]=#32) do
        Inc(Index);
    until Index>Length(WorkStr);
  end;

begin  { Initialization Code }
  SetupParamArray;
end.

