//====================== TestBroadcast ====================
/*
Filename:   TestBroadcast.java
Summary:    This illustrates the ability of Java to concisely
    "broadcast" messages to instances of different classes.
    This is done via use of an interface which each class that
    wants to be broadcast must implement. Interfaces replace pointers.
References: Based on concept suggested by Jeff Louie (73270,1776)
    See "Core Java", p 160 for simple interface example, and p 370 for
        how not to handle heterogeneous collections.
    See "Developing Professional Java Applets" p 46 for casting rules
Use Note:   This is a simple DOS command line application, not an
            applet. Modify class Broadcaster to run as an applet.
Discussion: All that Broadcaster needs to know to send messages to a
            heterogeneous collection is what <single> interface was used.
Author:     Jack Harich (76741,163) on 6/30/96
*/

import java.util.*;    // for the Vector class

public class TestBroadcast {
    public static void main(String args[]) {
        Broadcaster b = new Broadcaster();
        b.addItem(new ItemBox());
        b.addItem(new ItemCircle());
        b.drawAllItems();
    }
}
class Broadcaster {
    Vector items = new Vector();

    void addItem(VisualItem x) {
        items.addElement(x);
    }
    void drawAllItems() {
        VisualItem item;
        if (items.size() == 0)
            System.out.println("Nothing to draw");
        else {
            for (int i = 0;i < items.size();i++) {
                item = (VisualItem)items.elementAt(i);
                item.Draw();
            }
        }
    }
}
interface VisualItem {
    public void Draw();
}
class ItemBox implements VisualItem {
    public void Draw() {
        System.out.println("Draw a box");
    }
}
class ItemCircle implements VisualItem {
    public void Draw() {
        System.out.println("Draw a circle");
    }
}
