#include <i86.h>
#include <string.h>

#include "defines.hpp"
#include "mouse.hpp"

void MOUSE_GetMouseMoves ( MOUSE_SMouseMoves &M ) {
    union REGS Regs;
    struct SREGS SegRegs;
    memset ( &SegRegs , 0 , sizeof ( SegRegs ) );
    Regs.w.ax = 0x000b;
    int386x ( 0x33 , &Regs , &Regs , &SegRegs );
    M.MoveDX = Regs.w.cx;
    M.MoveDY = Regs.w.dx;
};

void MOUSE_GetButtonState ( MOUSE_SMouseButtons &M ) {
    union REGS Regs;
    struct SREGS SegRegs;
    memset ( &SegRegs , 0 , sizeof ( SegRegs ) );
    Regs.w.ax = 0x0003;
    int386x ( 0x33 , &Regs , &Regs , &SegRegs );
    
    if ( (Regs.w.bx & 0x0001) > 0 )
        M.LeftButton = True;
    else
        M.LeftButton = False;
        
    if ( (Regs.w.bx & 0x0002) > 0 )
        M.RightButton = True;
    else
        M.RightButton = False;
        
    if ( (Regs.w.bx & 0x0004) > 0 )
        M.MidButton = True;
    else
        M.MidButton = False;
};


