; MTMem - Memory to store mtdirs and mtprev[] for Move To (mt.com)
; Copyright Jason Hood 1996.
; Started:   5 May, 1996.
; Finished:  2 June.
;
; Usage: in the autoexec.bat file place these statements:
;        set mtmem=####
;        mtmem [d:/path] [;path] [;;path]
; Where: [d:/path] is the path to place the directory structure file.
;                  Default is the same path as mtmem.com.
;        [;path] is the initial previous directory.
;                Default is an empty string ("Directory does not exist.").
;        [;;path] is the initial before previous directory.
;                 Default as above.
;        The environment variable will be set to the segment address of the
;        allocated memory.
;
; Assumptions: all parameters are valid
;              environment variable MTMEM is set correctly, or not set at all
;              DOS 3.0+ (5.0+ for high memory)
;              Memory is available
;
; Acknowledgements: Ralf Brown's interrupt list for PSP/environment information
;                   and his AMIS.ASM for allocating memory.
;                   Howard Vigorita's ATIM.ASM for the paragraph length
;                   calculation.
;
; You are free to use this code, or a portion thereof, as long as an appropriate
; acknowledgement is made.
;
; Questions, suggestions and comments to hoodj@topaz.cqu.edu.au.

        .model  tiny
        .286p
        .code


MaxPath equ     80                      ; These values from dir.h
MaxDir  equ     66
len     equ     MaxPath + (2 * MaxDir)  ; Byte length to keep resident

intdos  MACRO   function, service
        IFB     <service>
        mov     ah, function
        ELSE
        mov     ax, (function shl 8) + service
        ENDIF
        int     21h
        ENDM

byt     equ     <byte ptr>
wrd     equ     <word ptr>
aamhex  equ     <db 0d4h, 10h>          ; Split AL into AH and AL (12h => 0102h)
aadhex  equ     <db 0d5h, 10h>          ; Merge AH and AL into AL (0102h => 12h)


        org     16h                     ; Segment address of parent
parent  dw      ?

        org     2ch                     ; Segment address of environment
env     dw      ?

        org     81h                     ; Where the commandline starts
cmdline db      ?

        org     100h                    ; Finally, the start of the program

start:  mov     prgseg, ds              ; Store the program's data segment
        cld                             ; String op's left-to-right

        mov     ax, parent              ; Obtain the parent PSP
        mov     ds, ax
        mov     ax, env                 ; Parent environment
        mov     es, ax
        mov     ds, ax
        xor     di, di                  ; First environment variable
        xor     al, al                  ; Null terminator
        mov     cx, 0ffffh              ; Ensure the entire env. is scanned

find:   cmp     byt [di], 'M'           ; Find 'MTMEM='
        je      rest                    ; Got the 'M', check the rest
scan:   repne   scasb                   ; Find the next env. variable
        cmp     byt [di], 0             ; There are no more
        jne     find

        mov     ds, cs:prgseg
        lea     dx, enverr              ; Tell the user to set
        intdos  9                       ; the environment variable
        ret                             ; and exit

rest:   IRPC    M, TMEM=
        inc     di
        cmp     byt [di], '&M&'
        jne     scan
        ENDM
        inc     di
        mov     cs:pathst, di           ; In case I have to search for path

        cmp     byt [di], '#'           ; Is it already installed?
        jne     installed

        mov     es, cs:prgseg           ; Restore ES to the program segment
        mov     bx, 1000h               ; Make the program the 64k it should be
        intdos  4ah
        intdos  58h, 2                  ; Get current UMB state
        push    ax                      ; and save it
        intdos  58h, 0                  ; Get current allocation strategy
        push    ax                      ; and save it
        mov     bx, 1                   ; Link in UMB
        intdos  58h, 3
        mov     bx, 81h                 ; Best fit high then low
        intdos  58h, 1
        mov     bx, (len + 15) shr 4    ; Number of paragraphs to keep
        intdos  48h                     ; Allocate the memory
        dec     ax
        mov     es,ax                   ; The MCB of the newly allocated memory
        inc     ax
        mov     word ptr es:[1],ax      ; Make the memory block own itself
        mov     dx, ds                  ; Save the environment pointer
        mov     bx, di
        mov     cx, cs
        dec     cx
        mov     ds, cx                  ; MCB of the program
        mov     si, 8
        mov     di, si
        movsw                           ; Copy the DOS 4.0+ program name into
        movsw                           ; the new memory block's MCB
        movsw
        movsw
        mov     ds, dx                  ; Retrieve the environment pointer
        mov     di, bx
        mov     dx, ax
        call    write                   ; Modify the environment variable
        pop     bx                      ; Restore allocation strategy
        intdos  58h, 1
        pop     bx                      ; Restore UMB state
        intdos  58h, 3
        jmp     finish

installed:                              ; The memory has already been allocated
        or      cs:flags, 110b          ; Don't create the previous directories
        call    read                    ; Get the segment into DX

finish: mov     es, dx                  ; Segment to place parameters
        mov     ds, cs:prgseg
        lea     si, cmdline
        cmp     byt [si], 0dh           ; No parameters
        je      done

param:  lodsb
        cmp     al, ' '                 ; Ignore spaces
        je      param
        cmp     al, 9                   ; and replace tabs
        jne     tstarg
        mov     byt [si-1], ' '         ; with a space
        jmp     param

tstarg: cmp     al, ';'                 ; Is it a previous directory?
        je      prev
        mov     di, 0                   ; Offset for directory structure path
        or      flags, 001b             ; Indicate a path was specified
        jmp     copy
prev:   lodsb
        cmp     al, ';'                 ; Before previous directory
        je      bprev
        mov     di, MaxPath             ; Offset for prev[0]
        or      flags, 010b
        jmp     copy
bprev:  lodsb
        mov     di, MaxPath+MaxDir      ; Offset for prev[1]
        or      flags, 100b

copy:   cmp     al, ' '                 ; End of this parameter
        je      null
        cmp     al, 0dh
        je      null
        stosb
        lodsb
        jmp     copy
null:   mov     byt es:[di], 0          ; Place the terminating null
        cmp     di, MaxPath             ; If copying the path
        jae     testsp                  ; point BX to its end
        mov     bx, di
testsp: cmp     al, ' '                 ; More parameters?
        je      param

done:   test    flags, 001b             ; Was a path entered?
        jnz     append                  ; Yes, so don't search for one

        mov     bx, es                  ; BX has the memory segment
        mov     ax, env                 ; Get the environment segment
        mov     dx, ax                  ; DX has the environment segment
        mov     es, ax
        mov     di, pathst              ; At the #### of MTMEM=####
        add     di, 4                   ; Point to its terminating null
        xor     al, al
        mov     cx, 0ffffh
envend: repne   scasb                   ; End of environment variable
        cmp     byt es:[di], 0          ; End of environment?
        jne     envend
        inc     di                      ; Point past the word stored after
        inc     di                      ; the environment variables to get
        inc     di                      ; the path of mtmem.com
        mov     si, 0                   ; Swap source and destination
        xchg    si, di                  ; for the copy
        mov     ds, dx
        mov     es, bx
mvpath: lodsb
        or      al, al                  ; Terminating null?
        jz      initap
        stosb
        cmp     al, '\'
        jne     mvpath
        mov     bx, di                  ; BX will point to "MTMEM.COM"
        jmp     mvpath

initap: mov     ds, cs:prgseg           ; Restore DS to the program segment
append: mov     di, bx                  ; The end of the path
        cmp     byt es:[di-1], '/'      ; Is there a trailing slash
        je      app
        cmp     byt es:[di-1], '\'      ; or backslash?
        je      app
        mov     byt es:[di], '/'        ; No, so add one
        inc     di
app:    lea     si, mtdirs              ; The filename to append
        movsw                           ; It's ten characters
        movsw                           ; which means five words
        movsw
        movsw
        movsw
        mov     byt es:[di], 0          ; Terminating null

        test    flags, 010b             ; Need to initialise the
        jnz     nxtprv                  ; previous directory
        mov     di, MaxPath
        mov     byt es:[di], 0
nxtprv: test    flags, 100b             ; Need to initialise the
        jnz     fin                     ; before previous directory
        mov     di, MaxPath+MaxDir
        mov     byt es:[di], 0

fin:    intdos  4ch                     ; Terminate the program


; Store dx at ds:di as a four digit hex number, but instead of using A to F,
; use :;<=>? (ie. 3Ah to 3Fh) to simplify processing.

write:  mov     al, dh
        aamhex
        or      ax, 3030h               ; Convert to ASCII
        xchg    al, ah                  ; Swap them around so they can
        mov     wrd [di], ax            ; be stored in the right order
        mov     al, dl
        aamhex
        or      ax, 3030h
        xchg    al, ah
        mov     wrd [di+2], ax
        ret

; Read the four digit hex number at ds:di and put it in dx. See above.
read:   mov     ax, wrd [di]            ; High word
        xchg    al, ah                  ; Restore the order
        and     ax, 0f0fh               ; Strip the ASCII
        aadhex
        mov     dh, al
        mov     ax, wrd [di+2]          ; Low word
        xchg    al, ah
        and     ax, 0f0fh
        aadhex
        mov     dl, al
        ret


prgseg  dw      ?                       ; The segment the program's in
pathst  dw      ?                       ; Where to start searching for the path
flags   db      0                       ; Bit 0 - 0 to find path
                                        ;     1 - 0 to init. previous dir.
                                        ;     2 - 0 to init. before prev. dir.
mtdirs  db      'MTDIRS.DAT'            ; Filename to append to path
enverr  db      13,10,'You must "SET MTMEM=####" before running this program.'
        db      13,10,10,'$'


end     start
