#include "inkey.ch"
#define MR maxrow()
#define MC maxcol()
#define bTBColor {b:rowPos, 1, b:rowPos, b:colCount}

memvar getlist

function AsciiView(FileToView,nWidth)
    local b, i
    local nKey
    local nRow     := row()
    local cTemp    := '$$$$0000.$$$'
    local nFile    := 10000
    local nRecs    := 0
    local oldcolor := setcolor( "w/b,n/w" )
       
    FileToView := rtrim(FileToView)

    CLEAR TYPEAHEAD

    if ! nWidth == Nil
        nWidth := VAL( nWidth )
    endif
    if nWidth == Nil .or. nWidth == 0
        nWidth := 120
    endif
    if ! nWidth % 20 == 0
        nWidth := (int(nWidth / 6) +1) * 6
    endif
    nWidth := max(nWidth,80)
    WHILE file(cTemp) 
        nFile++
        cTemp := '$$$$' + substr(str(nFile,5),2,4)
    ENDDO
    if nWidth <= 80
        DBcreate( cTemp, {{'VIEW1','C',nWidth,0}})
    else
        DBcreate( cTemp, {{'VIEW1','C',nWidth/6,0},;
                          {'VIEW2','C',nWidth/6,0},;
                          {'VIEW3','C',nWidth/6,0},;
                          {'VIEW4','C',nWidth/6,0},;
                          {'VIEW5','C',nWidth/6,0},;
                          {'VIEW6','C',nWidth/6,0}};
        )
    endif

    USE (cTemp) alias TEMP new

    if at(".",FileToView) = 0
        FileToView := FiletoView + ". "
        APPEND FROM ( FileToView ) SDF
    else
        APPEND FROM (strtran(FileToView, ' ')) SDF
    endif
    memory(0)
    @0,0
    b:= tbrowseDB(1,0,MR -1,MC)
    b:addcolumn(tbcolumnnew(,{|| temp->view1}))
    b:addcolumn(tbcolumnnew(,{|| temp->view2}))
    b:addcolumn(tbcolumnnew(,{|| temp->view3}))
    b:addcolumn(tbcolumnnew(,{|| temp->view4}))
    b:addcolumn(tbcolumnnew(,{|| temp->view5}))
    b:addcolumn(tbcolumnnew(,{|| temp->view6}))
    b:colorSpec:="W+/B,W/B,W+/N"
    b:colSep  := '' 
    goto top

    @0, 0
    @MR,0

    nRecs := reccount()

    while .T.
        b:colorRect(bTBColor,{1,1})
        dispbegin() 
        while !b:stabilize()
        enddo
        dispend()

        if b:stabilize()
            b:colorRect(bTBColor,{3,3})
        endif
       
        nKey := inkey(0)

        do case
            case nKey == K_UP
                b:up()
            case nKey == K_DOWN
                b:down()
            case nKey == K_LEFT
                b:left()
            case nKey == K_RIGHT
                b:right()
            case nKey == K_PGDN
                b:pageDown()
            case nKey == K_PGUP
                b:pageUp()
            case nKey == K_CTRL_PGDN
                b:goBottom()
            case nKey == K_CTRL_PGUP
                b:goTop()
            case nKey == K_HOME
                b:home()
            case nKey == K_END
                b:end()
            case nKey == K_CTRL_HOME
                b:panHome()
            case nKey == K_CTRL_END
                b:panEnd()
            case nKey == K_CTRL_LEFT
                b:panLeft()
            case nKey == K_CTRL_RIGHT
                b:panRight()
            case nKey == K_ESC
                EXIT
        endcase
    enddo

    temp->(dbclosearea())
    ferase(cTemp)
    setcolor(oldcolor)
return nil

FUNCTION Dec2Hex(nDec)
    LOCAL nTotal   := nDec
    LOCAL x        := 0
    LOCAL y        := 0
    LOCAL nHexPos  := 0
    LOCAL cHexChar := ""
    LOCAL cHexStr  := ""
    LOCAL cHexList := "123456789ABCDEF"

    for x = 1 to 10
        if (16 ** x) > nDec
            nHexPos = (x-1)
            exit
        endif
    next
    for x = nHexPos to 1 step -1
        cHexChar = "0"
        for y = 15 to 1 step -1
            if ( (16 ** x) * y ) <= nTotal
                cHexChar = substr(cHexList,y,1)
                nTotal = nTotal - ( (16 ** x) * y)
            endif
        next
        cHexStr += cHexChar
    next
    cHexChar = if(nTotal > 0, substr(cHexList,nTotal,1), "0")
    cHexStr += cHexChar
RETURN (cHexStr)

