/* zedit.h - declaration for ZEdit class    */

#ifndef __ZEDIT__
#define __ZEDIT__

class ZEdit: public CEdit
{
public:
    ZEdit (COLORREF cTextColor = 
      ::GetSysColor (COLOR_WINDOWTEXT), 
      COLORREF cBkColor = ::GetSysColor (COLOR_WINDOW));
    virtual ~ZEdit ();  
public:
    // Get, Set Properties.
    void SetTextColor (COLORREF cColor, 
                            BOOL bRedraw = TRUE);
    COLORREF GetTextColor () const 
                        { return m_cTextColor; }
    void SetBkColor (COLORREF cColor, 
                        BOOL bRedraw = TRUE);
    COLORREF GetBkColor () const { return m_cBkColor; }

// Redraws the control.
    void Redraw (void);

public:
#if (_MFC_VER < 0x0300)        // Required only for MFC 2.5
    WNDPROC* GetSuperWndProcAddr ();    
#endif

protected:
    DECLARE_DYNAMIC (ZEdit)

    // Handles the WM_CTLCOLOR message to set the 
     // text and background color.
    virtual BOOL OnChildNotify  (UINT message, 
            WPARAM wParam, LPARAM lParam, 
                LRESULT *pLResult);
    HBRUSH DoCtlColorProcessing (WPARAM wParam, 
            LPARAM lParam);
protected: // Implementation.
    COLORREF m_cTextColor, m_cBkColor;
    HBRUSH m_hBkBrush;
};

#endif // __ZEDIT__

